/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.manage.staff;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.core.framework.model.ResponseStateEnum;
import cn.smarthse.rho.modules.supervise.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.supervise.service.b.IBCompanyService;
import cn.smarthse.rho.modules.supervise.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.supervise.service.c.ICStaffService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.enums.lock.DistributedLockEnum;
import cn.smarthse.rho.modules.sys.enums.staff.StaffSourceEnum;
import cn.smarthse.rho.modules.sys.model.easyexcel.StaffImportAdminDto;
import cn.smarthse.rho.modules.sys.utils.staff.StaffUniqueReferenceUtil;
import com.alibaba.fastjson.JSON;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class StaffCompanyAssociationInfoImportManager {
    private static final Logger log = LoggerFactory.getLogger(StaffCompanyAssociationInfoImportManager.class);
    private final RedissonClient redissonClient;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final ICStaffService staffService;
    private final IBCompanyService companyService;
    public static final String IMPORT_ONE_STAFF_SUCCESS = "\u6210\u529f";
    public static final String IMPORT_ONE_STAFF_SUCCESS_EXIST = "\u6210\u529f_\u5df2\u5b58\u5728";

    public String importStaff(List<StaffImportAdminDto> importInfoList) {
        StringBuilder sb = new StringBuilder(DistributedLockEnum.IMPORT_STAFF_BATCH.getKey()).append(ShiroUtil.getLoginUserId());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(60L, 60L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                String e = this.importStaffLock(importInfoList);
                return e;
            }
            catch (ServiceException e) {
                throw e;
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw e;
            }
            finally {
                if (lock != null && lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        }
        log.error("{}\uff1aPending lock timeout\uff0cmethod:importStaff()", (Object)sb.toString());
        throw new ServiceException("\u6574\u4f53\u8d85\u65f6");
    }

    public String importStaffLock(List<StaffImportAdminDto> importInfoList) {
        StringBuilder sb = new StringBuilder();
        this.checkImportInfoList(importInfoList);
        ArrayList errorInfoList = new ArrayList();
        for (StaffImportAdminDto StaffImportAdminDto2 : importInfoList) {
            String string = this.importOneStaff(StaffImportAdminDto2);
        }
        return errorInfoList.size() > 0 ? JSON.toJSONString(errorInfoList) : null;
    }

    private void checkImportInfoList(List<StaffImportAdminDto> importInfoList) {
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, List<StaffImportAdminDto>> idcardMap = importInfoList.stream().filter(v -> StrUtil.isNotBlank((CharSequence)v.getIdcard())).collect(Collectors.groupingBy(v -> v.getIdcard()));
        idcardMap.forEach((idCard, list) -> {
            if (list.size() >= 2) {
                stringBuilder.append("\u8eab\u4efd\u8bc1").append((String)idCard).append("\u5728excel\u4e2d\u91cd\u590d\u5b58\u5728\uff0c\u5220\u9664\u91cd\u590d\u586b\u5199\u7684\u4eba\u5458\u4fe1\u606f\u3002");
            }
        });
        if (stringBuilder.length() > 0) {
            throw new ServiceException(stringBuilder.toString());
        }
        ArrayList<StaffImportAdminDto> errorInfoList = new ArrayList<StaffImportAdminDto>();
        for (StaffImportAdminDto dto : importInfoList) {
            StringBuilder sb = new StringBuilder();
            if (StrUtil.isBlank((CharSequence)dto.getCompanyName())) {
                sb.append("\u9662\u533a\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            } else {
                BCompany company = this.companyService.getCompanyByName(dto.getCompanyName());
                if (company == null) {
                    sb.append("\u9662\u533a\u4e0d\u5b58\u5728\u3002");
                }
            }
            if (StrUtil.isBlank((CharSequence)dto.getIdcard())) {
                sb.append("\u8eab\u4efd\u8bc1\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            } else {
                CStaff staff;
                CStaffBaseInfo staffBaseInfo = this.staffBaseInfoService.getByIdCard(dto.getIdcard());
                if (staffBaseInfo == null) {
                    throw new ServiceException("\u4eba\u5458\u4e0d\u5b58\u5728");
                }
                BCompany company = this.companyService.getCompanyByName(dto.getCompanyName());
                if (staffBaseInfo != null && company != null && (staff = this.staffService.getByBaseIdAndBranchCid(staffBaseInfo.getId(), company.getId())) != null && !staff.getCid().equals(company.getId())) {
                    sb.append("\u8be5\u4eba\u5458\u5df2\u7ecf\u5728\u5176\u4ed6\u9662\u533a\u3002");
                }
            }
            if (sb.length() <= 0) continue;
            dto.setHaveError(Boolean.valueOf(true));
            dto.setErrorReason(sb.toString());
            errorInfoList.add(dto);
        }
        if (errorInfoList.size() > 0) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u5bfc\u5165\u5931\u8d25\u00b7\uff0c\u8bf7\u6839\u636e\u9519\u8bef\u4fe1\u606f\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165", (Object)JSON.toJSONString(errorInfoList));
        }
    }

    @Transactional
    public String importOneStaff(StaffImportAdminDto StaffImportAdminDto2) {
        StringBuilder sb = new StringBuilder(DistributedLockEnum.EDIT_STAFF_INFO.getKey()).append(StaffImportAdminDto2.getIdcard());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(5L, 5L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                String e = this.importOneStaffLock(StaffImportAdminDto2);
                return e;
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw e;
            }
            finally {
                if (lock != null && lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        }
        StringBuilder errInfo = new StringBuilder();
        errInfo.append("\u5bfc\u5165\u8d85\u65f6");
        log.error("{}\uff1aPending lock timeout\uff0cmethod:importStaff()", (Object)sb.toString());
        return errInfo.toString();
    }

    @Transactional
    public String importOneStaffLock(StaffImportAdminDto dto) {
        CStaffBaseInfo db = this.staffBaseInfoService.getByIdCard(dto.getIdcard());
        if (db == null) {
            throw new ServiceException("\u4eba\u5458\u4e0d\u5b58\u5728");
        }
        BCompany company = this.companyService.getCompanyByName(dto.getCompanyName());
        CStaff staffDB = this.staffService.getByBaseIdAndCid(db.getId(), company.getId());
        if (staffDB != null) {
            return IMPORT_ONE_STAFF_SUCCESS_EXIST;
        }
        CStaff staff = new CStaff();
        staff.setBaseId(db.getId());
        staff.setCid(company.getId());
        staff.setStaffType(Integer.valueOf(1));
        staff.setEditTime(LocalDateTime.now());
        staff.setSource(StaffSourceEnum.ADMIN_IMPORT_OTHER.getValue());
        staff.setUniqueReference(StaffUniqueReferenceUtil.genUniqueReference((String)company.getCreditCode(), (Long)staff.getBaseId()));
        this.staffService.save(staff);
        return IMPORT_ONE_STAFF_SUCCESS;
    }

    public StaffCompanyAssociationInfoImportManager(RedissonClient redissonClient, ICStaffBaseInfoService staffBaseInfoService, ICStaffService staffService, IBCompanyService companyService) {
        this.redissonClient = redissonClient;
        this.staffBaseInfoService = staffBaseInfoService;
        this.staffService = staffService;
        this.companyService = companyService;
    }
}

