/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.manage.home;

import cn.hutool.core.collection.ListUtil;
import cn.smarthse.rho.modules.supervise.model.home.param.HomeVisualizationDataParam;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeVisualizationCompanyDataVo;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeVisualizationMonitoringDataVo;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeVisualizationRiskDataVo;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeVisualizationRiskRankDataVo;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeVisualizationStaffDataVo;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeVisualizationStaffWarningDataVo;
import cn.smarthse.rho.modules.supervise.model.home.vo.HomeVisualizationSubjectDataVo;
import cn.smarthse.rho.modules.supervise.service.b.IBCompanyService;
import cn.smarthse.rho.modules.supervise.service.b.IBStatisticService;
import cn.smarthse.rho.modules.supervise.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.supervise.service.e.IEdeviceService;
import cn.smarthse.rho.modules.supervise.service.r.IRRiskBasicService;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysAreaProvider;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;

@Component
public class HomeVisualizationManager {
    private static final Logger log = LoggerFactory.getLogger(HomeVisualizationManager.class);
    private final IBCompanyService companyService;
    private final IBStatisticService bStatisticService;
    private final ICStaffBaseInfoService staffBaseInfoService;
    private final IEdeviceService deviceService;
    private final IRRiskBasicService riskBasicService;
    @DubboReference
    private ISysAreaProvider sysAreaProvider;

    public HomeVisualizationCompanyDataVo getHomeVisualizationDataWithCompany(HomeVisualizationDataParam param) {
        return this.companyService.getHomeVisualizationData(param);
    }

    public HomeVisualizationSubjectDataVo getHomeVisualizationDataWithSubject(HomeVisualizationDataParam param) {
        return this.companyService.getHomeVisualizationDataWithSubject(param);
    }

    public HomeVisualizationStaffDataVo getHomeVisualizationDataWithRayStaffNum(HomeVisualizationDataParam param) {
        return this.staffBaseInfoService.getHomeVisualizationDataWithRayStaffNum(param);
    }

    public HomeVisualizationStaffWarningDataVo getHomeVisualizationDataWithWarningNum(HomeVisualizationDataParam param) {
        return this.staffBaseInfoService.getHomeVisualizationDataWithWarningNum(param);
    }

    public List<HomeVisualizationMonitoringDataVo> getHomeVisualizationDataWithMonitoringDeviceNum(HomeVisualizationDataParam param) {
        return this.deviceService.getHomeVisualizationDataWithMonitoringDeviceNum(param);
    }

    public HomeVisualizationRiskDataVo getHomeVisualizationDataWithRisk(HomeVisualizationDataParam param) {
        HomeVisualizationRiskDataVo vo1 = this.riskBasicService.getHomeVisualizationDataWithRisk(param);
        HomeVisualizationRiskDataVo vo1LastWeek = this.riskBasicService.getHomeVisualizationDataWithLastWeekRisk(param);
        HomeVisualizationRiskDataVo vo2 = this.riskBasicService.getHomeVisualizationDataWithCompany(param);
        HomeVisualizationRiskDataVo homeVisualizationRiskDataVo = vo1 = vo1 == null ? new HomeVisualizationRiskDataVo() : vo1;
        if (vo2 != null) {
            vo1.setNeedCompanyNum(vo2.getNeedCompanyNum());
            vo1.setResolvedCompanyNum(vo2.getResolvedCompanyNum());
            vo1.setUnresolvedCompanyNum(vo2.getUnresolvedCompanyNum());
        }
        if (vo1LastWeek != null) {
            vo1.setLastWeekRisk(vo1LastWeek.getLastWeekRisk());
            vo1.setLastWeekResolvedRiskNum(vo1LastWeek.getLastWeekResolvedRiskNum());
            vo1.setLastWeekUnresolvedRiskNum(vo1LastWeek.getLastWeekUnresolvedRiskNum());
        }
        return vo1;
    }

    public HomeVisualizationRiskRankDataVo getHomeVisualizationDataWithRiskRank(HomeVisualizationDataParam param) {
        HomeVisualizationRiskRankDataVo rank = new HomeVisualizationRiskRankDataVo();
        SysAreaVo area = this.sysAreaProvider.getAreaById(param.getAreaId());
        if (area == null) {
            throw new ServiceException("\u533a\u57df\u4e0d\u5b58\u5728");
        }
        Integer rankIndex = null;
        if (area.getLevel() == 0) {
            rankIndex = 1;
        } else if (area.getLevel() > 0) {
            SysAreaVo parentArea = this.sysAreaProvider.getAreaById(area.getParentId());
            if (parentArea == null) {
                throw new ServiceException("\u4e0a\u4e00\u7ea7\u533a\u57df\u4e0d\u5b58\u5728");
            }
            HomeVisualizationDataParam rankParam = new HomeVisualizationDataParam();
            BeanUtils.copyProperties((Object)param, (Object)rankParam);
            rankParam.setAreaId(parentArea.getId());
            rankParam.setLevel(parentArea.getLevel());
            rankParam.setIsOnlineSpecialTestUser(param.getIsOnlineSpecialTestUser());
            List list = this.riskBasicService.getHomeVisualizationDataWithRiskList(rankParam);
            list = ListUtil.sortByProperty(list, (String)"rankWeight");
            for (int i = 0; i < list.size(); ++i) {
                if (!((HomeVisualizationRiskDataVo)list.get(i)).getAreaId().equals(param.getAreaId())) continue;
                rankIndex = i + 1;
                break;
            }
        }
        rank.setRank(rankIndex == null ? "-" : String.valueOf(rankIndex));
        HomeVisualizationRiskDataVo resolutionRate = this.riskBasicService.getHomeVisualizationDataWithRisk(param);
        if (resolutionRate != null) {
            rank.setResolutionRate(resolutionRate.getResolutionRate());
        }
        return rank;
    }

    public HomeVisualizationManager(IBCompanyService companyService, IBStatisticService bStatisticService, ICStaffBaseInfoService staffBaseInfoService, IEdeviceService deviceService, IRRiskBasicService riskBasicService) {
        this.companyService = companyService;
        this.bStatisticService = bStatisticService;
        this.staffBaseInfoService = staffBaseInfoService;
        this.deviceService = deviceService;
        this.riskBasicService = riskBasicService;
    }
}

