/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.easyexcel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.PhoneUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.util.easyExcel.ExcelUtils;
import cn.smarthse.core.framework.model.ResponseStateEnum;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.enums.sys.UserRolesEnum;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.OrganizationUserV3ImportDto;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.OrganizationUserV3ListParam;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.vo.sys.v3.organization.OrganizationUserV3ListVo;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysOrganizationUserImportListener
extends AnalysisEventListener<OrganizationUserV3ImportDto> {
    private static final Logger log = LoggerFactory.getLogger(SysOrganizationUserImportListener.class);
    private static final int BATCH_COUNT = 3000;
    private static final Map<String, Boolean> roleMap = new HashMap<String, Boolean>();
    private final IOrganizationUserService organizationUserService;
    private final IOrganizationService organizationService;
    private final Long loginUserId;
    private final List<OrganizationUserV3ImportDto> dataList = new ArrayList<OrganizationUserV3ImportDto>();
    private final List<OrganizationUserV3ImportDto> errDataList = new ArrayList<OrganizationUserV3ImportDto>();
    private final List<Long> idList = new ArrayList<Long>();
    private int dataCount = 0;
    private int rowIndex = 3;

    public SysOrganizationUserImportListener(IOrganizationUserService service, IOrganizationService organizationService, Long loginUserId) {
        this.organizationUserService = service;
        this.organizationService = organizationService;
        this.loginUserId = loginUserId;
    }

    public void invoke(OrganizationUserV3ImportDto dto, AnalysisContext context) {
        log.debug("\u89e3\u6790\u5230\u4e00\u6761\u6570\u636e:{}", (Object)dto);
        if (StrUtil.isBlank((CharSequence)dto.getOname())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u7528\u6237\u6240\u5728\u5355\u4f4d\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", ExcelUtils.getExcelColName((int)1)));
        }
        if (StrUtil.isBlank((CharSequence)dto.getRoleName())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u89d2\u8272\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", ExcelUtils.getExcelColName((int)2)));
        }
        if (StrUtil.isBlank((CharSequence)dto.getUsername())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u7528\u6237\u540d\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", ExcelUtils.getExcelColName((int)3)));
        }
        if (StrUtil.isBlank((CharSequence)dto.getFullName())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u59d3\u540d\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", ExcelUtils.getExcelColName((int)4)));
        }
        if (Objects.isNull(dto.getTel())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u624b\u673a\u53f7\u4e3a\u5fc5\u586b\u9879\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", ExcelUtils.getExcelColName((int)5)));
        } else if (!PhoneUtil.isMobile((CharSequence)dto.getTel())) {
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u624b\u673a\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01", ExcelUtils.getExcelColName((int)5)));
        }
        dto.setId(Long.valueOf(IdWorker.getId()));
        dto.setRowIndex(Integer.valueOf(this.rowIndex));
        ++this.rowIndex;
        ++this.dataCount;
        if (Boolean.TRUE.equals(dto.getHaveError())) {
            this.errDataList.add(dto);
        } else {
            this.dataList.add(dto);
        }
        if (this.dataCount >= 3000) {
            this.saveData();
            this.dataList.clear();
            this.dataCount = 0;
        }
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        log.debug("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
        this.saveData();
    }

    private void saveData() {
        if (CollUtil.isEmpty(this.errDataList) && CollUtil.isEmpty(this.dataList)) {
            OrganizationUserV3ImportDto dto = new OrganizationUserV3ImportDto();
            dto.setHaveError(Boolean.TRUE);
            dto.setErrorReason("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a");
            this.errDataList.add(dto);
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), ResponseStateEnum.fail_deal.getName(), this.errDataList);
        }
        if (CollUtil.isNotEmpty(this.errDataList)) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), ResponseStateEnum.fail_deal.getName(), this.errDataList);
        }
        log.debug("{}\u6761\u6570\u636e\uff0c\u5f00\u59cb\u5b58\u50a8\u6570\u636e\u5e93\uff01", (Object)this.dataList.size());
        try {
            if (CollUtil.isNotEmpty(this.dataList)) {
                Set usernameSet = this.dataList.stream().map(OrganizationUserV3ImportDto::getUsername).collect(Collectors.toSet());
                if (usernameSet.size() < this.dataList.size()) {
                    OrganizationUserV3ImportDto dto = new OrganizationUserV3ImportDto();
                    dto.setHaveError(Boolean.TRUE);
                    dto.setErrorReason("Excel\u5217\u8868\u4e2d\u5b58\u5728\u91cd\u590d\u7528\u6237\u540d");
                    this.errDataList.add(dto);
                    throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), ResponseStateEnum.fail_deal.getName(), this.errDataList);
                }
                List allOrgList = this.organizationService.getAllOrg();
                Map<Object, Object> allOrgMap = new HashMap();
                if (CollUtil.isNotEmpty((Collection)allOrgList)) {
                    allOrgMap = allOrgList.stream().collect(Collectors.groupingBy(Organization::getName));
                }
                OrganizationUserV3ListParam param = new OrganizationUserV3ListParam();
                param.setPage(1);
                param.setRows(Integer.MAX_VALUE);
                param.setCount(Boolean.FALSE);
                List organizationUserV3AllList = this.organizationUserService.getOrganizationUserList(param).getRows();
                Map<Object, Object> organizationUserV3UsernameAllMap = new HashMap();
                if (CollUtil.isNotEmpty((Collection)organizationUserV3AllList)) {
                    organizationUserV3UsernameAllMap = organizationUserV3AllList.stream().collect(Collectors.groupingBy(OrganizationUserV3ListVo::getUsername));
                }
                for (OrganizationUserV3ImportDto dto : this.dataList) {
                    List orgList = (List)allOrgMap.get(dto.getOname());
                    if (CollUtil.isEmpty((Collection)orgList)) {
                        dto.setHaveError(Boolean.TRUE);
                        dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u7ec4\u7ec7\u5355\u4f4d\u540d\u79f0\u4e0d\u5b58\u5728\uff01", ExcelUtils.getExcelColName((int)1)));
                    } else {
                        dto.setOid(((Organization)orgList.get(0)).getId());
                    }
                    if (!roleMap.containsKey(dto.getRoleName())) {
                        dto.setHaveError(Boolean.TRUE);
                        dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u89d2\u8272\u4e0d\u5b58\u5728\uff01", ExcelUtils.getExcelColName((int)2)));
                    } else if (CollUtil.isNotEmpty((Collection)orgList)) {
                        UserRolesEnum rolesEnum = UserRolesEnum.getByAreaLevelAndIsAdminLte10((Byte)((Organization)orgList.get(0)).getLevel().byteValue(), (boolean)roleMap.get(dto.getRoleName()));
                        if (Objects.nonNull(rolesEnum)) {
                            List userList;
                            dto.setIsManger(Boolean.valueOf(rolesEnum.isAdmin()));
                            dto.setRole(Long.valueOf(rolesEnum.getValue().byteValue()));
                            if (Objects.nonNull(dto.getOid()) && Boolean.TRUE.equals(dto.getIsManger()) && CollUtil.isNotEmpty((Collection)(userList = this.organizationUserService.getUserInfoListByOid(dto.getOid()))) && userList.stream().anyMatch(i -> Boolean.TRUE.equals(i.getIsManger()))) {
                                dto.setHaveError(Boolean.TRUE);
                                dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u7ec4\u7ec7\u5355\u4f4d\u5df2\u5b58\u5728\u7ba1\u7406\u5458\u7528\u6237\uff01", ExcelUtils.getExcelColName((int)2)));
                            }
                        } else {
                            dto.setHaveError(Boolean.TRUE);
                            dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u51fa\u73b0\u5f02\u5e38\u4e86\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u4eba\u5458\u786e\u8ba4\uff01", ExcelUtils.getExcelColName((int)2)));
                        }
                    }
                    List organizationUserV3ListVos1 = (List)organizationUserV3UsernameAllMap.get(dto.getUsername());
                    if (CollUtil.isNotEmpty((Collection)organizationUserV3ListVos1)) {
                        dto.setHaveError(Boolean.TRUE);
                        dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u8be5\u7528\u6237\u540d\u5df2\u88ab\u5176\u4ed6\u4eba\u4f7f\u7528\uff01", ExcelUtils.getExcelColName((int)3)));
                    }
                    if (Objects.isNull(this.organizationUserService.getAccountIdByTel(dto.getTel()))) {
                        dto.setHaveError(Boolean.TRUE);
                        dto.setErrorReason(dto.getErrorReason() + String.format("\u7b2c%s\u5217\uff0c\u65e0\u6cd5\u7ed1\u5b9a\u672a\u6388\u6743\u7684\u6d59\u653f\u9489\u624b\u673a\u53f7\uff01", ExcelUtils.getExcelColName((int)5)));
                    }
                    if (Boolean.TRUE.equals(dto.getHaveError())) {
                        this.errDataList.add(dto);
                        continue;
                    }
                    dto.setLoginUserId(this.loginUserId);
                    this.idList.add(dto.getId());
                }
                if (CollUtil.isNotEmpty(this.errDataList)) {
                    throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), ResponseStateEnum.fail_deal.getName(), this.errDataList);
                }
                this.organizationUserService.importOrganizationUserData(this.dataList);
            }
        }
        catch (Exception e) {
            this.organizationUserService.rollbackImportUserData(this.idList, this.loginUserId);
            throw e;
        }
        log.debug("\u5b58\u50a8\u6570\u636e\u5e93\u6210\u529f\uff01");
    }

    static {
        roleMap.put("\u7ba1\u7406\u5458", Boolean.TRUE);
        roleMap.put("\u666e\u901a\u7528\u6237", Boolean.FALSE);
    }
}

