/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.easyexcel;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.supervise.manage.staff.StaffCompanyAssociationInfoImportManager;
import cn.smarthse.rho.modules.sys.model.easyexcel.StaffImportAdminDto;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaffCompanyAssociationInfoImportListener
extends AnalysisEventListener<StaffImportAdminDto> {
    private static final Logger log = LoggerFactory.getLogger(StaffCompanyAssociationInfoImportListener.class);
    private static final int BATCH_COUNT = 3000;
    private List<StaffImportAdminDto> cachedDataList = new ArrayList<StaffImportAdminDto>();
    private List<String> resultInfo;
    private StaffCompanyAssociationInfoImportManager staffImportManager;

    public StaffCompanyAssociationInfoImportListener(StaffCompanyAssociationInfoImportManager staffImportManager, List<String> resultInfo) {
        this.staffImportManager = staffImportManager;
        this.resultInfo = resultInfo;
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        super.onException(exception, context);
    }

    public void invoke(StaffImportAdminDto data, AnalysisContext context) {
        log.info("\u89e3\u6790\u5230\u4e00\u6761\u6570\u636e:{}", (Object)JSON.toJSONString((Object)data));
        data.setRowIndex(Integer.valueOf(context.readRowHolder().getRowIndex() + 1));
        data.setExcelRowIndex(context.readRowHolder().getRowIndex());
        this.cachedDataList.add(data);
        if (this.cachedDataList.size() >= 3000) {
            this.saveData();
            this.cachedDataList = new ArrayList<StaffImportAdminDto>();
        }
    }

    private void saveData() {
        log.info("{}\u6761\u6570\u636e\uff0c\u5f00\u59cb\u5b58\u50a8\u6570\u636e\u5e93\uff01", (Object)this.cachedDataList.size());
        String s = this.staffImportManager.importStaff(this.cachedDataList);
        if (StrUtil.isNotBlank((CharSequence)s)) {
            this.resultInfo.add(s);
        }
        log.info("\u5b58\u50a8\u6570\u636e\u5e93\u6210\u529f\uff01");
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.saveData();
        log.info("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
    }
}

