/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.easyexcel;

import cn.smarthse.rho.modules.sys.model.easyexcel.CycleLicenseImportDto;
import cn.smarthse.rho.modules.sys.provider.company.ICycleLicenseProvider;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import java.util.ArrayList;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CycleLicenseImportListener
extends AnalysisEventListener<CycleLicenseImportDto> {
    private static final Logger log = LoggerFactory.getLogger(CycleLicenseImportListener.class);
    private static final int BATCH_COUNT = 10000;
    private List<CycleLicenseImportDto> cachedDataList = new ArrayList<CycleLicenseImportDto>();
    private ICycleLicenseProvider cycleLicenseProvider;

    public CycleLicenseImportListener(ICycleLicenseProvider cycleLicenseProvider) {
        this.cycleLicenseProvider = cycleLicenseProvider;
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        super.onException(exception, context);
    }

    public void invoke(CycleLicenseImportDto data, AnalysisContext context) {
        data.setRowIndex(Integer.valueOf(context.readRowHolder().getRowIndex() + 1));
        data.setExcelRowIndex(context.readRowHolder().getRowIndex());
        this.cachedDataList.add(data);
        if (this.cachedDataList.size() >= 10000) {
            throw new ServiceException("\u4e00\u6b21\u6027\u53ea\u80fd\u5ba1\u683810000\u6761");
        }
    }

    private void saveData() {
        log.info("{}\u6761\u6570\u636e\uff0c\u5f00\u59cb\u5ba1\u6838\uff01", (Object)this.cachedDataList.size());
        this.cycleLicenseProvider.importCycleLicense(this.cachedDataList);
        log.info("\u5b58\u50a8\u6570\u636e\u5e93\u6210\u529f\uff01");
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.saveData();
        log.info("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
    }
}

