/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.easyexcel;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.sys.model.easyexcel.CompanyImportDto;
import cn.smarthse.rho.modules.sys.provider.company.ICompanyProvider;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import java.util.ArrayList;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompanyImportListener
extends AnalysisEventListener<CompanyImportDto> {
    private static final Logger log = LoggerFactory.getLogger(CompanyImportListener.class);
    private static final int BATCH_COUNT = 10000;
    private List<CompanyImportDto> cachedDataList = new ArrayList<CompanyImportDto>();
    private ICompanyProvider companyImportManager;

    public CompanyImportListener(ICompanyProvider companyImportManager) {
        this.companyImportManager = companyImportManager;
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        super.onException(exception, context);
    }

    public void invoke(CompanyImportDto data, AnalysisContext context) {
        data.setRowIndex(Integer.valueOf(context.readRowHolder().getRowIndex() + 1));
        data.setExcelRowIndex(context.readRowHolder().getRowIndex());
        if (StrUtil.isBlank((CharSequence)data.getIsTestRun())) {
            data.setIsTestRun("\u5426");
        }
        if (StrUtil.isBlank((CharSequence)data.getHospitalName())) {
            data.setHospitalName(data.getName());
        }
        data.setName(StrUtil.trim((CharSequence)data.getName()));
        data.setCreditCode(StrUtil.trim((CharSequence)data.getCreditCode()));
        data.setMedicalNucode(StrUtil.trim((CharSequence)data.getMedicalNucode()));
        data.setArea(StrUtil.isNotBlank((CharSequence)data.getArea()) && !StrUtil.contains((CharSequence)data.getArea(), (CharSequence)"\u7701") ? "\u6d59\u6c5f\u7701>" + data.getArea() : data.getArea());
        data.setRegisterArea(StrUtil.isNotBlank((CharSequence)data.getRegisterArea()) && !StrUtil.contains((CharSequence)data.getRegisterArea(), (CharSequence)"\u7701") ? "\u6d59\u6c5f\u7701>" + data.getRegisterArea() : data.getRegisterArea());
        data.setRegisterArea(StrUtil.isBlank((CharSequence)data.getRegisterArea()) ? "\u6d59\u6c5f\u7701>" : data.getRegisterArea());
        this.cachedDataList.add(data);
        if (this.cachedDataList.size() >= 10000) {
            throw new ServiceException("\u4e00\u6b21\u6027\u53ea\u80fd\u5bfc\u516510000\u6761");
        }
    }

    private void saveData() {
        log.info("{}\u6761\u6570\u636e\uff0c\u5f00\u59cb\u5b58\u50a8\u6570\u636e\u5e93\uff01", (Object)this.cachedDataList.size());
        this.companyImportManager.importCompany(this.cachedDataList);
        log.info("\u5b58\u50a8\u6570\u636e\u5e93\u6210\u529f\uff01");
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.saveData();
        log.info("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
    }
}

