/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.controller.trainingManage;

import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.model.IdParam;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.supervise.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.supervise.easyexcel.config.ExcelCellWidthStyleStrategy;
import cn.smarthse.rho.modules.supervise.model.c.param.RadiationTrainingParam;
import cn.smarthse.rho.modules.supervise.model.c.vo.RadiationTrainingCertVo;
import cn.smarthse.rho.modules.supervise.model.c.vo.RadiationTrainingListVo;
import cn.smarthse.rho.modules.supervise.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.supervise.service.c.ICTrainingService;
import cn.smarthse.rho.modules.sys.entity.sys.SysBusinessOperateLog;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogModuleEnum;
import cn.smarthse.rho.modules.sys.model.c.param.CTrainingCertPageParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysBusinessOperateLogParam;
import cn.smarthse.rho.modules.sys.provider.sys.ISysBusinessOperateLogProvider;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1302, author="wuxq")
@Api(tags={"\u5728\u7ebf\u57f9\u8bad\u7ba1\u7406\u6863\u6848\uff1a\u653e\u5c04\u9632\u62a4\u57f9\u8bad\u6863\u6848"})
@RestController
@RequestMapping(value={"/radiationTrainingManage"})
public class RadiationTrainingManageController
extends ControllerSupport {
    private final ICTrainingService trainingService;
    private final ICTrainingCertService trainingCertService;
    @DubboReference
    private ISysBusinessOperateLogProvider sysBusinessOperateLogProvider;

    @ApiOperation(value="\u5217\u8868")
    @GetMapping(value={"/getListData"})
    @RequiresPermissions(value={"train.archives.view"})
    public ResponseData<LayuiGridData<RadiationTrainingListVo>> getRadiationTrainingListData(RadiationTrainingParam param) {
        if (param.getAreaId() == null) {
            param.setAreaId(ShiroUtil.getLoginUserAreaId());
        }
        return ResponseData.success(this.trainingService.getRadiationTrainingListData(param));
    }

    @ApiOperation(value="\u4eba\u5458\u8bc1\u4e66\u5217\u8868\uff08\u4f20sourceTrainingId\uff09")
    @GetMapping(value={"/getTrainingCertList"})
    @RequiresPermissions(value={"train.archives.view"})
    public ResponseData<LayuiGridData<RadiationTrainingCertVo>> getTrainingCertList(CTrainingCertPageParam param) {
        return ResponseData.success(this.trainingCertService.getTrainingCertList(param));
    }

    @ApiOperation(value="\u4eba\u5458\u8bc1\u4e66\u8be6\u60c5")
    @GetMapping(value={"/getTrainingCertDetail"})
    @RequiresPermissions(value={"train.archives.view"})
    public ResponseData<RadiationTrainingCertVo> getTrainingCertDetail(IdParam param) {
        return ResponseData.success((Object)this.trainingCertService.getTrainingCertDetail(param.getId()));
    }

    @ApiOperation(value="\u64cd\u4f5c\u8bb0\u5f55\u5217\u8868")
    @GetMapping(value={"/getOperateLogListData"})
    @RequiresPermissions(value={"train.archives.view"})
    public ResponseData<LayuiGridData<SysBusinessOperateLog>> getOperateLogListData(SysBusinessOperateLogParam param) {
        param.setModule(SysBusinessOperateLogModuleEnum.RADIATION_TRAIN_1.getValue());
        return ResponseData.success((Object)this.sysBusinessOperateLogProvider.getPageListData(param));
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @GetMapping(value={"export"}, produces={"application/octet-stream"})
    @RequiresPermissions(value={"train.archives.view"})
    public void export(HttpServletResponse response, CTrainingCertPageParam param) {
        param.setLimit(Integer.MAX_VALUE);
        List list = this.trainingCertService.getTrainingCertList(param).getData();
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode(String.format("\u653e\u5c04\u536b\u751f\u57f9\u8bad\u4eba\u5458\u8bc1\u4e66\u4fe1\u606f\u8868%s.xlsx", LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)), "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName);
            ((ExcelWriterSheetBuilder)((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), RadiationTrainingCertVo.class).registerWriteHandler((WriteHandler)new ExcelCellWidthStyleStrategy())).sheet("Sheet1").relativeHeadRowIndex(Integer.valueOf(0))).doWrite((Collection)list);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RadiationTrainingManageController(ICTrainingService trainingService, ICTrainingCertService trainingCertService) {
        this.trainingService = trainingService;
        this.trainingCertService = trainingCertService;
    }
}

