/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.controller.sys;

import cn.hutool.core.io.resource.ResourceUtil;
import cn.smarthse.common.annotation.password.OperatorDataSourceEnum;
import cn.smarthse.common.encrypt.annotation.ApiEncrypt;
import cn.smarthse.common.framework.jqgrid.JqGridData;
import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.annotation.SysExportLog;
import cn.smarthse.core.framework.annotation.SysExportLogBusinessTypeEnum;
import cn.smarthse.core.framework.bean.OssClientBean;
import cn.smarthse.core.framework.model.IdParam;
import cn.smarthse.core.framework.model.IdsParam;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.enums.sys.UserSystemWideEnum;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.OrganizationUserV3AddParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.OrganizationUserV3EditParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.OrganizationUserV3ImportDto;
import cn.smarthse.modules.health.supervise.model.sys.v3.organization.OrganizationUserV3ListParam;
import cn.smarthse.modules.health.supervise.model.sys.v3.role.SysRoleV3ListParam;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysRoleV3Service;
import cn.smarthse.modules.health.supervise.vo.sys.v3.organization.OrganizationUserV3ListVo;
import cn.smarthse.modules.health.supervise.vo.sys.v3.role.SysRoleV3SelectVo;
import cn.smarthse.rho.modules.supervise.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.supervise.easyexcel.SysOrganizationUserImportListener;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.support.ExcelTypeEnum;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.fill.FillConfig;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;
import javax.smarthse.framework.exception.ServiceException;
import javax.validation.constraints.NotNull;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1701, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u7cfb\u7edf\u6a21\u5757\uff1a\u76d1\u7ba1\u7528\u6237"})
@RestController
@RequestMapping(value={"/sys/orgUser"})
@Validated
public class SysOrgUserController
extends ControllerSupport {
    private final OssClientBean ossClientBean;
    @DubboReference
    private ISysFileProvider sysFileProvideService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationService organizationService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationUserService organizationUserService;
    @DubboReference(registry={"public_nacos"})
    private ISysRoleV3Service sysRoleV3Service;

    @RequiresPermissions(value={"sys.supuser.view"})
    @ApiOperation(value="\u5217\u8868")
    @GetMapping(value={"getList"})
    public ResponseData<JqGridData<OrganizationUserV3ListVo>> getList(@Validated OrganizationUserV3ListParam param) {
        this.setSearchListParam(param);
        return ResponseData.success((Object)this.organizationUserService.getOrganizationUserList(param));
    }

    private void setSearchListParam(OrganizationUserV3ListParam param) {
        param.setIsOnlineSpecialTestUser(ShiroUtil.isOnlineSpecialSuperAndTestUser());
        param.setUserAreaId(ShiroUtil.getLoginUserAreaId());
        param.setUserAreaLevel(ShiroUtil.getLoginUserAreaLevel());
        Optional.ofNullable(param.getSearchAreaId()).map(arg_0 -> ((ISysAreaProvideService)this.sysAreaProvideService).getAreaByIdV3(arg_0)).ifPresent(area -> param.setSearchAreaLevel(area.getLevel()));
        param.setLoginUserId(ShiroUtil.getLoginUserId());
        param.setOrgId(ShiroUtil.getLoginUserOid());
    }

    @RequiresPermissions(value={"sys.supuser.edit"})
    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"save"})
    public ResponseData<String> save(@Validated @RequestBody OrganizationUserV3AddParam param) {
        param.setLoginUserId(ShiroUtil.getLoginUserId());
        param.setLoginUserAreaId(ShiroUtil.getLoginUserAreaId());
        return this.organizationUserService.save(param) != false ? ResponseData.success() : ResponseData.fail();
    }

    @ApiEncrypt(response=true)
    @RequiresPermissions(value={"sys.supuser.view"})
    @ApiOperation(value="\u5c55\u793a\u624b\u673a\u53f7")
    @GetMapping(value={"showTel"})
    public ResponseData<String> showTel(@NotNull(message="id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="id\u4e0d\u80fd\u4e3a\u7a7a") Long id) {
        OrganizationUser user = this.organizationUserService.getUserInfoById(id);
        if (Objects.isNull(user)) {
            return ResponseData.fail((String)"\u8be5\u7528\u6237\u4e0d\u5b58\u5728");
        }
        return ResponseData.success((Object)user.getTel());
    }

    @RequiresPermissions(value={"sys.supuser.edit"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.sup_sys_orgUser)
    @ApiOperation(value="\u7f16\u8f91")
    @PutMapping(value={"updateResource"})
    public ResponseData<String> updateResource(@Validated @RequestBody OrganizationUserV3EditParam param) {
        param.setLoginUserId(ShiroUtil.getLoginUserId());
        param.setLoginUserAreaId(ShiroUtil.getLoginUserAreaId());
        return this.organizationUserService.update(param) != false ? ResponseData.success() : ResponseData.fail();
    }

    @RequiresPermissions(value={"sys.supuser.deleteAccount"})
    @Log(type=LogTypeEnum.type_opt_del, logModule=LogModuleTypeEnum.sup_sys_orgUser)
    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"deleteResource"})
    public ResponseData<String> delete(@RequestBody @Validated IdsParam param) {
        return this.organizationUserService.delete(param.getIdList(), ShiroUtil.getLoginUserId()) != false ? ResponseData.success() : ResponseData.fail();
    }

    @RequiresPermissions(value={"sys.supuser.edit"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.sup_sys_orgUser, title="\u7981\u7528\u3001\u542f\u7528")
    @ApiOperation(value="\u72b6\u6001")
    @PutMapping(value={"enableOrDisable"})
    public ResponseData<String> enableOrDisable(@Validated IdsParam param, @NotNull(message="\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a") Boolean isForbidden) {
        return this.organizationUserService.enableOrDisable(param.getIdList(), isForbidden, ShiroUtil.getLoginUserId()) != false ? ResponseData.success() : ResponseData.fail();
    }

    @RequiresPermissions(value={"sys.supuser.edit"})
    @Log(type=LogTypeEnum.type_opt_reset, logModule=LogModuleTypeEnum.sup_sys_orgUser, dataOf=OperatorDataSourceEnum.SUPERVISE)
    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801")
    @PutMapping(value={"resetPassword"})
    public ResponseData<String> resetPassword(@Validated @RequestBody IdParam param) {
        return this.organizationUserService.resetPassword(param.getId(), "Zjs@2022", ShiroUtil.getLoginUserId()) != false ? ResponseData.success((Object)"Zjs@2022") : ResponseData.fail();
    }

    @SysExportLog(businessType=SysExportLogBusinessTypeEnum.TYPE_1)
    @RequiresPermissions(value={"sys.supuser.view"})
    @Log(type=LogTypeEnum.type_opt_export, logModule=LogModuleTypeEnum.sup_sys_orgUser)
    @ApiOperation(value="\u5bfc\u51fa")
    @PostMapping(value={"export"})
    public void export(HttpServletResponse response, OrganizationUserV3ListParam param) throws IOException {
        param.setPage(1);
        param.setRows(Integer.MAX_VALUE);
        param.setCount(Boolean.FALSE);
        this.setSearchListParam(param);
        List data = this.organizationUserService.getOrganizationUserList(param).getRows();
        response.setContentType("application/vnd.ms-excel");
        response.setCharacterEncoding("utf-8");
        String fileName = URLEncoder.encode(String.format("\u76d1\u7ba1\u7528\u6237%s.xls", LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)), "UTF-8").replaceAll("\\+", "%20");
        response.setHeader("Content-disposition", "attachment;filename*=utf-8''" + fileName);
        try (ExcelWriter excelWriter = EasyExcel.write((OutputStream)response.getOutputStream(), OrganizationUserV3ListVo.class).withTemplate(ResourceUtil.getStreamSafe((String)"templates/v3/organizationUserV3.xls")).excelType(ExcelTypeEnum.XLS).build();){
            WriteSheet writeSheet = EasyExcel.writerSheet().build();
            FillConfig fillConfig = FillConfig.builder().forceNewRow(Boolean.FALSE).build();
            excelWriter.fill((Object)data, fillConfig, writeSheet);
        }
        catch (Exception e) {
            this.logger.error("\u76d1\u7ba1\u7528\u6237\u7ba1\u7406V3\u5bfc\u51fa\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u5bfc\u51fa\u5931\u8d25");
        }
    }

    @RequiresPermissions(value={"sys.supuser.edit"})
    @Log(type=LogTypeEnum.type_opt_import, logModule=LogModuleTypeEnum.sup_sys_orgUser)
    @ApiOperation(value="\u5bfc\u5165")
    @PostMapping(value={"import"})
    public ResponseData<String> importData(@NotNull(message="\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u6587\u4ef6id\u4e0d\u80fd\u4e3a\u7a7a") Long fileId) {
        SysFileVo file = this.sysFileProvideService.getFileById(fileId);
        if (Objects.isNull(file)) {
            throw new ServiceException("\u6587\u4ef6\u7f3a\u5931");
        }
        try (InputStream inputStream = this.ossClientBean.getInputStreamByUrl(file.getFullOssUrl());
             ExcelReader excelReader = EasyExcel.read((InputStream)inputStream).build();){
            excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet().headRowNumber(Integer.valueOf(2))).head(OrganizationUserV3ImportDto.class)).registerReadListener((ReadListener)new SysOrganizationUserImportListener(this.organizationUserService, this.organizationService, ShiroUtil.getLoginUserId()))).build()});
        }
        catch (IOException e) {
            this.logger.error("\u76d1\u7ba1\u7528\u6237\u7ba1\u7406V3\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u5bfc\u5165\u5931\u8d25");
        }
        return ResponseData.success((Object)"\u5bfc\u5165\u6210\u529f");
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7level\u83b7\u53d6\u89d2\u8272\u6570\u636e")
    @GetMapping(value={"getSelectList"})
    public ResponseData<SysRoleV3SelectVo> getSelectList(@Validated SysRoleV3ListParam param) {
        param.setIsOnlineSpecialTestUser(ShiroUtil.isOnlineSpecialSuperAndTestUser());
        param.setSystemWide(UserSystemWideEnum.RHO.getCode());
        if (Objects.isNull(param.getLevel())) {
            param.setLevel(Integer.valueOf(ShiroUtil.getLoginUserAreaLevel().byteValue()));
        }
        param.setLoginUserId(ShiroUtil.getLoginUserId());
        param.setOrgId(ShiroUtil.getLoginUserOid());
        return ResponseData.success((Object)this.sysRoleV3Service.selectRoleSelectList(param));
    }

    public SysOrgUserController(OssClientBean ossClientBean) {
        this.ossClientBean = ossClientBean;
    }
}

