/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.controller.sys;

import cn.smarthse.common.annotation.password.OperatorDataSourceEnum;
import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.model.IdParam;
import cn.smarthse.core.framework.model.IdsParam;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserBusinessStatueEditParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserCreateEditParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserEditForSupParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserListParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserStatueEditByCidListForSupParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyUserStatueEditForSupParam;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyListForSupVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysUserCompanyOneForSupVo;
import cn.smarthse.rho.modules.sys.provider.company.ICompanyProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysUserServiceProvider;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1701, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u7cfb\u7edf\u6a21\u5757\uff1a\u533b\u9662\u7528\u6237"})
@RestController
@RequestMapping(value={"/sys/companyUser"})
@Validated
public class SysCompanyUserController
extends ControllerSupport {
    @DubboReference
    private ISysUserServiceProvider sysUserServiceProvider;
    @DubboReference
    private ICompanyProvider companyProvider;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationService organizationService;

    @RequiresPermissions(value={"sys.companyuser.view"})
    @ApiOperation(value="\u5217\u8868")
    @GetMapping(value={"getList"})
    public ResponseData<LayuiGridData<SysUserCompanyListForSupVo>> getList(@Validated SysCompanyUserListParam param) {
        return ResponseData.success((Object)this.sysUserServiceProvider.getSysCompanyUserListForSup(param));
    }

    @RequiresPermissions(value={"sys.companyuser.view"})
    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"getOne/{cid}"})
    public ResponseData<SysUserCompanyOneForSupVo> getOne(@PathVariable Long cid) {
        return ResponseData.success((Object)this.sysUserServiceProvider.getSysUserCompanyByCidForSup(cid));
    }

    @RequiresPermissions(value={"sys.companyuser.edit"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.sup_sys_companyUser)
    @ApiOperation(value="\u7f16\u8f91")
    @PutMapping(value={"updateResource"})
    public ResponseData<String> updateResource(@RequestBody @Validated SysCompanyUserEditForSupParam param) {
        return this.sysUserServiceProvider.updateSysCompanyUserEditForSup(param) != false ? ResponseData.success() : ResponseData.fail();
    }

    @RequiresPermissions(value={"sys.companyuser.edit"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.sup_sys_companyUser, title="\u7981\u7528\u3001\u542f\u7528")
    @ApiOperation(value="\u72b6\u6001")
    @PutMapping(value={"/updateSysCompanyUserStatue"})
    public ResponseData<String> updateSysCompanyUserStatue(@RequestBody @Validated SysCompanyUserStatueEditForSupParam param) {
        return this.sysUserServiceProvider.updateSysCompanyUserStatueForSup(param) != false ? ResponseData.success() : ResponseData.fail();
    }

    @RequiresPermissions(value={"sys.companyuser.edit"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.sup_sys_companyUser, title="\u6279\u91cf\u7981\u7528\u3001\u542f\u7528")
    @PutMapping(value={"updateSysCompanyUserStatueByCidList"})
    public ResponseData<String> updateSysCompanyUserStatueByCidList(@RequestBody @Validated SysCompanyUserStatueEditByCidListForSupParam param) {
        return this.sysUserServiceProvider.updateSysCompanyUserExcludeSingleUserStatueByCidListForSup(param) != false ? ResponseData.success() : ResponseData.fail();
    }

    @RequiresPermissions(value={"sys.companyuser.edit"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.sup_sys_companyUser, title="\u8425\u4e1a\u72b6\u6001")
    @ApiOperation(value="\u8425\u4e1a\u72b6\u6001")
    @PutMapping(value={"updateSysCompanyBusinessStatue"})
    public ResponseData<String> updateSysCompanyBusinessStatue(@RequestBody @Validated SysCompanyUserBusinessStatueEditParam param) {
        return this.companyProvider.updateSysCompanyBusinessStatue(param) != false ? ResponseData.success() : ResponseData.fail();
    }

    @RequiresPermissions(value={"sys.companyuser.edit"})
    @Log(type=LogTypeEnum.type_opt_reset, logModule=LogModuleTypeEnum.sup_sys_companyUser, dataOf=OperatorDataSourceEnum.RHO_COMPANY)
    @ApiOperation(value="\u91cd\u7f6e\u5bc6\u7801")
    @PutMapping(value={"resetPassword"})
    public ResponseData<String> resetPassword(@RequestBody @Validated IdParam param) {
        return this.sysUserServiceProvider.resetPasswordForSup(param) != false ? ResponseData.success((Object)"Zyj@2022") : ResponseData.fail();
    }

    @RequiresPermissions(value={"sys.companyuser.deleteAccount"})
    @Log(type=LogTypeEnum.type_opt_del, logModule=LogModuleTypeEnum.sup_sys_companyUser)
    @ApiOperation(value="\u5220\u9664")
    @DeleteMapping(value={"deleteResource"})
    public ResponseData<String> deleteSysCompanyUser(@RequestBody @Validated IdsParam param) {
        return this.sysUserServiceProvider.deleteSysCompanyUserByCidListForSup(param) != false ? ResponseData.success() : ResponseData.fail();
    }

    @RequiresPermissions(value={"sys.companyuser.edit"})
    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.sup_sys_companyUser)
    @ApiOperation(value="\u521b\u5efa\u8d26\u53f7")
    @PostMapping(value={"createUser"})
    public ResponseData<String> createUser(@RequestBody @Validated SysCompanyUserCreateEditParam param) {
        return this.sysUserServiceProvider.addUserForSup(param) != false ? ResponseData.success((Object)"Zyj@2022") : ResponseData.fail();
    }

    @RequiresPermissions(value={"sys.companyuser.edit"})
    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.sup_sys_companyUser)
    @PostMapping(value={"createUserByCidList"})
    public ResponseData<String> createUserByCidList(@RequestBody @Validated IdsParam param) {
        return this.sysUserServiceProvider.addUserByCidListForSup(param) != false ? ResponseData.success((Object)"Zyj@2022") : ResponseData.fail();
    }

    @ApiOperation(value="\u83b7\u53d6\u76d1\u7763\u5355\u4f4d")
    @GetMapping(value={"getSupervisionUnitName"})
    public ResponseData<String> getSupervisionUnitName(@NotNull(message="\u533a\u57dfid\u4e0d\u80fd\u7a7a") @NotNull(message="\u533a\u57dfid\u4e0d\u80fd\u7a7a") Long areaId, @RequestParam(required=false, defaultValue="0") Integer belongType) {
        SysAreaV3OneVo area = this.sysAreaProvideService.getAreaByIdV3(areaId);
        if (Objects.isNull(area)) {
            return ResponseData.fail((String)"\u8be5\u533a\u57df\u4e0d\u5b58\u5728");
        }
        areaId = Objects.equals(belongType, CompanyBelongTypeEnum.SHI.getValue()) ? area.getCityId() : (Objects.equals(belongType, CompanyBelongTypeEnum.SHENG.getValue()) ? area.getProvinceId() : area.getAreaId());
        Organization org = this.organizationService.getOrganizationByAreaId(areaId);
        return ResponseData.success((Object)(Objects.nonNull(org) ? org.getName() : ""));
    }
}

