/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.controller.sys;

import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.sys.model.sys.param.BCompanyChooseListParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyEditParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyListParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysCompanyStatueEditParam;
import cn.smarthse.rho.modules.sys.model.sys.vo.BCompanyChooseVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysCompanyListVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysCompanyOneVo;
import cn.smarthse.rho.modules.sys.provider.company.ICompanyProvider;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.validation.constraints.NotNull;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1701, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u7cfb\u7edf\u6a21\u5757\uff1a\u9662\u533a\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/sys/company"})
@Validated
public class SysCompanyController
extends ControllerSupport {
    @DubboReference
    private ICompanyProvider companyProvider;

    @ApiOperation(value="\u6240\u5728\u533b\u9662\u9009\u62e9\u5217\u8868")
    @GetMapping(value={"/getChooseList"})
    public ResponseData<LayuiGridData<BCompanyChooseVo>> getChooseList(@Validated BCompanyChooseListParam param) {
        return ResponseData.success((Object)this.companyProvider.getChooseList(param));
    }

    @RequiresPermissions(value={"sys.company.view"})
    @ApiOperation(value="\u5217\u8868")
    @GetMapping(value={"/getList"})
    public ResponseData<LayuiGridData<SysCompanyListVo>> getList(@Validated SysCompanyListParam param) {
        return ResponseData.success((Object)this.companyProvider.getSysCompanyListData(param));
    }

    @RequiresPermissions(value={"sys.company.view"})
    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/getOne/{cid}"})
    public ResponseData<SysCompanyOneVo> getOne(@NotNull(message="\u4e0d\u80fd\u4e3a\u7a7a") @PathVariable @NotNull(message="\u4e0d\u80fd\u4e3a\u7a7a") Long cid) {
        return ResponseData.success((Object)this.companyProvider.getSysCompany(cid));
    }

    @RequiresPermissions(value={"sys.company.edit"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.sup_sys_company)
    @ApiOperation(value="\u7f16\u8f91")
    @PutMapping(value={"/updateResource"})
    public ResponseData<String> updateResource(@Validated @RequestBody SysCompanyEditParam param) {
        return this.companyProvider.updateSysCompany(param) != false ? ResponseData.success() : ResponseData.fail();
    }

    @RequiresPermissions(value={"sys.company.edit"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.sup_sys_company, title="\u7981\u7528\u3001\u542f\u7528")
    @ApiOperation(value="\u9662\u533a\u72b6\u6001")
    @PutMapping(value={"/updateSysCompanyStatue"})
    public ResponseData<String> updateSysCompanyStatue(@Validated @RequestBody SysCompanyStatueEditParam param) {
        return this.companyProvider.updateSysCompanyStatue(param) != false ? ResponseData.success() : ResponseData.fail();
    }

    @RequiresPermissions(value={"sys.company.edit"})
    @Log(type=LogTypeEnum.type_opt_edit, logModule=LogModuleTypeEnum.sup_sys_company, title="\u662f\u5426\u4e3a\u4e3b\u9662")
    @ApiOperation(value="\u662f\u5426\u4e3a\u4e3b\u9662")
    @PutMapping(value={"/updateSysCompanyIsMain"})
    public ResponseData<String> updateSysCompanyIsMain(@Validated @RequestBody SysCompanyStatueEditParam param) {
        return this.companyProvider.updateSysCompanyIsMain(param) != false ? ResponseData.success() : ResponseData.fail();
    }
}

