/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.controller.onlineMonitor;

import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.supervise.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.supervise.service.m.IMOnlineMonitorDeviceService;
import cn.smarthse.rho.modules.sys.model.m.param.MonitoringProtectDeviceAbnormalRateSetParam;
import cn.smarthse.rho.modules.sys.model.m.param.OnlineMonitorDeviceParam;
import cn.smarthse.rho.modules.sys.model.m.vo.OnlineMonitoringProtectDeviceModel;
import cn.smarthse.rho.modules.sys.provider.sys.ISysAreaProvider;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1500, author="wuxq")
@Api(tags={"\u9632\u62a4\u7528\u54c1\u4f7f\u7528\u60c5\u51b5\u5728\u7ebf\u76d1\u6d4b\u5217\u8868"})
@Validated
@RestController
@RequestMapping(value={"/protect/device"})
public class OnlineMonitorProtectDeviceController
extends ControllerSupport {
    private final IMOnlineMonitorDeviceService monitorDeviceService;
    @DubboReference
    private ISysAreaProvider sysAreaProvider;

    @ApiOperation(value="\u5217\u8868")
    @RequiresPermissions(value={"monitor.protection.view"})
    @GetMapping(value={"listData"})
    public ResponseData<LayuiGridData<OnlineMonitoringProtectDeviceModel>> listData(OnlineMonitorDeviceParam param) {
        if (param.getAreaId() == null) {
            param.setAreaId(ShiroUtil.getLoginUserAreaId());
            param.setLevel(Integer.valueOf(Objects.requireNonNull(ShiroUtil.getLoginUserAreaLevel()).intValue()));
        } else {
            param.setLevel(this.sysAreaProvider.getLevel(param.getAreaId()));
        }
        return ResponseData.success(this.monitorDeviceService.getOnlineMonitorProtectDeviceList(param));
    }

    @RequiresPermissions(value={"monitor.protection.edit"})
    @ApiOperation(value="\u76d1\u6d4b\u65f6\u95f4\u70b9\u5f02\u5e38\u6570\u5360\u6bd4")
    @PostMapping(value={"/setAbnormalRate"})
    public ResponseData<String> setAbnormalRate(@RequestBody MonitoringProtectDeviceAbnormalRateSetParam param) {
        if (param.getRateNum() == null || param.getRateNum() < 0 || param.getRateNum() > 100) {
            return ResponseData.fail((String)"\u5f02\u5e38\u5360\u6bd4\u4e0d\u80fd\u5c0f\u4e8e0%\u4e14\u4e0d\u80fd\u8d85\u8fc7100%");
        }
        this.monitorDeviceService.setAbnormalRate(param);
        return ResponseData.success();
    }

    public OnlineMonitorProtectDeviceController(IMOnlineMonitorDeviceService monitorDeviceService) {
        this.monitorDeviceService = monitorDeviceService;
    }
}

