/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.controller.login;

import cn.hutool.core.lang.tree.Tree;
import cn.smarthse.common.annotation.password.OperatorDataSourceEnum;
import cn.smarthse.common.redis.utils.RedisUtils;
import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.RedisKey;
import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.annotation.RequestLimit;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.core.framework.utils.RsaUtil;
import cn.smarthse.core.framework.utils.StringUtils;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProvideMasService;
import cn.smarthse.modules.health.supervise.enums.sys.UserSystemWideEnum;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysPermissionV3Service;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.ShiroPrincipal;
import cn.smarthse.rho.modules.supervise.bootstrap.security.utils.ShiroUtil;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.time.Duration;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.SecurityUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=2, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u4e2a\u4eba\u4e2d\u5fc3"})
@RestController
@RequestMapping(value={"/uc"})
@Validated
public class UcController
extends ControllerSupport {
    @DubboReference(registry={"public_nacos"})
    private IOrganizationUserService organizationUserService;
    @DubboReference(registry={"public_nacos"})
    private ISysPermissionV3Service sysPermissionV3Service;
    @DubboReference
    private ISMSProvideMasService smsProvideMasService;
    private static final String vcode_template = "\u60a8\u7684\u6d59\u91cc\u536b\u4f01\u5e94\u7528\u9a8c\u8bc1\u7801\u662f: %s\uff0c\u6709\u6548\u671f5\u5206\u949f\uff0c\u8bf7\u52ff\u5c06\u9a8c\u8bc1\u7801\u6cc4\u9732\u7ed9\u4ed6\u4eba";
    private static final String sms_cache_name = "sms_login:supervise:";

    @ApiOperation(value="\u83b7\u53d6\u8def\u7531\u4fe1\u606f")
    @GetMapping(value={"/getRouters"})
    public ResponseData<List<Tree<Long>>> getRouters() {
        return ResponseData.success((Object)this.sysPermissionV3Service.getRouters(UserSystemWideEnum.RHO.getCode(), ShiroUtil.getLoginUserId()));
    }

    @ApiOperation(value="\u5f53\u524d\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"/getPrinciple"})
    public ResponseData<ShiroPrincipal> getPrinciple() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        return ResponseData.success((Object)principal);
    }

    @ApiOperation(value="\u4fee\u6539\u5bc6\u7801")
    @ApiImplicitParams(value={@ApiImplicitParam(name="oldPassword", value="\u65e7\u5bc6\u7801\uff08rsa\u52a0\u5bc632\u4f4d\u5c0f\u5199md5\u5bc6\u7801\uff09", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="password", value="\u65b0\u5bc6\u7801\uff08rsa\u52a0\u5bc632\u4f4d\u5c0f\u5199md5\u5bc6\u7801\uff09", required=true, paramType="query", dataTypeClass=String.class), @ApiImplicitParam(name="uuid", value="\u516c\u94a5uuid", required=true, paramType="query", dataTypeClass=String.class)})
    @Log(type=LogTypeEnum.type_opt_changePass, logModule=LogModuleTypeEnum.sup_uc, dataOf=OperatorDataSourceEnum.SUPERVISE)
    @RequestLimit(second=60, maxCount=5)
    @PostMapping(value={"/changePasswordByOld"})
    public ResponseData<String> changePasswordByOld(@NotBlank(message="\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u65e7\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String oldPassword, @NotBlank(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String password, @NotBlank(message="\u516c\u94a5uuid\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u516c\u94a5uuid\u4e0d\u80fd\u4e3a\u7a7a") String uuid) {
        String privateKey = (String)RedisUtils.getCacheObject((String)RedisKey.RSA((String)uuid));
        if (privateKey == null) {
            return ResponseData.fail((String)"\u5bc6\u7801\u516c\u94a5\u5bc6\u94a5\u8fc7\u671f\uff01");
        }
        password = RsaUtil.decrypt((String)password, (String)privateKey);
        oldPassword = RsaUtil.decrypt((String)oldPassword, (String)privateKey);
        Long userId = ShiroUtil.getLoginUserId();
        this.organizationUserService.modifyPassword(userId, oldPassword, password);
        RedisUtils.deleteObject((String)RedisKey.getSuperviseLoginUserKey((Long)userId));
        RedisUtils.deleteObject((String)RedisKey.getSuperviseLoginTokenKey((Long)userId));
        return ResponseData.success((Object)"\u5bc6\u7801\u4fee\u6539\u6210\u529f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
    }

    @RequestLimit
    @PostMapping(value={"sendVcode"})
    public ResponseData<String> sendVcode() {
        if (!SecurityUtils.getSubject().isAuthenticated()) {
            return ResponseData.fail((String)"\u767b\u5f55\u5931\u6548\uff0c\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\u5931\u8d25\uff01");
        }
        String mobile = ShiroUtil.getLoginUserTel();
        if (StringUtils.isBlank((CharSequence)mobile)) {
            return ResponseData.fail((String)"\u60a8\u672a\u7ed1\u5b9a\u624b\u673a\u53f7");
        }
        if (!StringUtils.checkMobile((String)mobile)) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef");
        }
        String vcode = StringUtils.getRandomNum((int)6);
        this.logger.debug("UcController:sendVcode:vcode:{}", (Object)vcode);
        this.smsProvideMasService.sendSms(mobile, String.format(vcode_template, vcode));
        RedisUtils.setCacheObject((String)(sms_cache_name + mobile), (Object)vcode, (Duration)Duration.ofSeconds(300L));
        return ResponseData.success();
    }

    @Log(type=LogTypeEnum.type_opt_changePass, logModule=LogModuleTypeEnum.sup_uc, dataOf=OperatorDataSourceEnum.SUPERVISE)
    @RequestLimit(second=60, maxCount=5)
    @PostMapping(value={"changePasswordByMobile"})
    public ResponseData<String> changePasswordByMobile(@NotBlank(message="\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a") String vcode, @NotBlank(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u65b0\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a") String password, @NotBlank(message="\u516c\u94a5uuid\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u516c\u94a5uuid\u4e0d\u80fd\u4e3a\u7a7a") String uuid) {
        if (!this.checkVcode(ShiroUtil.getLoginUserTel(), vcode)) {
            return ResponseData.fail((String)"\u77ed\u4fe1\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        String privateKey = (String)RedisUtils.getCacheObject((String)RedisKey.RSA((String)uuid));
        if (privateKey == null) {
            return ResponseData.fail((String)"\u5bc6\u7801\u516c\u94a5\u5bc6\u94a5\u8fc7\u671f\uff01");
        }
        password = RsaUtil.decrypt((String)password, (String)privateKey);
        Long userId = ShiroUtil.getLoginUserId();
        this.organizationUserService.modifyPassword(userId, password);
        RedisUtils.deleteObject((String)RedisKey.getSuperviseLoginUserKey((Long)userId));
        RedisUtils.deleteObject((String)RedisKey.getSuperviseLoginTokenKey((Long)userId));
        return ResponseData.success((Object)"\u5bc6\u7801\u4fee\u6539\u6210\u529f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
    }

    private boolean checkVcode(String mobile, String vcode) {
        boolean result;
        String cache = (String)RedisUtils.getCacheObject((String)(sms_cache_name + mobile));
        boolean bl = result = cache != null && cache.equalsIgnoreCase(vcode);
        if (result) {
            RedisUtils.deleteObject((String)(sms_cache_name + mobile));
        }
        return result;
    }
}

