/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.controller.login;

import cn.hutool.core.util.PhoneUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.redis.utils.RedisUtils;
import cn.smarthse.common.util.NoSpecalCrypUtil;
import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.RedisKey;
import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.annotation.RequestLimit;
import cn.smarthse.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.core.framework.utils.AesUtil;
import cn.smarthse.core.framework.utils.RsaUtil;
import cn.smarthse.core.framework.utils.StringUtils;
import cn.smarthse.core.framework.utils.login.JwtUtil;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.modules.datacentre.provider.sms.ISMSProvideMasService;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.ShiroPrincipal;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.param.CasLoginBody;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.param.CasToCompanyLoginBody;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.param.PasswordLoginBody;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.param.PasswordNextLoginBody;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.vo.CaptchaVo;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.vo.LoginVo;
import cn.smarthse.rho.modules.supervise.bootstrap.security.service.LoginService;
import cn.smarthse.rho.modules.sys.enums.user.UserResourceEnum;
import com.alibaba.fastjson.JSONObject;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.Duration;
import java.util.Objects;
import javax.validation.constraints.NotBlank;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u767b\u5f55"})
@RestController
@RequestMapping(value={"/login"})
@Validated
public class LoginController
extends ControllerSupport {
    private final LoginService loginService;
    private final SysProperties sysProperties;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationUserService organizationUserService;
    @DubboReference(registry={"public_nacos"})
    private ISMSProvideMasService smsProvideMasService;
    private static final String sms_cache_name = "rho_login:supervise:sms:";

    @ApiOperation(value="\u9000\u51fa\u767b\u5f55")
    @PostMapping(value={"/logout"})
    public ResponseData<String> logout() {
        this.loginService.logout(JwtUtil.getUserId());
        return ResponseData.success((Object)"\u9000\u51fa\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u56fe\u5f62\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/vCode"})
    public ResponseData<CaptchaVo> vCode() {
        return ResponseData.success((Object)this.loginService.vCode());
    }

    @ApiOperation(value="\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6839\u636e\u7528\u6237\u540d")
    @RequestLimit(second=60, maxCount=5)
    @PostMapping(value={"vSmsCodeByMobile"})
    public ResponseData<String> vSmsCodeByMobile(@NotBlank(message="\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a") String mobile) {
        if (!PhoneUtil.isMobile((CharSequence)mobile)) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\uff01");
        }
        if (Objects.isNull(this.organizationUserService.getAccountId(mobile))) {
            return ResponseData.fail((String)"\u975e\u6d59\u653f\u9489\u8d26\u53f7\u7ed1\u5b9a\u7684\u624b\u673a\u53f7\uff0c\u65e0\u6cd5\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff01");
        }
        String vcode = StringUtils.getRandomNum((int)6);
        this.logger.debug("\u9a8c\u8bc1\u7801\uff1a{}", (Object)vcode);
        this.smsProvideMasService.sendSms(mobile, String.format("\u60a8\u7684\u653e\u5c04\u536b\u751f\u5e94\u7528\u9a8c\u8bc1\u7801: %s\uff0c\u4e3a\u4e86\u786e\u4fdd\u7cfb\u7edf\u767b\u5f55\u5b89\u5168\uff0c\u6b63\u5728\u8fdb\u884c\u767b\u5f55\u4e8c\u6b21\u9a8c\u8bc1\uff0c5\u5206\u949f\u5185\u6709\u6548\uff0c\u8bf7\u52ff\u6cc4\u9732\u3002", vcode));
        RedisUtils.setCacheObject((String)(sms_cache_name + mobile), (Object)vcode, (Duration)Duration.ofMinutes(5L));
        return ResponseData.success();
    }

    @ApiOperation(value="\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\u6839\u636e\u624b\u673a\u53f7")
    @RequestLimit(second=60, maxCount=5)
    @PostMapping(value={"vSmsCodeByUsername"})
    public ResponseData<String> vSmsCodeByUsername(@NotBlank(message="\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a") String username) {
        OrganizationUser user = this.organizationUserService.getUserByuserame(username);
        if (Objects.isNull(user)) {
            return ResponseData.fail((String)"\u8be5\u7528\u6237\u5df2\u4e0d\u5b58\u5728\uff01");
        }
        if (!PhoneUtil.isMobile((CharSequence)user.getTel())) {
            return ResponseData.fail((String)"\u624b\u673a\u53f7\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u786e\u8ba4\uff01");
        }
        if (Objects.isNull(this.organizationUserService.getAccountId(user.getTel()))) {
            return ResponseData.fail((String)"\u975e\u6d59\u653f\u9489\u8d26\u53f7\u7ed1\u5b9a\u7684\u624b\u673a\u53f7\uff0c\u65e0\u6cd5\u53d1\u9001\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff01");
        }
        String vcode = StringUtils.getRandomNum((int)6);
        this.logger.debug("\u9a8c\u8bc1\u7801\uff1a{}", (Object)vcode);
        this.smsProvideMasService.sendSms(user.getTel(), String.format("\u60a8\u7684\u653e\u5c04\u536b\u751f\u5e94\u7528\u9a8c\u8bc1\u7801: %s\uff0c\u4e3a\u4e86\u786e\u4fdd\u7cfb\u7edf\u767b\u5f55\u5b89\u5168\uff0c\u6b63\u5728\u8fdb\u884c\u767b\u5f55\u4e8c\u6b21\u9a8c\u8bc1\uff0c5\u5206\u949f\u5185\u6709\u6548\uff0c\u8bf7\u52ff\u6cc4\u9732\u3002", vcode));
        RedisUtils.setCacheObject((String)(sms_cache_name + username), (Object)vcode, (Duration)Duration.ofMinutes(5L));
        return ResponseData.success();
    }

    @ApiOperation(value="\u5bc6\u7801\u767b\u5f55\u56de\u8c03")
    @BigLog(userRole=UserRoleEnum.GOVERNMENT_STAFF_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module8)
    @Log(type=LogTypeEnum.type_login, logModule=LogModuleTypeEnum.sup_uc, title="\u5bc6\u7801\u767b\u5f55")
    @PostMapping(value={"/passwordCallback"})
    public ResponseData<LoginVo> loginByPasswordCallback(@Validated @RequestBody PasswordLoginBody loginBody) {
        String privateKey = (String)RedisUtils.getCacheObject((String)RedisKey.RSA((String)loginBody.getRsaUuid()));
        if (privateKey == null) {
            return ResponseData.fail((String)"\u5bc6\u7801\u516c\u94a5\u5bc6\u94a5\u8fc7\u671f\uff01");
        }
        this.loginService.checkVcode(loginBody.getUuid(), loginBody.getCode());
        LoginVo result = this.loginService.loginByPassword(loginBody.getUsername(), RsaUtil.decrypt((String)loginBody.getPassword(), (String)privateKey));
        if (result.getCheckVcode() != 1) {
            result.setToken(null);
        }
        return ResponseData.success((Object)result);
    }

    @ApiOperation(value="\u5bc6\u7801\u767b\u5f55")
    @RequestLimit(second=60, maxCount=5, expression="#loginBody.username")
    @PostMapping(value={"/password"})
    public ResponseData<LoginVo> loginByPassword(@Validated @RequestBody PasswordNextLoginBody loginBody) {
        OrganizationUser user = this.organizationUserService.getUserByuserame(loginBody.getUsername());
        if (Objects.isNull(user)) {
            return ResponseData.fail((String)"\u8be5\u7528\u6237\u540d\u5df2\u4e0d\u5b58\u5728\uff01");
        }
        String code = (String)RedisUtils.getCacheObject((String)(sms_cache_name + ("username".equals(loginBody.getType()) ? loginBody.getUsername() : loginBody.getTel())));
        if (!Objects.equals(loginBody.getCode(), code)) {
            return ResponseData.fail((String)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        ShiroPrincipal principal = (ShiroPrincipal)RedisUtils.getCacheObject((String)RedisKey.getSuperviseLoginUserKey((Long)user.getId()));
        String token = (String)RedisUtils.getCacheObject((String)RedisKey.getSuperviseLoginTokenKey((Long)user.getId()));
        if (Objects.isNull(principal) || StrUtil.isBlank((CharSequence)token)) {
            return ResponseData.fail((String)"\u767b\u5f55\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u8d26\u53f7\u5bc6\u7801\u767b\u5f55\uff01");
        }
        if (StrUtil.isBlank((CharSequence)user.getTel())) {
            this.organizationUserService.bindTel(user.getId(), loginBody.getTel());
        }
        principal.getUser().setTwoFactorCheck((byte)0);
        RedisUtils.setCacheObject((String)RedisKey.getSuperviseLoginUserKey((Long)user.getId()), (Object)principal, (Duration)Duration.ofMinutes(Constant.REDIS_PRINCIPAL_TIME));
        return ResponseData.success((Object)new LoginVo(token, principal.getCheckVcode()));
    }

    @ApiOperation(value="\u6d59\u91cc\u536b\u4f01\u76d1\u7ba1\u7aef\u5355\u70b9\u767b\u5f55\u81f3\u653e\u5c04\u536b\u751f\u76d1\u7ba1\u7aef")
    @BigLog(userRole=UserRoleEnum.GOVERNMENT_STAFF_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module8)
    @Log(type=LogTypeEnum.type_cas_login, logModule=LogModuleTypeEnum.sup_uc, title="\u6d59\u91cc\u536b\u4f01\u76d1\u7ba1\u7aef\u5355\u70b9\u767b\u5f55\u81f3\u653e\u5c04\u536b\u751f\u76d1\u7ba1\u7aef")
    @GetMapping(value={"/cas"})
    public ResponseData<LoginVo> loginByCas(@NotBlank(message="sign\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="sign\u4e0d\u80fd\u4e3a\u7a7a") String sign) {
        String decrypt = AesUtil.decrypt((String)sign, (String)this.sysProperties.healthOnlineTrainingAesKey);
        if (decrypt == null) {
            return ResponseData.fail((String)"sign\u9519\u8bef\uff0c\u89e3\u6790\u5931\u8d25\uff01");
        }
        JSONObject jsonObject = JSONObject.parseObject((String)decrypt);
        String username = (String)jsonObject.getObject("username", String.class);
        Long time = (Long)jsonObject.getObject("time", Long.class);
        String redirectUrl = (String)jsonObject.getObject("redirectUrl", String.class);
        long expireTime = 300000L;
        if (time != null && System.currentTimeMillis() - time > 300000L) {
            return ResponseData.fail((String)"sign\u5931\u6548\uff0c\u9a8c\u7b7e\u4e0d\u901a\u8fc7\uff01");
        }
        CasLoginBody casToken = new CasLoginBody(username, 1);
        LoginVo result = this.loginService.loginByCas(casToken);
        result.setRedirectUrl(redirectUrl);
        return ResponseData.success((Object)result);
    }

    @ApiOperation(value="\u653e\u5c04\u536b\u751f\u76d1\u7ba1\u7aef\u5355\u70b9\u767b\u5f55\u81f3\u6d59\u91cc\u536b\u4f01\u76d1\u7ba1\u7aef")
    @Log(type=LogTypeEnum.type_cas_login, logModule=LogModuleTypeEnum.sup_uc, title="\u653e\u5c04\u536b\u751f\u76d1\u7ba1\u7aef\u5355\u70b9\u767b\u5f55\u81f3\u6d59\u91cc\u536b\u4f01\u76d1\u7ba1\u7aef")
    @GetMapping(value={"/casToSupervise"})
    public ResponseData<String> casToSupervise(@RequestParam(value="redirectUrl", required=false) String redirectUrl) {
        String sign;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("username", (Object)JwtUtil.getUsername());
        jsonObject.put("time", (Object)System.currentTimeMillis());
        jsonObject.put("redirectUrl", (Object)(StrUtil.isNotBlank((CharSequence)redirectUrl) ? "/" + redirectUrl : ""));
        try {
            sign = NoSpecalCrypUtil.encrypt((String)jsonObject.toString(), (String)this.sysProperties.healthOnlineTrainingAesKey);
        }
        catch (Exception e) {
            this.logger.error("rho\u5355\u70b9\u5931\u8d25\uff0c", (Throwable)e);
            return ResponseData.fail((String)"\u767b\u5f55\u5931\u8d25");
        }
        return ResponseData.success((Object)(this.sysProperties.healthSupUrl + "?sign=" + sign));
    }

    @ApiOperation(value="\u653e\u5c04\u536b\u751f\u76d1\u7ba1\u7aef\u5355\u70b9\u767b\u5f55\u81f3\u653e\u5c04\u536b\u751f\u533b\u9662\u7aef")
    @Log(type=LogTypeEnum.type_cas_login, logModule=LogModuleTypeEnum.sup_uc, title="\u653e\u5c04\u536b\u751f\u76d1\u7ba1\u7aef\u5355\u70b9\u767b\u5f55\u81f3\u653e\u5c04\u536b\u751f\u533b\u9662\u7aef")
    @PostMapping(value={"/casToCompany"})
    public ResponseData<String> casToCompany(@Validated @RequestBody CasToCompanyLoginBody loginBody) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("cid", (Object)loginBody.getCid());
        jsonObject.put("superuserId", (Object)JwtUtil.getUserId());
        jsonObject.put("superuserName", (Object)JwtUtil.getUsername());
        jsonObject.put("superuserAreaId", (Object)JwtUtil.getAreaId());
        jsonObject.put("userResource", (Object)UserResourceEnum.SUPERVISE_SINGLE_ADD.getValue());
        jsonObject.put("time", (Object)System.currentTimeMillis());
        jsonObject.put("redirectUrl", (Object)loginBody.getRedirectUrl());
        String sign = AesUtil.encrypt((String)jsonObject.toJSONString(), (String)this.sysProperties.healthOnlineTrainingAesKey);
        return ResponseData.success((Object)sign);
    }

    @RequiresPermissions(value={"train.manage.view"})
    @ApiOperation(value="\u653e\u5c04\u536b\u751f\u76d1\u7ba1\u7aef\u5355\u70b9\u767b\u5f55\u81f3\u5728\u7ebf\u57f9\u8bad\u76d1\u7ba1\u7aef")
    @Log(type=LogTypeEnum.type_cas_login, logModule=LogModuleTypeEnum.sup_uc, title="\u653e\u5c04\u536b\u751f\u76d1\u7ba1\u7aef\u5355\u70b9\u767b\u5f55\u81f3\u5728\u7ebf\u57f9\u8bad\u76d1\u7ba1\u7aef")
    @GetMapping(value={"/toThird"})
    public ResponseData<String> toOnlineTrain(@RequestParam(value="redirectUrl", required=false) String redirectUrl) {
        Long loginUserId = JwtUtil.getUserId();
        OrganizationUser organizationUser = (OrganizationUser)this.organizationUserService.getById(loginUserId);
        if (Objects.isNull(organizationUser)) {
            return ResponseData.fail((String)"\u627e\u4e0d\u5230\u8be5\u76d1\u7ba1\u7528\u6237\u76f8\u5173\u4fe1\u606f");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("time", (Object)System.currentTimeMillis());
        jsonObject.put("redirectUrl", (Object)(StrUtil.isNotBlank((CharSequence)redirectUrl) ? redirectUrl : this.sysProperties.healthOnlineTrainingRedirectUrl));
        jsonObject.put("token", (Object)loginUserId);
        jsonObject.put("areaId", (Object)organizationUser.getOrganization().getAreaId());
        jsonObject.put("username", (Object)organizationUser.getUsername());
        jsonObject.put("name", (Object)organizationUser.getFullName());
        String sign = AesUtil.encrypt((String)jsonObject.toString(), (String)this.sysProperties.healthOnlineTrainingAesKey);
        return ResponseData.success((Object)(this.sysProperties.healthOnlineTrainingUrl + "?sign=" + sign));
    }

    public LoginController(LoginService loginService, SysProperties sysProperties) {
        this.loginService = loginService;
        this.sysProperties = sysProperties;
    }
}

