/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.controller.login;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.common.redis.utils.RedisUtils;
import cn.smarthse.common.util.sensitive.SensitiveUtil;
import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.modules.common.enums.BigLogBusinessModuleEnum;
import cn.smarthse.modules.datacentre.model.bigdata.BigLog;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.param.DDLoginBody;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.vo.LoginVo;
import cn.smarthse.rho.modules.supervise.bootstrap.security.service.LoginService;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.xxpt.gateway.shared.client.http.ExecutableClient;
import com.alibaba.xxpt.gateway.shared.client.http.GetClient;
import com.alibaba.xxpt.gateway.shared.client.http.PostClient;
import com.sx.log.enums.ActionTypeEnum;
import com.sx.log.enums.UserRoleEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9489\u9489"})
@RestController
@RequestMapping(value={"/dingDing"})
@Validated
public class DingDingLoginController
extends ControllerSupport {
    private final LoginService loginService;
    private final SysProperties sysProperties;
    private final ExecutableClient executableClient;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationUserService organizationUserService;
    private static final String accessToken_cache_name = "rho_login:supervise:accessToken";
    private static final String dingding_cache_name = "rho_login:supervise:dingding:";

    @ApiOperation(value="\u83b7\u53d6\u4e8c\u7ef4\u7801")
    @GetMapping(value={"qrCode"})
    public ResponseData<String> qrCode() {
        return ResponseData.success((Object)this.sysProperties.getZwddQr().getQRCodeUrl());
    }

    @ApiOperation(value="\u56de\u8c03")
    @Log(type=LogTypeEnum.type_scan_login, logModule=LogModuleTypeEnum.sup_uc, title="\u6d59\u653f\u9489\u626b\u7801\u767b\u5f55")
    @PostMapping(value={"callback"})
    public ResponseData<?> callback(String code) {
        String lastname;
        String accountId;
        if (StrUtil.isBlank((CharSequence)code) || "undefined".equalsIgnoreCase(code)) {
            return ResponseData.fail((String)"\u6821\u9a8c\u5931\u8d25\uff01\u8bf7\u91cd\u65b0\u626b\u7801\u767b\u5f55\uff01");
        }
        String accessToken = this.getAccessToken_cache_name();
        if (accessToken == null) {
            this.logger.error("dingDingLogin:callback:\u83b7\u53d6accessToken\u5931\u8d25");
            return ResponseData.fail((String)"\u6821\u9a8c\u5931\u8d25\uff01\u83b7\u53d6accessToken\u5931\u8d25\uff01");
        }
        try {
            String userInfoJson = this.getUserInfo(accessToken, code);
            accountId = this.getAccountId(userInfoJson);
            lastname = this.getUsername(userInfoJson);
        }
        catch (Exception e) {
            this.logger.error("dingDingLogin:callback:\u89e3\u6790userInfoJson\u5f02\u5e38", (Throwable)e);
            return ResponseData.fail((String)"\u6821\u9a8c\u5931\u8d25\uff01\u83b7\u53d6\u6d59\u653f\u9489\u8d26\u53f7\u4fe1\u606f\u5931\u8d25\uff01");
        }
        List exists = this.organizationUserService.getUserListByAccoundId(Long.valueOf(accountId));
        if (CollUtil.isEmpty((Collection)exists)) {
            this.logger.error("dingDingLogin:callback:\u8d26\u53f7\u4e0d\u5b58\u5728\uff1aaccountId\uff1a{}\uff0cname\uff1a{}", (Object)accountId, (Object)lastname);
            return ResponseData.fail((String)"\u6821\u9a8c\u5931\u8d25\uff01\u975e\u6d59\u653f\u9489\u6388\u6743\u7528\u6237\uff01");
        }
        List<OrganizationUser> usernameList = this.toUsernameList(exists);
        RedisUtils.setCacheList((String)(dingding_cache_name + code), usernameList);
        if (usernameList.size() == 1) {
            return this.login(code, usernameList.get(0).getUsername());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("usernameList", usernameList);
        return ResponseData.success((String)"\u5b58\u5728\u591a\u4e2a\u7528\u6237\u8bf7\u9009\u62e9\u4e00\u4e2a\u767b\u5f55\uff01", (Object)new LoginVo(map, 3));
    }

    @ApiOperation(value="\u767b\u5f55")
    @BigLog(userRole=UserRoleEnum.GOVERNMENT_STAFF_TYPE, actionType=ActionTypeEnum.LOGIN_TYPE, businessModule=BigLogBusinessModuleEnum.module8)
    @Log(type=LogTypeEnum.type_scan_login, logModule=LogModuleTypeEnum.sup_uc, title="\u6d59\u653f\u9489\u626b\u7801\u767b\u5f55")
    @PostMapping(value={"login"})
    public ResponseData<LoginVo> login(@NotBlank(message="code\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="code\u4e0d\u80fd\u4e3a\u7a7a") String code, @NotBlank(message="\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a") @NotBlank(message="\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a") String username) {
        List list = RedisUtils.getCacheList((String)(dingding_cache_name + code));
        if (CollUtil.isEmpty((Collection)list)) {
            return ResponseData.fail((String)"\u4e8c\u6b21\u6821\u9a8c\u5931\u8d25\uff01\u8bf7\u91cd\u65b0\u626b\u7801\u767b\u5f55\uff01");
        }
        if (list.stream().noneMatch(i -> username.equals(i.getUsername()))) {
            return ResponseData.fail((String)"\u4e8c\u6b21\u6821\u9a8c\u5931\u8d25\uff01\u8bf7\u91cd\u65b0\u626b\u7801\u767b\u5f55\uff01");
        }
        DDLoginBody body = new DDLoginBody(username, 1);
        LoginVo result = this.loginService.loginByDD(body).setUsername(null).setOrganizationName(null).setTel(null);
        RedisUtils.deleteObject((String)(dingding_cache_name + code));
        return ResponseData.success((Object)result);
    }

    private String getAccessToken_cache_name() {
        JSONObject content;
        String cache = (String)RedisUtils.getCacheObject((String)accessToken_cache_name);
        if (cache != null) {
            return cache;
        }
        GetClient getClient = this.executableClient.newGetClient("/gettoken.json");
        String apiResult = getClient.get();
        this.logger.debug("dingDingLogin::\u83b7\u53d6accessToken\u7ed3\u679c:{}", (Object)apiResult);
        JSONObject jsonObject = JSONObject.parseObject((String)apiResult);
        Boolean success = jsonObject.getBoolean("success");
        if (Boolean.TRUE.equals(success) && Boolean.TRUE.equals(success = (content = jsonObject.getJSONObject("content")).getBoolean("success"))) {
            String result = content.getJSONObject("data").getString("accessToken");
            RedisUtils.setCacheObject((String)accessToken_cache_name, (Object)result, (Duration)Duration.ofMinutes(50L));
            return result;
        }
        return null;
    }

    private String getUserInfo(String accessToken, String code) {
        PostClient postClient = this.executableClient.newPostClient("/rpc/oauth2/getuserinfo_bycode.json");
        postClient.addParameter("access_token", accessToken);
        postClient.addParameter("code", code);
        String apiResult = postClient.post();
        this.logger.debug("dingDingLogin::\u83b7\u53d6userInfo\u7ed3\u679c:{}", (Object)apiResult);
        return apiResult;
    }

    private String getAccountId(String userInfoJson) throws Exception {
        JSONObject jsonObject = JSON.parseObject((String)userInfoJson);
        Boolean success = jsonObject.getBoolean("success");
        if (Boolean.TRUE.equals(success)) {
            JSONObject content = jsonObject.getJSONObject("content");
            success = content.getBoolean("success");
            if (Boolean.TRUE.equals(success)) {
                return content.getJSONObject("data").getString("accountId");
            }
            throw new Exception(content.getString("responseMessage"));
        }
        return null;
    }

    private String getUsername(String userInfoJson) throws Exception {
        JSONObject jsonObject = JSON.parseObject((String)userInfoJson);
        Boolean success = jsonObject.getBoolean("success");
        if (Boolean.TRUE.equals(success)) {
            JSONObject content = jsonObject.getJSONObject("content");
            success = content.getBoolean("success");
            if (Boolean.TRUE.equals(success)) {
                return content.getJSONObject("data").getString("lastName");
            }
            throw new Exception(content.getString("responseMessage"));
        }
        return null;
    }

    private List<OrganizationUser> toUsernameList(List<OrganizationUser> exists) {
        if (CollUtil.isEmpty(exists)) {
            return Collections.emptyList();
        }
        ArrayList<OrganizationUser> list = new ArrayList<OrganizationUser>(exists.size());
        exists.forEach(user -> {
            OrganizationUser organizationUser = new OrganizationUser();
            organizationUser.setUsername(user.getUsername());
            organizationUser.setOrganizationName(user.getOrganizationName());
            organizationUser.setTel(SensitiveUtil.encryptPhone((String)user.getTel()));
            list.add(organizationUser);
        });
        return list;
    }

    public DingDingLoginController(LoginService loginService, SysProperties sysProperties, ExecutableClient executableClient) {
        this.loginService = loginService;
        this.sysProperties = sysProperties;
        this.executableClient = executableClient;
    }
}

