/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.controller.keyFactor;

import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.supervise.model.keyFactor.param.AcceptanceRiskParam;
import cn.smarthse.rho.modules.supervise.model.keyFactor.param.RiskQueryParam;
import cn.smarthse.rho.modules.supervise.model.keyFactor.vo.RiskDetailSourceVo;
import cn.smarthse.rho.modules.supervise.model.keyFactor.vo.RiskDetailStatisticDataVo;
import cn.smarthse.rho.modules.supervise.model.keyFactor.vo.RiskDetailVo;
import cn.smarthse.rho.modules.supervise.model.keyFactor.vo.RiskListExportVo;
import cn.smarthse.rho.modules.supervise.model.keyFactor.vo.RiskListVo;
import cn.smarthse.rho.modules.supervise.model.keyFactor.vo.RiskSourceHistoryVo;
import cn.smarthse.rho.modules.supervise.service.r.IRRiskAcceptanceRecordService;
import cn.smarthse.rho.modules.supervise.service.r.IRRiskBasicService;
import cn.smarthse.rho.modules.supervise.service.r.IRRiskBasicSourceHistoryService;
import cn.smarthse.rho.modules.supervise.service.r.IRRiskBasicSourceService;
import com.alibaba.excel.EasyExcel;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1300, author="chuhy")
@Api(tags={"\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u98ce\u9669\u5316\u89e3\u7ba1\u7406\u6e05\u5355"})
@RestController
@RequestMapping(value={"/risk/reformItem"})
public class RiskReformItemController
extends ControllerSupport {
    @Autowired
    private IRRiskBasicService riskBasicService;
    @Autowired
    private IRRiskBasicSourceService sourceService;
    @Autowired
    private IRRiskBasicSourceHistoryService sourceHistoryService;
    @Autowired
    private IRRiskAcceptanceRecordService acceptanceRecordService;

    @ApiOperation(value="\u5217\u8868")
    @GetMapping(value={"/listRiskData"})
    public ResponseData<LayuiGridData<RiskListVo>> listRiskData(RiskQueryParam param) {
        return ResponseData.success(this.riskBasicService.listRiskData(param));
    }

    @ApiOperation(value="\u8be6\u60c5-\u4f01\u4e1a\u98ce\u9669\u8be6\u60c5(\u5de6\u4fa7)")
    @GetMapping(value={"/getRiskDetail"})
    public ResponseData<List<RiskDetailVo>> getRiskDetail(RiskQueryParam param) {
        return ResponseData.success(this.riskBasicService.getRiskDetail(param));
    }

    @ApiOperation(value="\u8be6\u60c5-\u4f01\u4e1a\u98ce\u9669\u8be6\u60c5(\u5de6\u4fa7-\u7528\u4e8e\u8bb8\u53ef\u7ba1\u7406)")
    @GetMapping(value={"/getRiskDetailForPermitCert"})
    public ResponseData<List<RiskDetailVo>> getRiskDetailForPermitCert(RiskQueryParam param) {
        return ResponseData.success(this.riskBasicService.getRiskDetailForPermitCert(param));
    }

    @ApiOperation(value="\u8be6\u60c5-\u4f01\u4e1a\u8be6\u60c5\u53ca\u9a8c\u6536\u8bb0\u5f55(\u9876\u90e8)")
    @GetMapping(value={"/getCompanyInfoAndRiskStatistic"})
    public ResponseData<RiskDetailVo> getCompanyInfoAndRiskStatistic(RiskQueryParam param) {
        return ResponseData.success((Object)this.riskBasicService.getCompanyInfoAndRiskStatistic(param));
    }

    @ApiOperation(value="\u8be6\u60c5-\u98ce\u9669\u7edf\u8ba1\u6570\u636e(\u9876\u90e82)")
    @GetMapping(value={"/getRiskStatisticData"})
    public ResponseData<RiskDetailStatisticDataVo> getRiskStatisticData(RiskQueryParam param) {
        return ResponseData.success((Object)this.riskBasicService.getRiskStatisticData(param));
    }

    @ApiOperation(value="\u8be6\u60c5-source\u98ce\u9669\u5217\u8868(\u5e95\u90e8)")
    @GetMapping(value={"/listSourceByRiskId"})
    public ResponseData<LayuiGridData<RiskDetailSourceVo>> listSourceByRiskId(RiskQueryParam param) {
        return ResponseData.success(this.sourceService.listSourceByRiskId(param));
    }

    @ApiOperation(value="\u98ce\u9669\u72b6\u6001\u53d8\u66f4\u8bb0\u5f55")
    @GetMapping(value={"/listSourceHistory"})
    public ResponseData<LayuiGridData<RiskSourceHistoryVo>> listSourceHistory(RiskQueryParam param) {
        return ResponseData.success(this.sourceHistoryService.listSourceHistory(param));
    }

    @ApiOperation(value="\u9a8c\u6536")
    @PostMapping(value={"/saveAcceptanceCheckForSup"})
    public ResponseData<String> saveAcceptanceCheckForSup(@RequestBody AcceptanceRiskParam param) {
        this.acceptanceRecordService.acceptanceRisk(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u98ce\u9669\u5316\u89e3\u7ba1\u7406\u6e05\u5355 - \u5bfc\u51fa")
    @PostMapping(value={"/exportRiskList"}, produces={"application/octet-stream"})
    public void exportCompanyList(HttpServletResponse response, @RequestBody RiskQueryParam param) {
        param.setLimit(Integer.MAX_VALUE);
        List<RiskListExportVo> list = this.riskBasicService.listRiskExportData(param);
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode(String.format("\u98ce\u9669\u5316\u89e3\u7ba1\u7406\u6e05\u5355%s.xlsx", LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)), "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName);
            EasyExcel.write((OutputStream)response.getOutputStream(), RiskListExportVo.class).sheet("Sheet1").doWrite(list);
        }
        catch (Exception e) {
            this.logger.error("Exception:{}", (Throwable)e);
        }
    }
}

