/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.controller.keyFactor;

import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.supervise.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.supervise.model.keyFactor.param.ChangeLicensePushTypeParam;
import cn.smarthse.rho.modules.supervise.model.keyFactor.param.RiskCompanyQueryParam;
import cn.smarthse.rho.modules.supervise.model.keyFactor.vo.RiskCompanyStatisticListVo;
import cn.smarthse.rho.modules.supervise.service.b.IBLicenseManagementSettingService;
import cn.smarthse.rho.modules.supervise.service.b.IBStatisticService;
import com.alibaba.excel.EasyExcel;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1301, author="chuhy")
@Api(tags={"\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u98ce\u9669\u5316\u89e3\u5b8c\u6210\u60c5\u51b5\u533b\u9662\u6e05\u5355"})
@RestController
@RequestMapping(value={"/risk/company"})
public class RiskCompanyController
extends ControllerSupport {
    @Autowired
    private IBStatisticService statisticService;
    @Autowired
    private IBLicenseManagementSettingService licenseManagementSettingService;

    @ApiOperation(value="\u5217\u8868")
    @GetMapping(value={"/getListData"})
    public ResponseData<LayuiGridData<RiskCompanyStatisticListVo>> listCompanyRiskSituation(RiskCompanyQueryParam param) {
        return ResponseData.success(this.statisticService.listCompanyRiskSituation(param));
    }

    @ApiOperation(value="\u67e5\u770b\u8bb8\u53ef\u7ba1\u7406\u9884\u8b66\u8bbe\u7f6e")
    @PostMapping(value={"/getPushTypeForSup"})
    public ResponseData<Integer> getPushTypeForSup() {
        return ResponseData.success((Object)this.licenseManagementSettingService.getPushTypeForSup(ShiroUtil.getLoginUserId()));
    }

    @ApiOperation(value="\u4fee\u6539\u8bb8\u53ef\u7ba1\u7406\u9884\u8b66\u8bbe\u7f6e")
    @PostMapping(value={"/changePushTypeForSup"})
    public ResponseData<String> changePushTypeForSup(@RequestBody ChangeLicensePushTypeParam param) {
        this.licenseManagementSettingService.changePushType(param.getPushType(), ShiroUtil.getLoginUserId());
        return ResponseData.success((Object)"\u64cd\u4f5c\u6210\u529f");
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @GetMapping(value={"export"}, produces={"application/octet-stream"})
    public void export(HttpServletResponse response, RiskCompanyQueryParam param) throws IOException {
        param.setLimit(Integer.MAX_VALUE);
        String fileName = URLEncoder.encode(String.format("\u98ce\u9669\u5316\u89e3\u5b8c\u6210\u60c5\u51b5\u533b\u9662\u6e05\u5355%s.xlsx", LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)), "UTF-8").replaceAll("\\+", "%20");
        List list = this.statisticService.listCompanyRiskSituation(param).getData();
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.setHeader("Content-disposition", "attachment;filename=" + fileName);
        EasyExcel.write((OutputStream)response.getOutputStream(), RiskCompanyStatisticListVo.class).sheet("Sheet1").doWrite((Collection)list);
    }
}

