/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.controller.keyFactor;

import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.model.IdParam;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.supervise.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.supervise.service.r.IRKeyFactorAuditService;
import cn.smarthse.rho.modules.sys.entity.sys.SysBusinessOperateLog;
import cn.smarthse.rho.modules.sys.model.r.param.RKeyFactorAuditParam;
import cn.smarthse.rho.modules.sys.model.r.param.RKeyFactorAuditSearchParam;
import cn.smarthse.rho.modules.sys.model.r.vo.RKeyFactorAuditDetailVo;
import cn.smarthse.rho.modules.sys.model.r.vo.RKeyFactorAuditVo;
import cn.smarthse.rho.modules.sys.model.sys.param.SysBusinessOperateLogParam;
import cn.smarthse.rho.modules.sys.provider.sys.ISysAreaProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysBusinessOperateLogProvider;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1304, author="wuxq")
@Api(tags={"\u5173\u952e\u56e0\u7d20\u753b\u50cf\uff1a\u5ba1\u6838\u5217\u8868"})
@RestController
@RequestMapping(value={"/keyFactorAudit"})
public class KeyFactorAuditController
extends ControllerSupport {
    private final IRKeyFactorAuditService rKeyFactorAuditService;
    @DubboReference
    private ISysBusinessOperateLogProvider operateLogProvider;
    @DubboReference
    private ISysAreaProvider sysAreaProvider;

    @ApiOperation(value="\u5217\u8868")
    @RequiresPermissions(value={"risk.manage.view"})
    @GetMapping(value={"/getListData"})
    public ResponseData<LayuiGridData<RKeyFactorAuditVo>> getListData(RKeyFactorAuditSearchParam param) {
        if (param.getAreaId() == null) {
            param.setAreaId(ShiroUtil.getLoginUserAreaId());
            param.setLevel(Integer.valueOf(Objects.requireNonNull(ShiroUtil.getLoginUserAreaLevel()).intValue()));
        } else {
            param.setLevel(this.sysAreaProvider.getLevel(param.getAreaId()));
        }
        return ResponseData.success(this.rKeyFactorAuditService.getListData(param));
    }

    @ApiOperation(value="\u8be6\u60c5")
    @RequiresPermissions(value={"risk.manage.view"})
    @GetMapping(value={"/getDetail"})
    public ResponseData<RKeyFactorAuditDetailVo> getDetail(IdParam param) {
        return ResponseData.success((Object)this.rKeyFactorAuditService.getDetail(param.getId()));
    }

    @ApiOperation(value="\u753b\u50cf\u5ba1\u6838")
    @RequiresPermissions(value={"risk.manage.edit"})
    @PostMapping(value={"/audit"})
    public ResponseData<String> audit(@RequestBody RKeyFactorAuditParam param) {
        param.setOperator(ShiroUtil.getLoginUsername());
        this.rKeyFactorAuditService.audit(param);
        return ResponseData.success();
    }

    @ApiOperation(value="\u64cd\u4f5c\u8bb0\u5f55\u5217\u8868")
    @RequiresPermissions(value={"risk.manage.view"})
    @GetMapping(value={"/getOperateLogListData"})
    public ResponseData<LayuiGridData<SysBusinessOperateLog>> getOperateLogListData(SysBusinessOperateLogParam param) {
        return ResponseData.success((Object)this.operateLogProvider.getPageListData(param));
    }

    public KeyFactorAuditController(IRKeyFactorAuditService rKeyFactorAuditService) {
        this.rKeyFactorAuditService = rKeyFactorAuditService;
    }
}

