/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.controller.company;

import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.PageParam;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.core.framework.utils.DateUtils;
import cn.smarthse.core.framework.utils.EasyExcelUtil;
import cn.smarthse.rho.modules.supervise.model.company.param.BCompanySearchParam;
import cn.smarthse.rho.modules.supervise.model.company.vo.BCompanyCountVo;
import cn.smarthse.rho.modules.supervise.model.company.vo.BCompanyExportVo;
import cn.smarthse.rho.modules.supervise.model.company.vo.BCompanyListVo;
import cn.smarthse.rho.modules.supervise.service.b.IBCompanyService;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysSettingTableVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysSettingTableProvider;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=11, author="chuhy")
@Api(tags={"\u533b\u7528\u653e\u5c04\u5355\u4f4d\u7ba1\u7406\u6863\u6848"})
@RestController
@RequestMapping(value={"/company"})
public class CompanyController
extends ControllerSupport {
    private final IBCompanyService bCompanyService;
    @DubboReference
    private ISysSettingTableProvider settingTableProvider;

    @ApiOperation(value="\u8868\u5934\u7edf\u8ba1")
    @GetMapping(value={"/getCount"})
    public ResponseData<BCompanyCountVo> getCount(PageParam param) {
        return ResponseData.success((Object)this.bCompanyService.getCompanyCount(param));
    }

    @ApiOperation(value="\u5217\u8868")
    @GetMapping(value={"/getListData"})
    public ResponseData<LayuiGridData<BCompanyListVo>> getListData(BCompanySearchParam param) {
        param.setYear(DateUtils.getYear((Date)new Date()));
        return ResponseData.success(this.bCompanyService.getListDataForSup(param));
    }

    @ApiOperation(value="\u8be6\u60c5")
    @GetMapping(value={"/getCompany"})
    public ResponseData<BCompanyVo> getCompany(@NotNull Long cid) {
        return ResponseData.success(null);
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @PostMapping(value={"/exportCompanyList"}, produces={"application/octet-stream"})
    public void exportCompanyList(HttpServletResponse response, @RequestBody BCompanySearchParam param) {
        String fileName = String.format("\u533b\u7528\u653e\u5c04\u5355\u4f4d\u6863\u6848%s", LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE));
        param.setPage(0);
        param.setLimit(5000);
        EasyExcelUtil.exportDynamicExcel((List)param.headField(), (String)fileName, BCompanyListVo.class, (HttpServletResponse)response, () -> {
            param.setPage(param.getPage() + 1);
            return this.bCompanyService.listSysCompanyExportData(param);
        });
    }

    private List<List<String>> head(SysSettingTableVo settingTable) {
        String tableData = settingTable.getData();
        return Arrays.stream(tableData.split(",")).map(str -> str.split("\\|")[0].trim()).map(Collections::singletonList).collect(Collectors.toList());
    }

    private List<List<String>> handleWriteData(SysSettingTableVo settingTable, List<BCompanyExportVo> dataList) {
        List tableNameList = Arrays.stream(settingTable.getData().split(",")).map(str -> str.split("\\|")[0].trim()).collect(Collectors.toList());
        ArrayList<List<String>> rst = new ArrayList<List<String>>();
        dataList.stream().forEach(data -> {
            ArrayList rowData = new ArrayList();
            Field[] fields = data.getClass().getDeclaredFields();
            HashMap<String, String> map = new HashMap<String, String>();
            for (Field field : fields) {
                field.setAccessible(true);
                try {
                    String value = field.get(data) == null ? null : field.get(data).toString();
                    map.put(field.getName(), value);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            for (String str : tableNameList) {
                rowData.add(map.get(str));
            }
            rst.add(rowData);
        });
        return rst;
    }

    public CompanyController(IBCompanyService bCompanyService) {
        this.bCompanyService = bCompanyService;
    }
}

