/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.controller.common;

import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.MD5;
import cn.hutool.http.HtmlUtil;
import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.bean.OssClientBean;
import cn.smarthse.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.core.framework.model.ResponseStateEnum;
import cn.smarthse.core.framework.uploader.FileResourceEnum;
import cn.smarthse.core.framework.uploader.FileUploadSimple;
import cn.smarthse.core.framework.uploader.UploadFileParameter;
import cn.smarthse.core.framework.uploader.UploadFilePathEnum;
import cn.smarthse.core.framework.utils.ServletUtils;
import cn.smarthse.core.framework.utils.StringUtils;
import cn.smarthse.core.framework.utils.login.JwtUtil;
import cn.smarthse.rho.modules.supervise.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.sys.entity.sys.SysFile;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@ApiSupport(order=1, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u516c\u5171\u63a5\u53e3-\u6587\u4ef6\u4e0a\u4f20\u4e0b\u8f7d"})
@RestController
@RequestMapping(value={"/common/file"})
public class FileUploadController
extends ControllerSupport {
    @DubboReference(check=false)
    private ISysFileProvider sysFileProvideService;
    private final OssClientBean ossClientBean;
    private final ThreadPoolTaskExecutor taskExecutor;
    private final SysProperties sysProperties;
    private final Path tempDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);

    @ApiOperation(value="\u901a\u8fc7Form\u4e0a\u4f20\u9644\u4ef6")
    @Log(title="\u4e0a\u4f20\u9644\u4ef6", type=LogTypeEnum.type_opt_upload)
    @ResponseBody
    @RequestMapping(value={"upload"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    public ResponseData<SysFileVo> upload(HttpServletRequest request, @RequestPart(value="file") MultipartFile fileData) throws IOException {
        String type = FileTypeUtil.getType((InputStream)fileData.getInputStream(), (boolean)true);
        if (!this.sysProperties.getSupportFileTypes().contains(type)) {
            return ResponseData.fail((String)"\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\uff01");
        }
        long size = fileData.getSize();
        String hashCode = MD5.create().digestHex(fileData.getBytes());
        SysFileVo existSysFile = this.sysFileProvideService.getFileByHash(hashCode);
        if (existSysFile != null) {
            existSysFile.setFullOssUrl(this.ossClientBean.getUrl(existSysFile.getFullOssUrl()));
            return new ResponseData("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f(hash\u503c\u5b58\u5728)\uff01", (Object)existSysFile);
        }
        String originalFilename = fileData.getOriginalFilename();
        List split = StrUtil.split((CharSequence)originalFilename, (CharSequence)".");
        if (split.size() != 2) {
            throw new ServiceException("\u6587\u4ef6\u540d\u4e0d\u53ef\u5305\u542b\u591a\u4e2a'.'\u7b26\u53f7\uff01");
        }
        String fileNameExExt = (String)split.get(0);
        if (StrUtil.isBlank((CharSequence)(fileNameExExt = HtmlUtil.cleanHtmlTag((String)HtmlUtil.filter((String)fileNameExExt))))) {
            throw new ServiceException("\u6587\u4ef6\u540d\u4e0d\u5408\u6cd5\uff01");
        }
        originalFilename = fileNameExExt + "." + (String)split.get(1);
        String uploadFile = UploadFileParameter.FILE_PATH + FileResourceEnum.rho_supervise.getCode() + File.separator + UploadFilePathEnum.Common.getPath() + File.separator + FileUploadSimple.getDataPath() + File.separator + UUID.randomUUID() + "-" + originalFilename;
        String res = this.ossClientBean.OSSPutObject(uploadFile, originalFilename, fileData.getInputStream());
        SysFile file = new SysFile();
        file.setCid(JwtUtil.getOid());
        file.setResource(Integer.valueOf(FileResourceEnum.rho_supervise.getValue()));
        file.setFileName(originalFilename);
        file.setFileSize(Long.valueOf(size));
        file.setFileExt(FileUtil.getSuffix((String)originalFilename));
        file.setFileHash(hashCode);
        file.setCreatorIp(ServletUtils.getIp((HttpServletRequest)request));
        file.setOssUrl(res);
        SysFileVo result = this.sysFileProvideService.addSysFile(file, ShiroUtil.getLoginUserId());
        return new ResponseData("\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff01", (Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6OSS\u76f4\u4f20\u7b7e\u540d", hidden=true)
    @ResponseBody
    @RequestMapping(value={"postSignature"}, method={RequestMethod.GET})
    public Map<String, String> postSignature() throws Exception {
        String uploadDir = UploadFileParameter.FILE_PATH + FileResourceEnum.rho_supervise.getCode() + UploadFileParameter.FILE_PATH_SEP + UploadFilePathEnum.Common.getPath();
        return this.ossClientBean.getPostSignature(uploadDir);
    }

    @ApiOperation(value="\u9a8c\u8bc1\u9644\u4ef6MD5\u7801", hidden=true)
    @ResponseBody
    @RequestMapping(value={"check/{filehash}"}, method={RequestMethod.POST})
    public ResponseData<SysFileVo> checkfilemd5(@PathVariable(value="filehash") String filehash) {
        this.logger.debug("\u3010\u7cfb\u7edf\u9644\u4ef6\u3011->\u3010\u9a8c\u8bc1{}\u3011", (Object)filehash);
        SysFileVo record = this.sysFileProvideService.getFileByHash(filehash);
        ResponseData data = new ResponseData();
        if (record != null) {
            data.setResult((Object)record);
            data.setState(ResponseStateEnum.success.getValue());
        } else {
            data.setState(ResponseStateEnum.fail.getValue());
        }
        return data;
    }

    @ApiOperation(value="\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6oss\u5730\u5740")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileId", value="\u6587\u4ef6id")})
    @RequestMapping(value={"getFileUrl"}, method={RequestMethod.POST})
    public ResponseData<String> getFileUrl(Long fileId) {
        this.logger.debug("\u3010\u7cfb\u7edf\u9644\u4ef6\u3011-\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6oss\u5730\u5740, fileId={}", (Object)fileId);
        ResponseData data = new ResponseData(ResponseStateEnum.success.getValue());
        if (fileId == null) {
            data.setResult((Object)"");
            data.setMessage("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
            return data;
        }
        String fileUrl = this.sysFileProvideService.getFileUrl(fileId);
        if (fileUrl != null) {
            data.setResult((Object)fileUrl);
            data.setMessage("\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6oss\u5730\u5740\u6210\u529f\uff01");
        } else {
            data.setState(ResponseStateEnum.fail.getValue());
            data.setMessage("\u6ca1\u6709\u8be5id\u7684\u6587\u4ef6\uff01");
        }
        return data;
    }

    @ApiOperation(value="\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileId", value="\u6587\u4ef6id")})
    @RequestMapping(value={"getFile"}, method={RequestMethod.POST})
    public ResponseData<SysFileVo> getFile(Long fileId) {
        this.logger.debug("\u3010\u7cfb\u7edf\u9644\u4ef6\u3011-\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61, fileId={}", (Object)fileId);
        ResponseData data = new ResponseData(ResponseStateEnum.success.getValue());
        if (fileId == null) {
            data.setMessage("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
            return data;
        }
        SysFileVo file = this.sysFileProvideService.getFileById(fileId);
        if (file != null) {
            data.setResult((Object)file);
            data.setMessage("\u901a\u8fc7id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61\u6210\u529f\uff01");
        } else {
            data.setState(ResponseStateEnum.fail.getValue());
            data.setMessage("\u6ca1\u6709\u8be5id\u7684\u6587\u4ef6\uff01");
        }
        return data;
    }

    @ApiOperation(value="\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61\u96c6\u5408")
    @ApiImplicitParams(value={@ApiImplicitParam(name="fileIds", value="\u6587\u4ef6ids(\u9017\u53f7\u9694\u5f00)")})
    @RequestMapping(value={"getFileList"}, method={RequestMethod.POST})
    public ResponseData<List<SysFileVo>> getFileList(String fileIds) {
        this.logger.debug("\u3010\u7cfb\u7edf\u9644\u4ef6\u3011-\u901a\u8fc7\u6587\u4ef6id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61\u96c6\u5408, fileIds={}", (Object)fileIds);
        ResponseData data = new ResponseData(ResponseStateEnum.success.getValue());
        if (StringUtils.isEmpty((CharSequence)fileIds)) {
            data.setMessage("\u6587\u4ef6id\u4e3a\u7a7a\uff01");
            return data;
        }
        List list = this.sysFileProvideService.getFileVoByIds(fileIds);
        if (list != null && !list.isEmpty()) {
            data.setResult((Object)list);
            data.setMessage("\u901a\u8fc7id\u83b7\u53d6\u6587\u4ef6\u5bf9\u8c61 \u6210\u529f\uff01");
        } else {
            data.setState(ResponseStateEnum.fail.getValue());
            data.setMessage("\u6ca1\u6709\u8be5id\u7684\u6587\u4ef6\uff01");
        }
        return data;
    }

    public FileUploadController(OssClientBean ossClientBean, ThreadPoolTaskExecutor taskExecutor, SysProperties sysProperties) {
        this.ossClientBean = ossClientBean;
        this.taskExecutor = taskExecutor;
        this.sysProperties = sysProperties;
    }
}

