/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.controller.common;

import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.annotation.RequestLimit;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.PageParam;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.sys.model.sys.param.SysParamQueryParam;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo2;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysParamTypeVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysParamVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysAreaProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysParamProvider;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.validation.constraints.NotEmpty;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=1, author="\u5ed6\u51cc\u4e91")
@Api(tags={"\u516c\u5171\u63a5\u53e3"})
@RestController
@RequestMapping(value={"/common"})
public class CommonController
extends ControllerSupport {
    @DubboReference
    private ISysAreaProvider sysAreaProvider;
    @DubboReference
    private ISysParamProvider sysParamProvider;

    @ApiOperation(value="\u884c\u653f\u533a\u5212\uff1a\u8be6\u60c5")
    @ApiImplicitParam(name="id", value="id", required=true, paramType="query", dataTypeClass=String.class)
    @RequestLimit(maxCount=5, expression="#id")
    @GetMapping(value={"/area/getAreaById"})
    public ResponseData<SysAreaVo> getAreaById(@NotEmpty Long id) {
        return ResponseData.success((Object)this.sysAreaProvider.getAreaById(id));
    }

    @ApiOperation(value="\u884c\u653f\u533a\u5212\uff1a\u8be6\u60c5V2")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true, paramType="query", dataTypeClass=String.class)})
    @GetMapping(value={"/area/getAreaV2"})
    public ResponseData<SysAreaVo2> getAreaV2(@NotEmpty Long id) {
        return ResponseData.success((Object)this.sysAreaProvider.getAreaByIdV2(id));
    }

    @ApiOperation(value="\u884c\u653f\u533a\u5212\uff1a\u4e0b\u7ea7\u5217\u8868")
    @ApiImplicitParams(value={@ApiImplicitParam(name="parentId", value="parentId", required=true, paramType="query", dataTypeClass=String.class)})
    @GetMapping(value={"/area/getAreaList"})
    public ResponseData<List<SysAreaVo>> getAreaList(@NotEmpty Long parentId) {
        return ResponseData.success((Object)this.sysAreaProvider.getAreaList(parentId));
    }

    @ApiOperation(value="\u7cfb\u7edf\u53c2\u6570\uff1a\u53c2\u6570\u7c7b\u578b\u5217\u8868")
    @RequestLimit(maxCount=5, expression="#param.page")
    @GetMapping(value={"/param/getParamTypeList"})
    public ResponseData<List<SysParamTypeVo>> getParamTypeList(PageParam param) {
        return ResponseData.success((Object)this.sysParamProvider.getParamTypeList(param));
    }

    @ApiOperation(value="\u7cfb\u7edf\u53c2\u6570\uff1a\u53c2\u6570\u5206\u9875\u5217\u8868")
    @RequestLimit(maxCount=5, expression="#type")
    @GetMapping(value={"/param/getParamPageList"})
    public ResponseData<LayuiGridData<SysParamVo>> getPageList(SysParamQueryParam param) {
        return ResponseData.success((Object)this.sysParamProvider.getPageList(param));
    }

    @ApiOperation(value="\u7cfb\u7edf\u53c2\u6570\uff1a\u53c2\u6570\u5217\u8868")
    @ApiImplicitParam(name="type", value="\u53c2\u6570\u7c7b\u578b", required=true, paramType="query", dataTypeClass=String.class)
    @RequestLimit(maxCount=5, expression="#type")
    @GetMapping(value={"/param/getParamList"})
    public ResponseData<List<SysParamVo>> getParamList(@NotEmpty Long type) {
        return ResponseData.success((Object)this.sysParamProvider.getList(type));
    }
}

