/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.controller.base;

import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.model.LayuiGridData;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.supervise.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.supervise.manage.staff.StaffManager;
import cn.smarthse.rho.modules.supervise.model.c.param.StaffStatisticsAdminParam;
import cn.smarthse.rho.modules.supervise.model.c.vo.CDoseDataVo;
import cn.smarthse.rho.modules.supervise.model.c.vo.CHealthCheckDataVo;
import cn.smarthse.rho.modules.supervise.model.c.vo.CStaffWorkExperienceAdminVo;
import cn.smarthse.rho.modules.supervise.model.c.vo.CTrainingCertVo;
import cn.smarthse.rho.modules.supervise.model.staffArchives.param.CertConditionParam;
import cn.smarthse.rho.modules.supervise.model.staffArchives.param.StaffInfoAdminParam;
import cn.smarthse.rho.modules.supervise.model.staffArchives.param.StaffPageAdminParam;
import cn.smarthse.rho.modules.supervise.model.staffArchives.vo.StaffArchiveListAdminVo;
import cn.smarthse.rho.modules.supervise.model.staffArchives.vo.StaffDetailInfoVo;
import cn.smarthse.rho.modules.sys.model.b.vo.CStaffInfoRangeVo;
import cn.smarthse.rho.modules.sys.model.c.param.CDoseQueryParam;
import cn.smarthse.rho.modules.sys.model.c.param.CHealthCheckQueryParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffInfoRangeParam;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffWorkExperiencePageParam;
import cn.smarthse.rho.modules.sys.model.c.param.CTrainingCertPageParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffAcInfoParam;
import cn.smarthse.rho.modules.sys.model.c.vo.CertConditionVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffAcVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffArchiveStatisticsAdminVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysAreaVo;
import cn.smarthse.rho.modules.sys.provider.c.IStaffProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysAreaProvider;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=12, author="xxx")
@Api(tags={"\u653e\u5c04\u5de5\u4f5c\u4eba\u5458\u7ba1\u7406\u6863\u6848"})
@RestController
@RequestMapping(value={"/staff"})
public class StaffInfoController
extends ControllerSupport {
    private final StaffManager staffManager;
    @DubboReference
    private ISysAreaProvider areaProvider;
    @DubboReference(registry={"local_nacos"})
    private IStaffProvider staffProvider;

    @ApiOperation(value="\u83b7\u53d6\u4eba\u5458\u6863\u6848\u5217\u8868")
    @RequiresPermissions(value={"staff.view"})
    @GetMapping(value={"/getStaffArchiveList"})
    public ResponseData<LayuiGridData<StaffArchiveListAdminVo>> getStaffArchiveList(StaffPageAdminParam param) {
        SysAreaVo area = this.areaProvider.analysisAreaPermissions(ShiroUtil.getLoginUserAreaId(), param.getAreaId());
        param.setIsOnlineSpecialTestUser(ShiroUtil.isOnlineSpecialSuperAndTestUser());
        param.setAreaId(area.getId());
        param.setLevel(area.getLevel());
        Integer onlyThisArea = param.getOnlyThisArea();
        onlyThisArea = onlyThisArea == null ? 1 : onlyThisArea;
        param.setOnlyThisArea(onlyThisArea);
        LayuiGridData<StaffArchiveListAdminVo> result = this.staffManager.getStaffArchiveList(param);
        return ResponseData.success(result);
    }

    @ApiOperation(value="\u83b7\u53d6\u4eba\u5458\u57fa\u7840\u4fe1\u606f")
    @RequiresPermissions(value={"staff.view"})
    @GetMapping(value={"/getBaseInfo"})
    public ResponseData<StaffDetailInfoVo> getBaseInfo(StaffInfoAdminParam param) {
        SysAreaVo area = this.areaProvider.analysisAreaPermissions(ShiroUtil.getLoginUserAreaId(), param.getAreaId());
        param.setIsOnlineSpecialTestUser(ShiroUtil.isOnlineSpecialSuperAndTestUser());
        param.setAreaId(area.getId());
        param.setLevel(area.getLevel());
        StaffDetailInfoVo result = this.staffManager.getInfo(param);
        return ResponseData.success((Object)result);
    }

    @ApiOperation(value="\u83b7\u53d6\u4eba\u5458\u91cd\u8981\u4fe1\u606f")
    @RequiresPermissions(value={"staff.view"})
    @GetMapping(value={"/getAcInfo"})
    @Log(type=LogTypeEnum.anon, logModule=LogModuleTypeEnum.sup_staff_archives, title="\u76d1\u7ba1\u7aef-\u83b7\u53d6\u4eba\u5458\u91cd\u8981\u4fe1\u606f")
    public ResponseData<StaffAcVo> getAcInfo(StaffAcInfoParam param) {
        return ResponseData.success((Object)this.staffManager.getAcInfo(param));
    }

    @ApiOperation(value="\u4eba\u5458\u5de5\u4f5c\u6863\u6848\u8be6\u60c5-\u7edf\u8ba1")
    @RequiresPermissions(value={"staff.view"})
    @GetMapping(value={"/getStaffArchiveStatistics"})
    public ResponseData<StaffArchiveStatisticsAdminVo> getStaffArchiveStatistics(StaffStatisticsAdminParam param) {
        SysAreaVo area = this.areaProvider.analysisAreaPermissions(ShiroUtil.getLoginUserAreaId(), param.getAreaId());
        param.setIsOnlineSpecialTestUser(ShiroUtil.isOnlineSpecialSuperAndTestUser());
        param.setAreaId(area.getId());
        param.setLevel(area.getLevel());
        return ResponseData.success((Object)this.staffManager.getStaffArchiveStatistics(param));
    }

    @ApiOperation(value="\u83b7\u53d6\u4eba\u5458\u53d6\u8bc1\u6761\u4ef6\u60c5\u51b5")
    @RequiresPermissions(value={"staff.view"})
    @GetMapping(value={"/getCertCondition"})
    public ResponseData<CertConditionVo> getCertCondition(CertConditionParam param) {
        SysAreaVo area = this.areaProvider.analysisAreaPermissions(ShiroUtil.getLoginUserAreaId(), param.getAreaId());
        param.setIsOnlineSpecialTestUser(ShiroUtil.isOnlineSpecialSuperAndTestUser());
        param.setAreaId(area.getId());
        param.setLevel(area.getLevel());
        CertConditionVo certConditionVo = this.staffManager.getCertCondition(param);
        return ResponseData.success((Object)certConditionVo);
    }

    @ApiOperation(value="\u4eba\u5458\u5de5\u4f5c\u6863\u6848-\u4f53\u68c0\u6570\u636e\u5217\u8868")
    @RequiresPermissions(value={"staff.view"})
    @GetMapping(value={"/getList/health"})
    public ResponseData<LayuiGridData<CHealthCheckDataVo>> getHealthList(CHealthCheckQueryParam param) {
        SysAreaVo area = this.areaProvider.analysisAreaPermissions(ShiroUtil.getLoginUserAreaId(), param.getAreaId());
        param.setIsOnlineSpecialTestUser(ShiroUtil.isOnlineSpecialSuperAndTestUser());
        param.setAreaId(area.getId());
        param.setLevel(area.getLevel());
        CStaffInfoRangeVo rangeVo = this.staffProvider.getStaffInfoRangeForAdmin(new CStaffInfoRangeParam().setIsOnlineSpecialTestUser(ShiroUtil.isOnlineSpecialSuperAndTestUser()).setStaffBaseInfoId(param.getStaffBaseInfoId()).setAreaId(param.getAreaId()).setLevel(param.getLevel()));
        if (rangeVo == null) {
            throw new ServiceException("\u6570\u636e\u8303\u56f4\u5224\u65ad\u5f02\u5e38");
        }
        param.setOnlyHistoryStaffInfo(rangeVo.getOnlyHistoryStaffInfo());
        param.setNewestPostDepartureTime(rangeVo.getNewestPostDepartureTime());
        return ResponseData.success(this.staffManager.getHealthList(param));
    }

    @ApiOperation(value="\u4eba\u5458\u5de5\u4f5c\u6863\u6848\u8be6\u60c5-\u5242\u91cf\u5217\u8868")
    @RequiresPermissions(value={"staff.view"})
    @GetMapping(value={"/getList/dose"})
    public ResponseData<LayuiGridData<CDoseDataVo>> getDoseList(CDoseQueryParam param) {
        SysAreaVo area = this.areaProvider.analysisAreaPermissions(ShiroUtil.getLoginUserAreaId(), param.getAreaId());
        param.setIsOnlineSpecialTestUser(ShiroUtil.isOnlineSpecialSuperAndTestUser());
        param.setAreaId(area.getId());
        param.setLevel(area.getLevel());
        CStaffInfoRangeVo rangeVo = this.staffProvider.getStaffInfoRangeForAdmin(new CStaffInfoRangeParam().setStaffBaseInfoId(param.getStaffBaseInfoId()).setAreaId(param.getAreaId()).setLevel(param.getLevel()));
        if (rangeVo == null) {
            throw new ServiceException("\u6570\u636e\u8303\u56f4\u5224\u65ad\u5f02\u5e38");
        }
        param.setOnlyHistoryStaffInfo(rangeVo.getOnlyHistoryStaffInfo());
        param.setNewestPostDepartureTime(rangeVo.getNewestPostDepartureTime());
        return ResponseData.success(this.staffManager.getDoseList(param));
    }

    @ApiOperation(value="\u4eba\u5458\u6863\u6848-\u5de5\u4f5c\u7ecf\u5386\u5217\u8868")
    @RequiresPermissions(value={"staff.view"})
    @GetMapping(value={"/getList/workExperience"})
    public ResponseData<LayuiGridData<CStaffWorkExperienceAdminVo>> getWorkExperienceList(CStaffWorkExperiencePageParam param) {
        SysAreaVo area = this.areaProvider.analysisAreaPermissions(ShiroUtil.getLoginUserAreaId(), param.getAreaId());
        param.setIsOnlineSpecialTestUser(ShiroUtil.isOnlineSpecialSuperAndTestUser());
        param.setAreaId(area.getId());
        param.setLevel(area.getLevel());
        return ResponseData.success(this.staffManager.getWorkExperienceList(param));
    }

    @ApiOperation(value="\u4eba\u5458\u6863\u6848-\u8bc1\u4e66\u5217\u8868")
    @RequiresPermissions(value={"staff.view"})
    @GetMapping(value={"/getList/getCertList"})
    public ResponseData<LayuiGridData<CTrainingCertVo>> getCertList(CTrainingCertPageParam param) {
        SysAreaVo area = this.areaProvider.analysisAreaPermissions(ShiroUtil.getLoginUserAreaId(), param.getAreaId());
        param.setIsOnlineSpecialTestUser(ShiroUtil.isOnlineSpecialSuperAndTestUser());
        param.setAreaId(area.getId());
        param.setLevel(area.getLevel());
        CStaffInfoRangeVo rangeVo = this.staffProvider.getStaffInfoRangeForAdmin(new CStaffInfoRangeParam().setStaffBaseInfoId(param.getStaffBaseInfoId()).setAreaId(param.getAreaId()).setLevel(param.getLevel()));
        if (rangeVo == null) {
            throw new ServiceException("\u6570\u636e\u8303\u56f4\u5224\u65ad\u5f02\u5e38");
        }
        param.setOnlyHistoryStaffInfo(rangeVo.getOnlyHistoryStaffInfo());
        param.setNewestPostDepartureTime(rangeVo.getNewestPostDepartureTime());
        return ResponseData.success(this.staffManager.getCertList(param));
    }

    public StaffInfoController(StaffManager staffManager) {
        this.staffManager = staffManager;
    }
}

