/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.controller.base;

import cn.smarthse.common.web.core.ControllerSupport;
import cn.smarthse.core.framework.annotation.Log;
import cn.smarthse.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.core.framework.annotation.LogTypeEnum;
import cn.smarthse.core.framework.model.ResponseData;
import cn.smarthse.rho.modules.supervise.service.c.ICCertService;
import cn.smarthse.rho.modules.supervise.service.cert.CertService;
import cn.smarthse.rho.modules.sys.model.c.param.GenCertParam;
import cn.smarthse.rho.modules.sys.model.c.vo.CCertVo;
import com.github.xiaoymin.knife4j.annotations.ApiSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@ApiSupport(order=12, author="xxx")
@Api(tags={"\u5458\u5de5\uff1a\u8bc1\u4e66"})
@RestController
@RequestMapping(value={"/cert"})
public class CertController
extends ControllerSupport {
    private final CertService certService;
    private final ICCertService certInfoService;

    @ApiOperation(value="\u751f\u6210\u8bc1\u4e66")
    @RequiresPermissions(value={"staff.edit"})
    @PostMapping(value={"/genCert"})
    @Log(type=LogTypeEnum.type_opt_add, logModule=LogModuleTypeEnum.com_base_staff, title="\u5458\u5de5\uff1a\u8bc1\u4e66-\u751f\u6210\u8bc1\u4e66")
    public ResponseData<CCertVo> genCert(@RequestBody GenCertParam param) {
        CCertVo cCertVo = this.certService.genCert(param.getStaffBaseInfoId());
        return ResponseData.success((Object)cCertVo);
    }

    @ApiOperation(value="\u67e5\u770b\u8bc1\u4e66")
    @RequiresPermissions(value={"staff.edit"})
    @GetMapping(value={"/getCert"})
    @ApiImplicitParams(value={@ApiImplicitParam(name="certId", value="\u8bc1\u4e66id", required=true, dataTypeClass=String.class)})
    public ResponseData<CCertVo> getCert(Long certId) {
        CCertVo cCertVo = this.certInfoService.getCert(certId);
        return ResponseData.success((Object)cCertVo);
    }

    @ApiOperation(value="\u9884\u89c8\u8bc1\u4e66\u6570\u636e")
    @RequiresPermissions(value={"staff.edit"})
    @GetMapping(value={"/previewCertificateData"})
    public ResponseData<CCertVo> previewCertificateData(Long staffBaseInfoId) {
        CCertVo cCertVo = this.certInfoService.previewCertificateData(staffBaseInfoId);
        return ResponseData.success((Object)cCertVo);
    }

    public CertController(CertService certService, ICCertService certInfoService) {
        this.certService = certService;
        this.certInfoService = certInfoService;
    }
}

