/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.bootstrap.security.utils;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.ShiroPrincipal;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.vo.LoginOrganizationUser;
import java.util.Objects;
import java.util.Set;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class ShiroUtil {
    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static ShiroPrincipal getShiroPrincipal() {
        return (ShiroPrincipal)ShiroUtil.getSubject().getPrincipal();
    }

    public static LoginOrganizationUser getUser() {
        ShiroPrincipal principal = ShiroUtil.getShiroPrincipal();
        return principal != null ? principal.getUser() : null;
    }

    public static Long getLoginUserId() {
        LoginOrganizationUser user = ShiroUtil.getUser();
        return user != null ? user.getId() : null;
    }

    public static Long getLoginUserOid() {
        LoginOrganizationUser user = ShiroUtil.getUser();
        return user != null ? user.getOid() : null;
    }

    public static String getLoginUserOrgName() {
        LoginOrganizationUser user = ShiroUtil.getUser();
        return user != null ? user.getOrgName() : null;
    }

    public static String getLoginUsername() {
        LoginOrganizationUser user = ShiroUtil.getUser();
        return user != null ? user.getUsername() : null;
    }

    public static String getLoginFullName() {
        LoginOrganizationUser user = ShiroUtil.getUser();
        return user != null ? user.getFullName() : null;
    }

    public static String getLoginUserTel() {
        LoginOrganizationUser user = ShiroUtil.getUser();
        return user != null ? user.getTel() : null;
    }

    public static SysAreaV3OneVo getLoginUserArea() {
        LoginOrganizationUser user = ShiroUtil.getUser();
        return user != null ? user.getSysArea() : null;
    }

    public static Long getLoginUserAreaId() {
        LoginOrganizationUser user = ShiroUtil.getUser();
        return user != null ? user.getAreaId() : null;
    }

    public static Byte getLoginUserAreaLevel() {
        LoginOrganizationUser user = ShiroUtil.getUser();
        return user != null ? user.getAreaLevel() : null;
    }

    public static Boolean getLoginUserIsManger() {
        LoginOrganizationUser user = ShiroUtil.getUser();
        return user != null ? user.getIsManger() : Boolean.FALSE;
    }

    public static Boolean getLoginUserIsTest() {
        LoginOrganizationUser user = ShiroUtil.getUser();
        return user != null ? user.getIsTest() == 1 : Boolean.FALSE;
    }

    public static Set<Integer> getLoginUserSystemWideList() {
        LoginOrganizationUser user = ShiroUtil.getUser();
        return user != null ? user.getSystemWideList() : CollUtil.newHashSet((Object[])new Integer[0]);
    }

    public static int getCheckVcode(LoginOrganizationUser user) {
        if (user == null) {
            return 0;
        }
        if (user.getTwoFactorCheck() == null || user.getTwoFactorCheck() == 0) {
            return 1;
        }
        return user.getTel() == null || user.getTel().equals("") ? 2 : 0;
    }

    public static boolean hasPermission(String permissionCode) {
        return ShiroUtil.getShiroPrincipal().getPermissionsSet().contains(permissionCode);
    }

    public static boolean hasRole(String roleCode) {
        return ShiroUtil.getShiroPrincipal().getRoleSet().contains(roleCode);
    }

    public static Boolean isOnlineSpecialSuperAndTestUser() {
        LoginOrganizationUser user = ShiroUtil.getUser();
        String loginUserName = user.getUsername();
        return "superuser".equalsIgnoreCase(loginUserName) || Objects.equals(user.getIsTest(), 1);
    }
}

