/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.bootstrap.security.service;

import cn.hutool.captcha.CaptchaUtil;
import cn.hutool.captcha.LineCaptcha;
import cn.hutool.captcha.generator.CodeGenerator;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import cn.smarthse.common.redis.utils.RedisUtils;
import cn.smarthse.common.util.sensitive.SensitiveUtil;
import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.RedisKey;
import cn.smarthse.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.core.framework.captcha.RandomNumberGenerator;
import cn.smarthse.core.framework.utils.login.JwtUtil;
import cn.smarthse.modules.datacentre.provider.system.ISysAreaProvideService;
import cn.smarthse.modules.health.supervise.entity.basic.Organization;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.enums.sys.UserSystemWideEnum;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationService;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysRoleV3Service;
import cn.smarthse.modules.platform.model.v3.sysArea.SysAreaV3OneVo;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.ShiroPrincipal;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.param.CasLoginBody;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.param.DDLoginBody;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.vo.CaptchaVo;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.vo.LoginOrganizationUser;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.vo.LoginVo;
import cn.smarthse.rho.modules.supervise.bootstrap.security.service.PermissionsService;
import cn.smarthse.rho.modules.sys.provider.company.ICompanyProvider;
import java.awt.Font;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.ExcessiveAttemptsException;
import org.apache.shiro.authc.IncorrectCredentialsException;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LoginService {
    private static final Logger log = LoggerFactory.getLogger(LoginService.class);
    private final SysProperties sysProperties;
    private final PermissionsService permissionsService;
    @DubboReference
    private ICompanyProvider companyProvider;
    @DubboReference(registry={"public_nacos"})
    private ISysRoleV3Service sysRoleV3Service;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationService organizationService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationUserService organizationUserService;
    @DubboReference(registry={"public_nacos"}, version="1.0.0")
    private ISysAreaProvideService sysAreaProvideService;

    public void logout(Long userId) {
        RedisUtils.deleteObject((String)RedisKey.getSuperviseLoginUserKey((Long)userId));
        RedisUtils.deleteObject((String)RedisKey.getSuperviseLoginTokenKey((Long)userId));
        Subject subject = SecurityUtils.getSubject();
        if (subject != null) {
            subject.logout();
        }
    }

    public CaptchaVo vCode() {
        String uuid = IdUtil.simpleUUID();
        LineCaptcha captcha = CaptchaUtil.createLineCaptcha((int)130, (int)48, (CodeGenerator)new RandomNumberGenerator("0123456789", 4), (int)9);
        captcha.setFont(new Font("SansSerif", 1, 43));
        String code = captcha.getCode();
        RedisUtils.setCacheObject((String)RedisKey.getVCodeKey((String)uuid), (Object)code, (Duration)Duration.ofMinutes(Constant.Vcode.CODE_EXPIRE_TIME.intValue()));
        CaptchaVo captchaVo = new CaptchaVo();
        captchaVo.setUuid(uuid);
        captchaVo.setImg(captcha.getImageBase64Data());
        return captchaVo;
    }

    public void checkVcode(String key, String vcode) {
        Object vodeCache = RedisUtils.getCacheObject((String)RedisKey.getVCodeKey((String)key));
        if (Objects.isNull(vodeCache)) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        }
        if (!vcode.equalsIgnoreCase(vodeCache.toString())) {
            throw new ServiceException("\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e");
        }
    }

    public LoginVo loginByPassword(String username, String password) {
        Subject subject = SecurityUtils.getSubject();
        UsernamePasswordToken token = new UsernamePasswordToken(username, password);
        try {
            subject.login((AuthenticationToken)token);
            ShiroPrincipal principal = (ShiroPrincipal)subject.getPrincipal();
            Set<Integer> systemWideList = principal.getUser().getSystemWideList();
            if (CollUtil.isEmpty(systemWideList) || !systemWideList.contains(UserSystemWideEnum.RHO.getCode())) {
                throw new UnauthorizedException();
            }
            return this.returnLoginInitParam(principal);
        }
        catch (UnknownAccountException e) {
            throw new ServiceException("\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5\uff01");
        }
        catch (IncorrectCredentialsException e) {
            throw new ServiceException("\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5\uff01");
        }
        catch (LockedAccountException e) {
            throw new ServiceException("\u60a8\u8f93\u5165\u7684\u4fe1\u606f\u5df2\u8fde\u7eed\u9519\u8bef5\u6b21\uff0c\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a\uff0c\u8bf7\u7b49\u5f8530\u5206\u949f\u518d\u5c1d\u8bd5\u767b\u5f55\uff0c\u5982\u6709\u7591\u95ee\u53ef\u8054\u7cfb\u5ba2\u670d\uff1a0571-89978771/89978775\u3002");
        }
        catch (DisabledAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        catch (ExcessiveAttemptsException e) {
            throw new ServiceException("\u60a8\u8f93\u5165\u7684\u4fe1\u606f\u5df2\u8fde\u7eed\u9519\u8bef3\u6b21\uff0c\u82e5\u518d\u9519\u8bef2\u6b21\uff0c\u60a8\u7684\u8d26\u53f7\u5c06\u4f1a\u88ab\u9501\u5b9a30\u5206\u949f\uff0c\u5efa\u8bae\u60a8\u8054\u7cfb\u5ba2\u670d(0571-89978771/89978775)\u8fdb\u884c\u5bc6\u7801\u91cd\u7f6e");
        }
        catch (AuthenticationException e) {
            throw new ServiceException("\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u767b\u5f55\uff01");
        }
        catch (UnauthorizedException e) {
            throw new ServiceException("\u65e0\u6743\u9650\u8bbf\u95ee\uff01");
        }
        catch (Exception e) {
            throw new ServiceException("\u7cfb\u7edf\u51fa\u73b0\u70b9\u95ee\u9898\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
    }

    public LoginVo loginByCas(CasLoginBody token) {
        Subject subject = SecurityUtils.getSubject();
        try {
            subject.login((AuthenticationToken)token);
            ShiroPrincipal principal = (ShiroPrincipal)subject.getPrincipal();
            Set<Integer> systemWideList = principal.getUser().getSystemWideList();
            if (CollUtil.isEmpty(systemWideList) || !systemWideList.contains(UserSystemWideEnum.RHO.getCode())) {
                throw new UnauthorizedException();
            }
            return this.returnLoginInitParam(principal);
        }
        catch (UnknownAccountException e) {
            throw new ServiceException("\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5\uff01");
        }
        catch (DisabledAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        catch (AuthenticationException e) {
            throw new ServiceException("\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u767b\u5f55\uff01");
        }
        catch (UnauthorizedException e) {
            throw new ServiceException("\u65e0\u6743\u9650\u8bbf\u95ee\uff01");
        }
    }

    public LoginVo loginByDD(DDLoginBody token) {
        Subject subject = SecurityUtils.getSubject();
        try {
            subject.login((AuthenticationToken)token);
            ShiroPrincipal principal = (ShiroPrincipal)subject.getPrincipal();
            Set<Integer> systemWideList = principal.getUser().getSystemWideList();
            if (CollUtil.isEmpty(systemWideList) || !systemWideList.contains(UserSystemWideEnum.RHO.getCode())) {
                throw new UnauthorizedException();
            }
            return this.returnLoginInitParam(principal);
        }
        catch (UnknownAccountException e) {
            throw new ServiceException("\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef, \u8bf7\u91cd\u8bd5\uff01");
        }
        catch (DisabledAccountException e) {
            throw new ServiceException("\u8d26\u53f7\u88ab\u7981\u7528\uff01");
        }
        catch (AuthenticationException e) {
            throw new ServiceException("\u8ba4\u8bc1\u5931\u8d25\uff0c\u8bf7\u5c1d\u8bd5\u91cd\u65b0\u767b\u5f55\uff01");
        }
        catch (UnauthorizedException e) {
            throw new ServiceException("\u65e0\u6743\u9650\u8bbf\u95ee\uff01");
        }
    }

    private LoginVo returnLoginInitParam(ShiroPrincipal principal) {
        Long userId = principal.getUserId();
        String username = principal.getUser().getUsername();
        String fullName = principal.getUser().getFullName();
        Long oid = principal.getUser().getOid();
        Long areaId = principal.getUser().getAreaId();
        Integer isTest = principal.getUser().getIsTest();
        this.permissionsService.addRoleAndPerms(principal);
        Integer loginType = principal.getLoginType();
        if (!this.sysProperties.getLogin().isTwoFactorCheck()) {
            principal.getUser().setTwoFactorCheck((byte)0);
        }
        String token = JwtUtil.createToken((Long)userId, (String)username, (String)fullName, (Long)oid, (Long)oid, (Long)areaId, (Integer)isTest, (Integer)loginType, (String)this.sysProperties.getLogin().getSecret(), (Long)Constant.TOKEN_EXPIRE_TIME);
        RedisUtils.setCacheObject((String)RedisKey.getSuperviseLoginUserKey((Long)userId), (Object)principal, (Duration)Duration.ofMinutes(Constant.REDIS_PRINCIPAL_TIME));
        RedisUtils.setCacheObject((String)RedisKey.getSuperviseLoginTokenKey((Long)userId), (Object)token, (Duration)Duration.ofMinutes(Constant.REDIS_TOKEN_EXPIRE_TIME));
        return new LoginVo(token, username, principal.getUser().getOrgName(), SensitiveUtil.encryptPhone((String)principal.getUser().getTel()), principal.getCheckVcode());
    }

    public ShiroPrincipal getLoginUser(Long userId) {
        if (userId == null) {
            return null;
        }
        String loginUserKey = RedisKey.getSuperviseLoginUserKey((Long)userId);
        ShiroPrincipal principal = (ShiroPrincipal)RedisUtils.getCacheObject((String)loginUserKey);
        if (principal == null) {
            principal = new ShiroPrincipal();
            OrganizationUser user = this.organizationUserService.getUserInfoById(userId);
            if (user == null) {
                throw new UnknownAccountException();
            }
            if (user.getIsForbidden() == Constant.TRUE) {
                throw new DisabledAccountException();
            }
            principal.setUser(this.toggleLoginUser(user));
            this.permissionsService.addRoleAndPerms(principal);
            principal.getUser().setTwoFactorCheck((byte)0);
            RedisUtils.setCacheObject((String)loginUserKey, (Object)principal, (Duration)Duration.ofMinutes(Constant.REDIS_PRINCIPAL_TIME));
            return principal;
        }
        return principal;
    }

    public LoginOrganizationUser toggleLoginUser(OrganizationUser user) {
        Organization org = this.organizationService.getOrgById(user.getOid());
        SysAreaV3OneVo area = this.sysAreaProvideService.getAreaByIdV3(org.getAreaId());
        if (area.getProvinceId() != 330000000000L) {
            throw new ServiceException("\u65e0\u6743\u9650\u8bbf\u95ee\uff01");
        }
        LoginOrganizationUser result = new LoginOrganizationUser();
        result.setId(user.getId()).setOid(user.getOid()).setOrgName(org.getName()).setUsername(user.getUsername()).setFullName(user.getFullName()).setTel(user.getTel()).setIsManger(user.getIsManger()).setIsTest(user.getIsTest()).setDepartment(user.getDepartment()).setPost(user.getPost()).setIsForbidden(user.getIsForbidden()).setIsDefaultPwd(user.getIsDefaultPwd()).setAccountId(user.getAccountId()).setTwoFactorCheck(area.getLevel() <= 1 ? (byte)0 : user.getTwoFactorCheck()).setSystemWideList(user.getSystemWideList()).setRoleList(this.sysRoleV3Service.selectRoleListByUserId(user.getId())).setSysArea(area).setAreaId(area.getId()).setAreaLevel(area.getLevel()).setIsHasBelong(this.companyProvider.isHasBelongTypeComByAreaId(org.getAreaId()));
        return result;
    }

    public LoginService(SysProperties sysProperties, PermissionsService permissionsService) {
        this.sysProperties = sysProperties;
        this.permissionsService = permissionsService;
    }
}

