/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.bootstrap.security.realms;

import cn.smarthse.common.util.Encodes;
import cn.smarthse.core.framework.Constant;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.ShiroPrincipal;
import cn.smarthse.rho.modules.supervise.bootstrap.security.service.LoginService;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class PasswordRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(PasswordRealm.class);
    @Autowired
    private LoginService loginService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationUserService organizationUserService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof UsernamePasswordToken;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        UsernamePasswordToken token = (UsernamePasswordToken)authenticationToken;
        OrganizationUser user = this.organizationUserService.getUserByuserame(token.getUsername());
        if (user == null) {
            throw new UnknownAccountException();
        }
        if (user.getIsForbidden() == Constant.TRUE) {
            throw new DisabledAccountException();
        }
        try {
            ((UsernamePasswordToken)authenticationToken).setPassword(String.valueOf(token.getPassword()).toCharArray());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String credentials = user.getPassword();
        String realmName = super.getName();
        ByteSource credentialsSalt = ByteSource.Util.bytes((byte[])Encodes.hexDecode((String)user.getSalt()));
        return new SimpleAuthenticationInfo((Object)new ShiroPrincipal(this.loginService.toggleLoginUser(user)), (Object)credentials, credentialsSalt, realmName);
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }
}

