/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.bootstrap.security.realms;

import cn.smarthse.core.framework.Constant;
import cn.smarthse.core.framework.constant.LoginTypeConstants;
import cn.smarthse.modules.health.supervise.entity.basic.OrganizationUser;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.ShiroPrincipal;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.param.CasLoginBody;
import cn.smarthse.rho.modules.supervise.bootstrap.security.service.LoginService;
import org.apache.dubbo.config.annotation.DubboReference;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.DisabledAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CasRealm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(CasRealm.class);
    @Autowired
    private LoginService loginService;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationUserService organizationUserService;

    public boolean supports(AuthenticationToken token) {
        return token instanceof CasLoginBody;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        CasLoginBody token = (CasLoginBody)authenticationToken;
        OrganizationUser user = this.organizationUserService.getUserByuserame(token.getUsername());
        if (user == null) {
            throw new UnknownAccountException();
        }
        if (user.getIsForbidden() == Constant.TRUE) {
            throw new DisabledAccountException();
        }
        user.setTwoFactorCheck(Byte.valueOf((byte)(token.getCheckVcode() != 1 ? 1 : 0)));
        return new SimpleAuthenticationInfo((Object)new ShiroPrincipal(this.loginService.toggleLoginUser(user), LoginTypeConstants.LOGIN_CAS, token.getExtraData()), token.getCredentials(), super.getName());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        return null;
    }
}

