/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.bootstrap.security.model;

import cn.smarthse.core.framework.constant.LoginTypeConstants;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.vo.LoginOrganizationUser;
import cn.smarthse.rho.modules.supervise.bootstrap.security.utils.ShiroUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@ApiModel
public class ShiroPrincipal
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="\u7528\u6237\u4fe1\u606f")
    private LoginOrganizationUser user;
    @ApiModelProperty(value="\u89d2\u8272\u5217\u8868")
    private Set<String> roleSet = new HashSet<String>();
    @ApiModelProperty(value="\u6743\u9650\u5217\u8868")
    private Set<String> permissionsSet = new HashSet<String>();
    private Integer loginType = LoginTypeConstants.LOGIN_USERPASSWORDCAPTCHA;
    @ApiModelProperty(value="\u6269\u5c55\u4fe1\u606f")
    public Map<String, Object> extraData;

    public ShiroPrincipal(LoginOrganizationUser user) {
        this.user = user;
    }

    public ShiroPrincipal(LoginOrganizationUser user, Integer loginType, Map<String, Object> extraData) {
        this.user = user;
        this.loginType = loginType;
        this.extraData = extraData;
    }

    @JsonIgnore
    public int getCheckVcode() {
        return ShiroUtil.getCheckVcode(this.user);
    }

    @JsonIgnore
    public Long getUserId() {
        return this.user.getId();
    }

    public LoginOrganizationUser getUser() {
        return this.user;
    }

    public Set<String> getRoleSet() {
        return this.roleSet;
    }

    public Set<String> getPermissionsSet() {
        return this.permissionsSet;
    }

    public Integer getLoginType() {
        return this.loginType;
    }

    public Map<String, Object> getExtraData() {
        return this.extraData;
    }

    public void setUser(LoginOrganizationUser user) {
        this.user = user;
    }

    public void setRoleSet(Set<String> roleSet) {
        this.roleSet = roleSet;
    }

    public void setPermissionsSet(Set<String> permissionsSet) {
        this.permissionsSet = permissionsSet;
    }

    public void setLoginType(Integer loginType) {
        this.loginType = loginType;
    }

    public void setExtraData(Map<String, Object> extraData) {
        this.extraData = extraData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShiroPrincipal)) {
            return false;
        }
        ShiroPrincipal other = (ShiroPrincipal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        LoginOrganizationUser this$user = this.getUser();
        LoginOrganizationUser other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        Set<String> this$roleSet = this.getRoleSet();
        Set<String> other$roleSet = other.getRoleSet();
        if (this$roleSet == null ? other$roleSet != null : !((Object)this$roleSet).equals(other$roleSet)) {
            return false;
        }
        Set<String> this$permissionsSet = this.getPermissionsSet();
        Set<String> other$permissionsSet = other.getPermissionsSet();
        if (this$permissionsSet == null ? other$permissionsSet != null : !((Object)this$permissionsSet).equals(other$permissionsSet)) {
            return false;
        }
        Integer this$loginType = this.getLoginType();
        Integer other$loginType = other.getLoginType();
        if (this$loginType == null ? other$loginType != null : !((Object)this$loginType).equals(other$loginType)) {
            return false;
        }
        Map<String, Object> this$extraData = this.getExtraData();
        Map<String, Object> other$extraData = other.getExtraData();
        return !(this$extraData == null ? other$extraData != null : !((Object)this$extraData).equals(other$extraData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShiroPrincipal;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LoginOrganizationUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        Set<String> $roleSet = this.getRoleSet();
        result = result * 59 + ($roleSet == null ? 43 : ((Object)$roleSet).hashCode());
        Set<String> $permissionsSet = this.getPermissionsSet();
        result = result * 59 + ($permissionsSet == null ? 43 : ((Object)$permissionsSet).hashCode());
        Integer $loginType = this.getLoginType();
        result = result * 59 + ($loginType == null ? 43 : ((Object)$loginType).hashCode());
        Map<String, Object> $extraData = this.getExtraData();
        result = result * 59 + ($extraData == null ? 43 : ((Object)$extraData).hashCode());
        return result;
    }

    public String toString() {
        return "ShiroPrincipal(user=" + this.getUser() + ", roleSet=" + this.getRoleSet() + ", permissionsSet=" + this.getPermissionsSet() + ", loginType=" + this.getLoginType() + ", extraData=" + this.getExtraData() + ")";
    }

    public ShiroPrincipal() {
    }
}

