/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.bootstrap.aop;

import cn.smarthse.core.framework.model.PageParam;
import cn.smarthse.core.framework.utils.login.JwtUtil;
import cn.smarthse.modules.datacentre.enums.CompanyBelongTypeEnum;
import cn.smarthse.rho.modules.sys.provider.sys.ISysAreaProvider;
import javax.servlet.http.HttpServletRequest;
import org.apache.dubbo.config.annotation.DubboReference;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
@Order(value=3)
public class ParamAopAspect {
    private static final Logger log = LoggerFactory.getLogger(ParamAopAspect.class);
    @DubboReference
    private ISysAreaProvider sysAreaProvider;

    @Pointcut(value="execution(public * cn.smarthse..*.controller..*.*(..))")
    public void pointCut() {
    }

    @Before(value="pointCut()")
    public void beforeLog(JoinPoint point) {
        this.initParam(point.getArgs(), ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest());
    }

    private void initParam(Object[] args, HttpServletRequest request) {
        if (args == null) {
            return;
        }
        for (Object arg : args) {
            if (!(arg instanceof PageParam)) continue;
            Long userAreaId = ((PageParam)arg).getLoginAreaId();
            Integer userAreaLevel = ((PageParam)arg).getLoginAreaLevel();
            Long areaId = ((PageParam)arg).getAreaId();
            if (areaId == null || !this.sysAreaProvider.hasPermission(areaId, JwtUtil.getAreaId())) {
                ((PageParam)arg).setAreaId(userAreaId);
                ((PageParam)arg).setLevel(userAreaLevel);
                this.setBelongType((PageParam)arg, userAreaLevel);
                continue;
            }
            Integer level = this.sysAreaProvider.getLevel(areaId);
            ((PageParam)arg).setLevel(level);
            this.setBelongType((PageParam)arg, level);
        }
    }

    private void setBelongType(PageParam arg, Integer userAreaLevel) {
        if (userAreaLevel == 0) {
            arg.setBelongType(Integer.valueOf(3));
        } else if (userAreaLevel == 1) {
            arg.setBelongType(CompanyBelongTypeEnum.SHENG.getValue());
        } else if (userAreaLevel == 2) {
            arg.setBelongType(CompanyBelongTypeEnum.SHI.getValue());
        } else {
            arg.setOnlyThisLevel(Integer.valueOf(1));
            arg.setBelongType(CompanyBelongTypeEnum.NO.getValue());
        }
    }
}

