/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.supervise.bootstrap.aop;

import cn.hutool.extra.servlet.ServletUtil;
import cn.smarthse.common.core.utils.SpringUtils;
import cn.smarthse.core.framework.annotation.SysExportLog;
import cn.smarthse.core.framework.utils.ServletUtils;
import cn.smarthse.rho.modules.supervise.bootstrap.security.model.vo.LoginOrganizationUser;
import cn.smarthse.rho.modules.supervise.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.sys.entity.sys.SysExportOperLog;
import cn.smarthse.rho.modules.sys.model.sys.event.ExportOperLogEvent;
import java.time.LocalDateTime;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class ExportLogAspect {
    private static final Logger log = LoggerFactory.getLogger(ExportLogAspect.class);

    @AfterReturning(pointcut="@annotation(exportLog)", returning="jsonResult")
    public void doAfterReturning(JoinPoint joinPoint, SysExportLog exportLog, Object jsonResult) {
        this.handleLog(joinPoint, exportLog, jsonResult);
    }

    @AfterThrowing(value="@annotation(exportLog)", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, SysExportLog exportLog, Exception e) {
        log.error("\u5bfc\u51fa\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38\uff1a", (Throwable)e);
    }

    private void handleLog(JoinPoint joinPoint, SysExportLog exportLog, Object jsonResult) {
        try {
            SysExportOperLog operLog = new SysExportOperLog();
            operLog.setBusinessType(exportLog.businessType().getCode());
            LoginOrganizationUser currentUser = ShiroUtil.getUser();
            if (currentUser != null) {
                operLog.setOperatorId(currentUser.getId());
                operLog.setOperatorName(currentUser.getFullName());
                operLog.setUsername(currentUser.getUsername());
            }
            operLog.setIp(ServletUtil.getClientIP((HttpServletRequest)ServletUtils.getRequest(), (String[])new String[0]));
            operLog.setUri(StringUtils.substring((String)ServletUtils.getRequest().getRequestURI(), (int)0, (int)255));
            operLog.setCreateDate(LocalDateTime.now());
            SpringUtils.context().publishEvent((ApplicationEvent)new ExportOperLogEvent((Object)this, operLog));
        }
        catch (Exception e) {
            log.error("\u5bfc\u51fa\u65e5\u5fd7\u8bb0\u5f55\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }
}

