/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.rw.sync;

import cn.smarthse.rho.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.rho.core.framework.utils.OkHttpUtils;
import cn.smarthse.rho.modules.rw.service.IXPositionDeviceDataService;
import cn.smarthse.rho.modules.rw.service.IXPositionGatewayInfoService;
import cn.smarthse.rho.modules.sys.entity.x.XPositionDeviceData;
import cn.smarthse.rho.modules.sys.entity.x.XPositionGatewayInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SyncDataService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SyncDataService.class);
    private static final long AccessTokenExpireTime = 5400L;
    @Autowired
    private SysProperties systemProperties;
    @Autowired
    private IXPositionDeviceDataService positionDeviceDataService;
    @Autowired
    private IXPositionGatewayInfoService positionGatewayInfoService;

    public void syncPositionData() {
        try {
            String resultString = OkHttpUtils.builder().url(this.systemProperties.getRwLinkIf3().getSyncPositionDataUrl()).addHeader("Content-Type", "application/json;").get().sync();
            if (StringUtil.isNotEmpty((String)resultString)) {
                if (resultString.isEmpty()) {
                    log.info("\u83b7\u53d6\u9ad8\u7cbe\u5ea6\u84dd\u7259\u5b9a\u4f4d\u7f51\u5173\u6807\u7b7e\u7ec8\u7aef\u5b9e\u65f6\u5b9a\u4f4d\u6570\u636e\u5f02\u5e38\uff1a\u7a7a\u7684json\u4e32");
                    return;
                }
                ObjectMapper objectMapper = new ObjectMapper();
                Map map = (Map)objectMapper.readValue(resultString, (JavaType)TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Map.class));
                if (!map.isEmpty()) {
                    ArrayList<XPositionDeviceData> datas = new ArrayList<XPositionDeviceData>();
                    for (Map.Entry entry : map.entrySet()) {
                        String key = (String)entry.getKey();
                        Map value = (Map)entry.getValue();
                        String x = String.valueOf(value.get("x"));
                        String y = String.valueOf(value.get("y"));
                        String z = String.valueOf(value.get("z"));
                        String mapId = (String)value.get("mapId");
                        String lastGateway = (String)value.get("lastGateway");
                        Long updatedAt = (Long)value.get("updatedAt");
                        XPositionDeviceData data2 = new XPositionDeviceData();
                        data2.setMac(key);
                        data2.setX(x);
                        data2.setY(y);
                        data2.setZ(z);
                        data2.setMapId(mapId);
                        data2.setLastGateway(lastGateway);
                        data2.setUpdatedAt(updatedAt);
                        data2.setUpdatedAtime(new Date(updatedAt));
                        datas.add(data2);
                    }
                    List<String> gatewayMacs = datas.stream().map(XPositionDeviceData::getLastGateway).collect(Collectors.toList());
                    List<XPositionGatewayInfo> existgatewayDataList = this.positionGatewayInfoService.getByMacs(gatewayMacs);
                    datas.forEach(data -> existgatewayDataList.stream().filter(e -> e.getMac().equals(data.getLastGateway())).findFirst().ifPresent(existData -> {
                        data.setCid(existData.getCid());
                        data.setGatewayId(existData.getId());
                    }));
                    this.positionDeviceDataService.saveBatch(datas);
                } else {
                    log.info("\u83b7\u53d6\u9ad8\u7cbe\u5ea6\u84dd\u7259\u5b9a\u4f4d\u7f51\u5173\u6807\u7b7e\u7ec8\u7aef\u5b9e\u65f6\u5b9a\u4f4d\u6570\u636e\u5f02\u5e38...");
                }
            }
        }
        catch (JsonProcessingException e) {
            log.info("\u5b9a\u4f4d\u7f51\u5173\u6807\u7b7e\u7ec8\u7aef\u5b9e\u65f6\u5b9a\u4f4d\u6570\u636ejson\u8f6c\u6362\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }

    public void syncPositionGatewayData() {
        try {
            String resultString = OkHttpUtils.builder().url(this.systemProperties.getRwLinkIf3().getSyncGatewayDataUrl()).addHeader("Content-Type", "application/json;").get().sync();
            if (StringUtil.isNotEmpty((String)resultString)) {
                ObjectMapper objectMapper = new ObjectMapper();
                Map map = (Map)objectMapper.readValue(resultString, (JavaType)TypeFactory.defaultInstance().constructMapType(Map.class, String.class, Map.class));
                if (!map.isEmpty()) {
                    ArrayList<XPositionGatewayInfo> datas = new ArrayList<XPositionGatewayInfo>();
                    for (Map.Entry entry : map.entrySet()) {
                        Map value = (Map)entry.getValue();
                        String mac = String.valueOf(value.get("mac"));
                        long updatedAt = Long.parseLong(String.valueOf(value.get("updatedAt")));
                        String online = String.valueOf(value.get("online"));
                        Map info = (Map)value.get("info");
                        String x = String.valueOf(info.get("x"));
                        String y = String.valueOf(info.get("y"));
                        String z = String.valueOf(info.get("z"));
                        String mapId = (String)info.get("mapId");
                        String name = (String)info.get("name");
                        XPositionGatewayInfo data = new XPositionGatewayInfo();
                        data.setMac(mac.replace(":", ""));
                        data.setN(name);
                        data.setPx(x);
                        data.setPy(y);
                        data.setPz(z);
                        data.setMi(mapId);
                        data.setUpdateDate(new Date(updatedAt));
                        data.setOnline(Integer.valueOf(online.equals("true") ? 1 : 0));
                        datas.add(data);
                    }
                    this.positionGatewayInfoService.saveOrUpdateByMac(datas);
                } else {
                    log.info("\u83b7\u53d6\u5b9a\u4f4d\u7f51\u5173\u57fa\u7ad9\u57fa\u7840\u6570\u636e\u5f02\u5e38...");
                }
            }
        }
        catch (Exception e) {
            log.info("\u5b9a\u4f4d\u7f51\u5173\u57fa\u7ad9\u57fa\u7840\u6570\u636ejson\u8f6c\u6362\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }
}

