/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.rw.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.smarthse.rho.modules.rw.dao.XPositionGatewayInfoMapper;
import cn.smarthse.rho.modules.rw.service.IConvertDeviceDataService;
import cn.smarthse.rho.modules.rw.service.IXPositionDeviceDataService;
import cn.smarthse.rho.modules.rw.service.IXpositionDeviceDataStatisticDayService;
import cn.smarthse.rho.modules.rw.service.IXpositionDeviceDataStatisticService;
import cn.smarthse.rho.modules.sys.entity.x.XPositionDeviceData;
import cn.smarthse.rho.modules.sys.entity.x.XPositionDeviceDataStatistics;
import cn.smarthse.rho.modules.sys.entity.x.XPositionDeviceDataStatisticsDay;
import cn.smarthse.rho.modules.sys.entity.x.XPositionGatewayInfo;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConvertDeviceDataServiceImpl
implements IConvertDeviceDataService {
    private static final Logger log = LoggerFactory.getLogger(ConvertDeviceDataServiceImpl.class);
    @Autowired
    private IXPositionDeviceDataService xPDDService;
    @Autowired
    private IXpositionDeviceDataStatisticService xPDDStaService;
    @Autowired
    private IXpositionDeviceDataStatisticDayService xPDDStaDayService;
    @Autowired
    private XPositionGatewayInfoMapper xGatewayMapper;
    private Map<String, XPositionDeviceData> basePointMap = new HashMap<String, XPositionDeviceData>();
    private Long gateWayId = 1846390680218247169L;

    @Override
    public void convertData() {
        LocalDateTime endTime;
        LocalDateTime beginTime;
        Long cid = ((XPositionGatewayInfo)this.xGatewayMapper.selectById(this.gateWayId)).getCid();
        LocalDateTime now = LocalDateTime.now();
        int minute = now.getMinute();
        if (minute < 20) {
            beginTime = now.withMinute(40).withSecond(0).minusHours(1L);
            endTime = now.withMinute(59).withSecond(59).minusHours(1L);
        } else if (minute < 40) {
            beginTime = now.withMinute(0).withSecond(0);
            endTime = now.withMinute(19).withSecond(59);
        } else {
            beginTime = now.withMinute(20).withSecond(0);
            endTime = now.withMinute(39).withSecond(59);
        }
        beginTime = beginTime.withNano(0);
        endTime = endTime.withNano(0);
        List<XPositionDeviceData> list = this.xPDDService.getListByTimeSlot(beginTime, endTime, cid, this.gateWayId);
        Map macMap = list.stream().collect(Collectors.groupingBy(XPositionDeviceData::getMac, LinkedHashMap::new, Collectors.toList()));
        if (CollectionUtil.isEmpty((Map)macMap)) {
            System.out.println("\u539f\u59cb\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u63d2\u5165\u6570\u636e");
            return;
        }
        boolean isAbnormal = false;
        double threshold = 0.5;
        isAbnormal = this.checkAbnormal(beginTime, endTime, cid, this.gateWayId, macMap, this.basePointMap, threshold);
        XPositionDeviceDataStatistics statistics = new XPositionDeviceDataStatistics();
        this.setBasicFields(list.get(0), statistics);
        statistics.setHourSlotNumber(Integer.valueOf(beginTime.getHour() % 24 + 1));
        statistics.setSlotStartTime(beginTime);
        statistics.setSlotEndTime(endTime);
        statistics.setStatus(isAbnormal ? Byte.valueOf("1") : Byte.valueOf("0"));
        this.xPDDStaService.insertData(statistics);
    }

    public boolean checkAbnormal(LocalDateTime beginTime, LocalDateTime endTime, Long cid, Long gateWayId, Map<String, List<XPositionDeviceData>> macMap, Map<String, XPositionDeviceData> basePointMap, double threshold) {
        boolean isAllBasePointsUnchanged = true;
        for (Map.Entry<String, List<XPositionDeviceData>> entry : macMap.entrySet()) {
            String mac = entry.getKey();
            List<XPositionDeviceData> macList = entry.getValue();
            if (macList.isEmpty()) continue;
            if (ObjectUtil.isEmpty((Object)basePointMap.get(mac))) {
                basePointMap.put(mac, macList.get(0));
            }
            XPositionDeviceData basePoint = basePointMap.get(mac);
            boolean baseUpdated = false;
            for (int i = 1; i < macList.size(); ++i) {
                XPositionDeviceData currentPoint = macList.get(i);
                double distance = this.calculateDistance(basePoint, currentPoint);
                if (!(distance > threshold)) continue;
                basePoint = currentPoint;
                baseUpdated = true;
                basePointMap.put(mac, basePoint);
            }
            if (baseUpdated) {
                isAllBasePointsUnchanged = false;
                continue;
            }
            this.xPDDService.updateStatus(beginTime, endTime, cid, gateWayId, mac);
        }
        return isAllBasePointsUnchanged;
    }

    private void setBasicFields(XPositionDeviceData xPositionDeviceData, XPositionDeviceDataStatistics statistics) {
        Date updatedAtime = xPositionDeviceData.getUpdatedAtime();
        LocalDate detectionDate = updatedAtime.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        statistics.setCid(xPositionDeviceData.getCid());
        statistics.setGatewayId(xPositionDeviceData.getGatewayId());
        statistics.setMapId(xPositionDeviceData.getMapId());
        statistics.setDetectionDate(detectionDate);
        statistics.setCreatedAt(LocalDateTime.now());
    }

    private double calculateDistance(XPositionDeviceData p1, XPositionDeviceData p2) {
        double xDiff = Double.parseDouble(p1.getX()) - Double.parseDouble(p2.getX());
        double yDiff = Double.parseDouble(p1.getY()) - Double.parseDouble(p2.getY());
        return Math.sqrt(xDiff * xDiff + yDiff * yDiff);
    }

    @Override
    public void convertDataDayLy() {
        XPositionGatewayInfo gatewayInfo = (XPositionGatewayInfo)this.xGatewayMapper.selectById(this.gateWayId);
        Long cid = gatewayInfo.getCid();
        LocalDate yesterday = LocalDate.now().minusDays(1L);
        Integer beginNum = gatewayInfo.getWorkBegin() + 1;
        Integer endNum = gatewayInfo.getWorkEnd();
        Integer exceptionNum = this.xPDDStaService.selectExceptionNum(cid, this.gateWayId, yesterday, beginNum, endNum);
        Integer checkNum = 3 * (gatewayInfo.getWorkEnd() - gatewayInfo.getWorkBegin());
        XPositionDeviceDataStatisticsDay dataStatisticsDay = new XPositionDeviceDataStatisticsDay();
        dataStatisticsDay.setCid(cid);
        dataStatisticsDay.setGatewayId(this.gateWayId);
        dataStatisticsDay.setDetectionDate(yesterday);
        dataStatisticsDay.setExceptionNum(exceptionNum);
        dataStatisticsDay.setCheckNum(checkNum);
        dataStatisticsDay.setStatus(exceptionNum > 0 ? Byte.valueOf("1") : Byte.valueOf("0"));
        dataStatisticsDay.setCreatedAt(LocalDateTime.now());
        this.xPDDStaDayService.insertData(dataStatisticsDay);
    }
}

