/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.rw.bootstrap;

import cn.smarthse.core.framework.bean.OssClientBean;
import cn.smarthse.core.framework.bootstrap.BaseConfiguration;
import cn.smarthse.core.framework.bootstrap.properties.OssClientProperties;
import cn.smarthse.core.framework.bootstrap.properties.SysProperties;
import cn.smarthse.core.framework.utils.SpringContextHolder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.scheduling.annotation.EnableScheduling;

@Configuration
@EnableAsync
@EnableScheduling
@EnableConfigurationProperties(value={OssClientProperties.class, SysProperties.class})
@ComponentScan(value={"cn.smarthse.common.json", "cn.smarthse.common.redis", "cn.smarthse.common.web"})
public class ContentConfiguration
extends BaseConfiguration {
    private final OssClientProperties ossClientProperties;

    @Bean(name={"ossclient"})
    public OssClientBean getOssClientBean() {
        this.logger.info("\u914d\u7f6e OssClientBean {}", (Object)this.ossClientProperties.getOss_bucketname());
        OssClientBean ossClientBean = new OssClientBean();
        ossClientBean.setLocal(this.ossClientProperties.getOss_local());
        ossClientBean.setDomain(this.ossClientProperties.getDomain());
        ossClientBean.setEndpoint(this.ossClientProperties.getOss_endpoint());
        ossClientBean.setAccessKeyId(this.ossClientProperties.getOss_accesskey());
        ossClientBean.setAccessKeySecret(this.ossClientProperties.getOss_accesssecret());
        ossClientBean.setBucketName(this.ossClientProperties.getOss_bucketname());
        ossClientBean.setAsynch(this.ossClientProperties.isOss_asynch());
        ossClientBean.setPublicread(this.ossClientProperties.isPublicread());
        ossClientBean.setExptime(this.ossClientProperties.getExptime());
        return ossClientBean;
    }

    @Bean
    public SpringContextHolder springContextHolder() {
        return new SpringContextHolder();
    }

    public ContentConfiguration(OssClientProperties ossClientProperties) {
        this.ossClientProperties = ossClientProperties;
    }
}

