/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.s;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysMenuV3Service;
import cn.smarthse.modules.health.supervise.service.sys.v3.ISysPermissionV3Service;
import cn.smarthse.modules.health.supervise.vo.sys.v3.menu.SysMenuV3Vo;
import cn.smarthse.rho.modules.company.dao.s.PermissionV3Mapper;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SysPermissionV3ServiceImpl
implements ISysPermissionV3Service {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SysPermissionV3ServiceImpl.class);
    @DubboReference(registry={"public_nacos"})
    private ISysMenuV3Service menuService;
    private final PermissionV3Mapper mapper;

    public Set<String> getRolePermission(Long userId) {
        if (Objects.isNull(userId)) {
            return CollUtil.newHashSet((Object[])new String[0]);
        }
        return this.mapper.getRolePermission(userId);
    }

    public Set<String> getMenuPermission(Integer systemWideMenu, Long userId) {
        if (Objects.isNull(systemWideMenu) || Objects.isNull(userId)) {
            return CollUtil.newHashSet((Object[])new String[0]);
        }
        return this.mapper.getMenuPermission(systemWideMenu, userId);
    }

    public List<Tree<Long>> getRouters(Integer systemWideMenu, Long userId) {
        return this.menuService.buildMenuTreeSelect(this.getSysMenuByUserId(systemWideMenu, userId));
    }

    public List<SysMenuV3Vo> getSysMenuByUserId(Integer systemWideMenu, Long userId) {
        if (Objects.isNull(systemWideMenu) || Objects.isNull(userId)) {
            return CollUtil.newArrayList((Object[])new SysMenuV3Vo[0]);
        }
        return this.mapper.selectMCListByUserId(systemWideMenu, userId);
    }

    @Generated
    public SysPermissionV3ServiceImpl(PermissionV3Mapper mapper) {
        this.mapper = mapper;
    }
}

