/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.r;

import cn.hutool.core.date.DateUtil;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.Constant;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.dao.r.RRiskBasicSourceMapper;
import cn.smarthse.rho.modules.company.model.r.param.RiskAcceptRecordSubmitParam;
import cn.smarthse.rho.modules.company.model.r.param.RiskQueryParam;
import cn.smarthse.rho.modules.company.model.r.vo.RiskSourceHistoryVo;
import cn.smarthse.rho.modules.company.service.r.IRRiskAcceptanceRecordService;
import cn.smarthse.rho.modules.company.service.r.IRRiskBasicService;
import cn.smarthse.rho.modules.company.service.r.IRRiskBasicSourceService;
import cn.smarthse.rho.modules.sys.entity.c.CTrainingCert;
import cn.smarthse.rho.modules.sys.entity.r.RRiskAcceptanceRecord;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasic;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.risk.AcceptanceMaterialsTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.AcceptanceRecordStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.BasicRiskStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTimeSpecialTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskUnresolvedTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import cn.smarthse.rho.modules.sys.model.easyexcel.RiskBatchChooseImportDto;
import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class RRiskBasicSourceServiceImpl
extends ServiceImpl<RRiskBasicSourceMapper, RRiskBasicSource>
implements IRRiskBasicSourceService {
    @Autowired
    private IRRiskBasicService riskBasicService;
    @Autowired
    private IRRiskAcceptanceRecordService acceptanceRecordService;

    @Override
    @Transactional
    public void updateBatchByAcceptRecordSubmit(RiskAcceptRecordSubmitParam param) {
        LambdaQueryWrapper updateWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)updateWrapper.eq(RRiskBasicSource::getRiskId, (Object)param.getRiskId())).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).eq(RRiskBasicSource::getStatus, (Object)BasicRiskStatusEnum.UNRESOLVED.getValue())).in(RRiskBasicSource::getUnresolvedType, new Object[]{RiskUnresolvedTypeEnum.UN_RECTIFY.getValue(), RiskUnresolvedTypeEnum.RETURNED.getValue()})).in(RRiskBasicSource::getId, param.getRiskSourceIds());
        List riskBasicSourceList = ((RRiskBasicSourceMapper)this.baseMapper).selectList((Wrapper)updateWrapper);
        if (CollectionUtils.isEmpty((Collection)riskBasicSourceList)) {
            return;
        }
        riskBasicSourceList.forEach(item -> {
            item.setReformDirectorName(param.getReformDirectorName());
            item.setStatus(BasicRiskStatusEnum.UNRESOLVED.getValue());
            item.setUnresolvedType(RiskUnresolvedTypeEnum.UN_ACCEPT.getValue());
        });
        this.updateBatchById(riskBasicSourceList);
    }

    @Override
    public LayuiGridData<RiskSourceHistoryVo> listSourceHistory(RiskQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        return new LayuiGridData((Page)((RRiskBasicSourceMapper)this.baseMapper).listSourceHistory(param), (LayuiGridParam)param);
    }

    @Override
    public List<RRiskBasicSource> getSelfCheckRisk(Integer type, Long cid) {
        return ((RRiskBasicSourceMapper)this.baseMapper).getSelfCheckRisk(type, cid);
    }

    @Override
    public List<RRiskBasicSource> getRiskBasicSourceListByIds(List<Long> riskSourceIdList, Long cid) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).eq(RRiskBasicSource::getCid, (Object)cid)).in(RRiskBasicSource::getId, riskSourceIdList);
        return ((RRiskBasicSourceMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
    }

    @Override
    public void checkRiskBatchChooseImportData(List<RiskBatchChooseImportDto> importList, Integer riskType, Integer healthRiskPostType) {
        if (CollectionUtils.isEmpty(importList)) {
            throw new ServiceException("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        ArrayList<RiskBatchChooseImportDto> errorInfoList = new ArrayList<RiskBatchChooseImportDto>();
        List<Long> riskSourceIdList = importList.stream().map(RiskBatchChooseImportDto::getSourceId).toList();
        List<RRiskBasicSource> riskBasicSourceListOrigin = this.getRiskBasicSourceListByIds(riskSourceIdList, ShiroUtil.getLoginUserCid());
        if (CollectionUtils.isEmpty(riskBasicSourceListOrigin)) {
            throw new ServiceException("\u7cfb\u7edf\u672a\u627e\u5230\u98ce\u9669\u6570\u636e\uff01\u8bf7\u68c0\u67e5");
        }
        if (riskType.equals(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue()) && riskBasicSourceListOrigin.stream().map(RRiskBasicSource::getPostType).distinct().count() > 1L) {
            throw new ServiceException("\u540c\u4e00\u6279\u5bfc\u5165\u7684\u4f53\u68c0\u98ce\u9669\u53ea\u80fd\u5305\u542b\u4e00\u79cd\u98ce\u9669\u7c7b\u578b\uff08\u5168\u90e8\u4e3a\u5c97\u524d\u6216\u8005\u5c97\u4e2d\u6216\u8005\u79bb\u5c97\uff09\uff01");
        }
        int rowIndex = 2;
        for (RiskBatchChooseImportDto importDto : importList) {
            StringBuilder sb = new StringBuilder();
            RRiskBasicSource riskBasicSourceOrigin = riskBasicSourceListOrigin.stream().filter(item -> item.getId().equals(importDto.getSourceId())).findFirst().orElse(null);
            if (riskBasicSourceOrigin == null) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u672a\u627e\u5230\u8be5\u7f16\u53f7\u7684\u98ce\u9669\u6570\u636e\uff01", rowIndex));
            } else {
                importDto.setRiskType(riskBasicSourceOrigin.getType());
                importDto.setSubBusinessId(riskBasicSourceOrigin.getSubBusinessId());
            }
            if (riskBasicSourceOrigin != null && !riskBasicSourceOrigin.getWarningStatus().equals(RiskWarningStatusEnum.RED.getValue()) && riskBasicSourceOrigin.getType().equals(RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8be5\u7f16\u53f7\u98ce\u9669\uff08\u4f53\u68c0\u5f02\u5e38-\u590d\u67e5\uff09\u53ea\u80fd\u5728\u201c\u7ea2\u8272\u9884\u8b66\u201d\u72b6\u6001\u624d\u53ef\u6574\u6539\u5316\u89e3\uff01", rowIndex));
            }
            if (riskBasicSourceOrigin != null && riskType.equals(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue()) && !riskBasicSourceOrigin.getPostType().equals(healthRiskPostType)) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8be5\u7f16\u53f7\u4f53\u68c0\u98ce\u9669\u7684\u5c97\u4f4d\u7c7b\u578b\u4e0e\u5f53\u524d\u98ce\u9669\u5217\u8868\u4e0d\u7b26\uff01", rowIndex));
            }
            if (!(riskBasicSourceOrigin == null || Objects.equals(riskBasicSourceOrigin.getStatus(), BasicRiskStatusEnum.UNRESOLVED.getValue()) || Objects.equals(riskBasicSourceOrigin.getUnresolvedType(), RiskUnresolvedTypeEnum.UN_RECTIFY.getValue()) || Objects.equals(riskBasicSourceOrigin.getUnresolvedType(), RiskUnresolvedTypeEnum.RETURNED.getValue()))) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8be5\u7f16\u53f7\u98ce\u9669\u5df2\u5904\u7406\u6216\u65e0\u9700\u5904\u7406\uff01", rowIndex));
            }
            if (riskBasicSourceOrigin != null && !riskBasicSourceOrigin.getTimeSpecialType().equals(RiskTimeSpecialTypeEnum.COMMON.getValue())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8be5\u7f16\u53f7\u98ce\u9669\u65e0\u6cd5\u901a\u8fc7\u4f50\u8bc1\u6750\u6599\u5316\u89e3\uff0c\u8bf7\u68c0\u67e5\uff01", rowIndex));
            }
            if (!sb.isEmpty()) {
                importDto.setRowIndex(Integer.valueOf(rowIndex));
                importDto.setHaveError(Boolean.valueOf(true));
                importDto.setErrorReason(sb.toString());
                errorInfoList.add(importDto);
            }
            ++rowIndex;
        }
        if (!errorInfoList.isEmpty()) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u6839\u636e\u9519\u8bef\u4fe1\u606f\u68c0\u67e5\u540e\u91cd\u65b0\u5bfc\u5165", (Object)JSON.toJSONString(errorInfoList));
        }
    }

    @Override
    @Transactional
    public void updateRiskByTrainingCertSubmit(CTrainingCert cert) {
        List<RRiskBasicSource> riskBasicSourceList = ((RRiskBasicSourceMapper)this.baseMapper).getRiskBasicSourceListByStaffBaseInfoId(cert.getCid(), cert.getStaffBaseInfoId(), RiskTypeEnum.TRAINING.getValue());
        if (CollectionUtils.isEmpty(riskBasicSourceList)) {
            return;
        }
        RRiskBasic riskBasic = (RRiskBasic)this.riskBasicService.getById(riskBasicSourceList.get(0).getRiskId());
        List<RRiskAcceptanceRecord> acceptRecordListBySourceIds = this.acceptanceRecordService.getAcceptRecordListBySourceIds(riskBasicSourceList.stream().map(RRiskBasicSource::getId).toList());
        Map<Long, RRiskAcceptanceRecord> acceptRecordMap = acceptRecordListBySourceIds.stream().collect(Collectors.toMap(RRiskAcceptanceRecord::getSourceId, item -> item));
        riskBasicSourceList.forEach(item -> {
            item.setStatus(BasicRiskStatusEnum.UNRESOLVED.getValue());
            item.setUnresolvedType(RiskUnresolvedTypeEnum.UN_ACCEPT.getValue());
            item.setUpdateBy(ShiroUtil.getJWTUserId());
            item.setUpdateDate(LocalDateTime.now());
            RRiskAcceptanceRecord acceptRecord = (RRiskAcceptanceRecord)acceptRecordMap.get(item.getId());
            if (StringUtils.isBlank((CharSequence)item.getReformDirectorName())) {
                if (acceptRecord != null && StringUtils.isNotBlank((CharSequence)acceptRecord.getReformDirectorName())) {
                    item.setReformDirectorName(acceptRecord.getReformDirectorName());
                } else {
                    item.setReformDirectorName(ShiroUtil.getLoginUserCompanyName());
                }
            }
        });
        this.updateBatchById(riskBasicSourceList);
        if (riskBasic != null) {
            riskBasic.setStatus(BasicRiskStatusEnum.UNRESOLVED.getValue());
            riskBasic.setUnresolvedType(RiskUnresolvedTypeEnum.UN_ACCEPT.getValue());
            riskBasic.setUpdateBy(ShiroUtil.getJWTUserId());
            riskBasic.setUpdateDate(LocalDateTime.now());
            this.riskBasicService.updateById(riskBasic);
        }
        acceptRecordListBySourceIds.forEach(item -> {
            item.setStatus(AcceptanceRecordStatusEnum.AUDIT.getValue());
            item.setMaterialsType(AcceptanceMaterialsTypeEnum.RADIATION_TRAIN.getValue());
            item.setSubmitTime(LocalDateTime.now());
            item.setUpdateBy(ShiroUtil.getJWTUserId());
            item.setUpdateDate(LocalDateTime.now());
            if (StringUtils.isBlank((CharSequence)item.getReformDirectorName())) {
                item.setReformDirectorName(ShiroUtil.getLoginUserCompanyName());
            }
            if (StringUtils.isBlank((CharSequence)item.getReformMeasure())) {
                item.setReformMeasure(DateUtil.today() + "\uff0c\u63d0\u4ea4\u4e86\u653e\u5c04\u9632\u62a4\u57f9\u8bad\u8bc1\u660e");
            }
        });
        this.acceptanceRecordService.updateBatchById(acceptRecordListBySourceIds);
    }

    @Override
    public void deleteByBaseIdAndCid(Long staffBaseInfoId, Long cid) {
        ((RRiskBasicSourceMapper)this.baseMapper).deleteByBaseIdAndCid(staffBaseInfoId, cid);
    }

    @Override
    public RRiskBasicSource getUnResolveSelfCheckRisk(Integer riskType, Long cid) {
        return ((RRiskBasicSourceMapper)this.baseMapper).getUnResolveSelfCheckRisk(riskType, cid);
    }
}

