/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.r;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.company.converter.RiskBatchChooseImportDtoConverter;
import cn.smarthse.rho.modules.company.dao.r.RRiskBasicMapper;
import cn.smarthse.rho.modules.company.model.r.param.RiskQueryParam;
import cn.smarthse.rho.modules.company.model.r.vo.RiskDetailListItemVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskDetailSourceVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskDetailStatisticDataVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskMenuStatisticsVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskResolutionListItemVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskResolutionStatisticsVo;
import cn.smarthse.rho.modules.company.service.r.IRRiskBasicService;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasic;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.model.e.vo.DeviceLocationStatisticVo;
import cn.smarthse.rho.modules.sys.model.e.vo.LocationDeviceStatisticVo;
import cn.smarthse.rho.modules.sys.provider.e.IEDeviceCommonProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class RRiskBasicServiceImpl
extends ServiceImpl<RRiskBasicMapper, RRiskBasic>
implements IRRiskBasicService {
    @Autowired
    private RiskBatchChooseImportDtoConverter riskBatchChooseImportDtoConverter;
    @DubboReference
    private ISysFileProvider sysFileProvider;
    @DubboReference
    private IEDeviceCommonProvider deviceCommonProvider;

    @Override
    public LayuiGridData<RiskResolutionListItemVo> getRiskListData(RiskQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        return new LayuiGridData((Page)((RRiskBasicMapper)this.baseMapper).getRiskListData(param), (LayuiGridParam)param);
    }

    @Override
    public RiskMenuStatisticsVo getRiskMenuStatisticsVo(Long loginUserCid) {
        RiskMenuStatisticsVo vo = ((RRiskBasicMapper)this.baseMapper).getRiskMenuStatisticsVo(loginUserCid);
        RiskMenuStatisticsVo vo2 = ((RRiskBasicMapper)this.baseMapper).getBaseInfoError(loginUserCid);
        RiskMenuStatisticsVo riskMenuStatisticsVo = vo = vo == null ? new RiskMenuStatisticsVo() : vo;
        if (vo2 != null) {
            vo.setBaseInfoError(vo2.getBaseInfoError());
            vo.setOrgError(vo2.getOrgError());
            vo.setRayStaffError(vo2.getRayStaffError());
            vo.setRoomError(vo2.getRoomError());
            vo.setDeviceError(vo2.getDeviceError());
            vo.setRayGroupError(vo2.getRayGroupError());
        }
        return vo == null ? vo2 : vo;
    }

    @Override
    public RiskResolutionStatisticsVo getRiskResolutionStatisticsData(RiskQueryParam param) {
        return ((RRiskBasicMapper)this.baseMapper).getRiskResolutionStatisticsData(param);
    }

    @Override
    public List<RiskDetailListItemVo> getRiskDetailListData(Long riskBasicId, Integer riskType, Long cid) {
        return ((RRiskBasicMapper)this.baseMapper).getRiskDetailListData(riskType, cid);
    }

    @Override
    public LayuiGridData<RiskDetailSourceVo> listSourceByRiskId(RiskQueryParam param) {
        if (param.getRiskId() == null) {
            return new LayuiGridData();
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<RiskDetailSourceVo> rst = ((RRiskBasicMapper)this.baseMapper).listSourceByRiskId(param);
        if (!CollectionUtils.isEmpty(rst)) {
            this.setReformFinishedFile(rst);
            this.setDeviceStatistic(rst, param);
            this.setDeviceLocationNames(rst, param);
        }
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    void setReformFinishedFile(List<RiskDetailSourceVo> rst) {
        rst.forEach(sourceVo -> sourceVo.setReformFinishedFileVos(this.sysFileProvider.getFileVoByIds(sourceVo.getReformFinishedFiles())));
    }

    void setDeviceStatistic(List<RiskDetailSourceVo> rst, RiskQueryParam param) {
        if (!param.getRiskType().equals(RiskTypeEnum.PLACE_TEST.getValue()) && !param.getRiskType().equals(RiskTypeEnum.EXCEPTION_PLACE_TEST.getValue())) {
            return;
        }
        List<Long> locationIds = rst.stream().map(RiskDetailSourceVo::getSubBusinessId).toList();
        List devicesNumByLocationIds = this.deviceCommonProvider.getLocationDevicesNumByLocationIds(locationIds, param.getCid());
        rst.forEach(sourceVo -> {
            LocationDeviceStatisticVo statisticVo;
            if (!CollectionUtils.isEmpty((Collection)devicesNumByLocationIds) && (statisticVo = (LocationDeviceStatisticVo)devicesNumByLocationIds.stream().filter(vo -> vo.getLocationId().equals(sourceVo.getSubBusinessId())).findFirst().orElse(null)) != null) {
                sourceVo.setDeviceNum(statisticVo.getLocationDeviceNum1());
                sourceVo.setLocationDeviceNum(statisticVo.getLocationDeviceNum());
                sourceVo.setIsUsedNonSealedSpecies(statisticVo.getLocationDeviceNum2() > 0);
            }
        });
    }

    void setDeviceLocationNames(List<RiskDetailSourceVo> rst, RiskQueryParam param) {
        if (!param.getRiskType().equals(RiskTypeEnum.PERFORMANCE_TEST.getValue()) && !param.getRiskType().equals(RiskTypeEnum.EXCEPTION_PERFORMANCE_TEST.getValue())) {
            return;
        }
        rst.forEach(sourceVo -> {
            DeviceLocationStatisticVo deviceLocation = this.deviceCommonProvider.getDevicesLocationByDeviceIds(sourceVo.getSubBusinessId(), sourceVo.getDeviceType(), param.getCid());
            if (deviceLocation != null && StringUtils.isNotEmpty((String)deviceLocation.getLocationName())) {
                sourceVo.setLocationName(deviceLocation.getLocationName());
            }
        });
    }

    @Override
    public RiskDetailStatisticDataVo getRiskStatisticData(RiskQueryParam param) {
        return ((RRiskBasicMapper)this.baseMapper).getRiskStatisticData(param);
    }

    @Override
    public List<?> getExportListSourceByRiskId(RiskQueryParam param) {
        param.setLimit(Integer.MAX_VALUE);
        param.setIsExportQuery(true);
        List data = this.listSourceByRiskId(param).getData();
        if (CollectionUtils.isEmpty((Collection)data)) {
            return Collections.emptyList();
        }
        if (param.getRiskType().equals(RiskTypeEnum.PERFORMANCE_TEST.getValue()) || param.getRiskType().equals(RiskTypeEnum.EXCEPTION_PERFORMANCE_TEST.getValue())) {
            return this.riskBatchChooseImportDtoConverter.vosToDto1s(data);
        }
        if (param.getRiskType().equals(RiskTypeEnum.PLACE_TEST.getValue()) || param.getRiskType().equals(RiskTypeEnum.EXCEPTION_PLACE_TEST.getValue())) {
            return this.riskBatchChooseImportDtoConverter.vosToDto2s(data);
        }
        if (param.getRiskType().equals(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue()) || param.getRiskType().equals(RiskTypeEnum.PHYSICAL_EXCEPTION_OCC.getValue()) || param.getRiskType().equals(RiskTypeEnum.PHYSICAL_EXCEPTION_CONTRAINDICATION.getValue()) || param.getRiskType().equals(RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue())) {
            return this.riskBatchChooseImportDtoConverter.vosToDto3s(data);
        }
        if (param.getRiskType().equals(RiskTypeEnum.DOSE_MONITORING.getValue()) || param.getRiskType().equals(RiskTypeEnum.DOSE_EXCEPTION_OVERDOSE.getValue())) {
            return this.riskBatchChooseImportDtoConverter.vosToDto4s(data);
        }
        if (param.getRiskType().equals(RiskTypeEnum.TRAINING.getValue())) {
            return this.riskBatchChooseImportDtoConverter.vosToDto5s(data);
        }
        return Collections.emptyList();
    }
}

