/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.r;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.modules.excel.BaseImportDto;
import cn.smarthse.rho.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.converter.RRiskAcceptanceRecordConverter;
import cn.smarthse.rho.modules.company.dao.r.RRiskAcceptanceRecordMapper;
import cn.smarthse.rho.modules.company.model.r.param.RiskAcceptRecordSubmitParam;
import cn.smarthse.rho.modules.company.service.r.IRRiskAcceptanceRecordService;
import cn.smarthse.rho.modules.company.service.r.IRRiskBasicService;
import cn.smarthse.rho.modules.company.service.r.IRRiskBasicSourceService;
import cn.smarthse.rho.modules.sys.entity.r.RRiskAcceptanceRecord;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasic;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.enums.risk.AcceptanceMaterialsTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.BasicRiskStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskAcceptanceStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskPostStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTimeSpecialTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskUnresolvedTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskWarningStatusEnum;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class RRiskAcceptanceRecordServiceImpl
extends ServiceImpl<RRiskAcceptanceRecordMapper, RRiskAcceptanceRecord>
implements IRRiskAcceptanceRecordService {
    @Autowired
    @Lazy
    private IRRiskBasicService riskBasicService;
    @Autowired
    @Lazy
    private IRRiskBasicSourceService riskBasicSourceService;
    @Autowired
    private RRiskAcceptanceRecordConverter converter;

    @Override
    public List<RRiskAcceptanceRecord> getAcceptRecordListBySourceIds(List<Long> riskBasicSourceIds) {
        if (CollectionUtils.isEmpty(riskBasicSourceIds)) {
            return null;
        }
        return ((RRiskAcceptanceRecordMapper)this.baseMapper).getAcceptRecordListBySourceIds(riskBasicSourceIds);
    }

    @Override
    public void rectificationDraftSave(RiskAcceptRecordSubmitParam param) {
        if (param.getId() == null) {
            throw new ServiceException("\u53c2\u6570\u7f3a\u5931[id]");
        }
        RRiskAcceptanceRecord record = this.converter.SubmitParam2entity(param);
        record.setReformDirectorName(param.getReformDirectorName());
        record.setReformMeasure(param.getReformMeasure());
        record.setUpdateBy(param.getLoginUserId());
        record.setUpdateDate(LocalDateTime.now());
        record.setStatus(RiskAcceptanceStatusEnum.DRAFT.getValue());
        record.setBusinessLastDate(param.getBusinessLastDate());
        record.setHealthLastType(param.getHealthLastType());
        record.setBusinessLastOrg(param.getBusinessLastOrg());
        this.updateById(record);
    }

    @Override
    @Transactional
    public void acceptRecordSubmit(RiskAcceptRecordSubmitParam param) {
        if (param.getId() == null || param.getRiskId() == null) {
            throw new ServiceException("\u53c2\u6570\u7f3a\u5931[id,RiskId]");
        }
        if (StringUtils.isEmpty((CharSequence)param.getReformDirectorName())) {
            throw new ServiceException("\u6574\u6539\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RRiskAcceptanceRecord record = this.converter.SubmitParam2entity(param);
        record.setCid(param.getLoginCid());
        record.setRiskId(param.getRiskId());
        record.setUpdateBy(param.getLoginUserId());
        record.setUpdateDate(LocalDateTime.now());
        record.setSubmitTime(LocalDateTime.now());
        record.setRequireFinishTime(null);
        record.setBusinessLastDate(param.getBusinessLastDate());
        record.setBusinessLastOrg(param.getBusinessLastOrg());
        record.setHealthLastType(param.getHealthLastType());
        record.setDoseMonitorLastStartDate(param.getDoseMonitorLastStartDate());
        record.setDoseMonitorLastEndDate(param.getDoseMonitorLastEndDate());
        record.setStatus(param.getStatus());
        this.updateById(record);
        if (Objects.equals(param.getStatus(), RiskAcceptanceStatusEnum.PENDING_AUDIT.getValue())) {
            RRiskBasic riskBasic = (RRiskBasic)this.riskBasicService.getById(param.getRiskId());
            riskBasic.setStatus(BasicRiskStatusEnum.UNRESOLVED.getValue());
            riskBasic.setUnresolvedType(RiskUnresolvedTypeEnum.UN_ACCEPT.getValue());
            riskBasic.setUpdateBy(param.getLoginUserId());
            riskBasic.setUpdateDate(LocalDateTime.now());
            this.riskBasicService.updateById(riskBasic);
            this.riskBasicSourceService.updateBatchByAcceptRecordSubmit(param);
        }
    }

    @Override
    public List<BaseImportDto> acceptRecordSubmitBatch(RiskAcceptRecordSubmitParam param) {
        if (CollectionUtils.isEmpty(param.getIds())) {
            throw new ServiceException("\u98ce\u9669\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)param.getReformDirectorName())) {
            throw new ServiceException("\u6574\u6539\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Long> riskSourceIdList = param.getRiskSourceIds();
        ArrayList<BaseImportDto> errDataList = new ArrayList<BaseImportDto>();
        List<RRiskBasicSource> riskBasicSourceListOrigin = this.riskBasicSourceService.getRiskBasicSourceListByIds(riskSourceIdList, ShiroUtil.getLoginUserCid());
        if (CollectionUtils.isEmpty(riskBasicSourceListOrigin)) {
            throw new ServiceException("\u7cfb\u7edf\u672a\u627e\u5230\u98ce\u9669\u6570\u636e\uff01\u8bf7\u68c0\u67e5");
        }
        Integer performanceTest = RiskTypeEnum.PERFORMANCE_TEST.getValue();
        Integer exceptionPlaceTest = RiskTypeEnum.EXCEPTION_PLACE_TEST.getValue();
        Integer doseMonitoring = RiskTypeEnum.DOSE_MONITORING.getValue();
        Integer physicalExamination = RiskTypeEnum.PHYSICAL_EXAMINATION.getValue();
        Integer prePost = RiskPostStatusEnum.PRE_POST.getValue();
        Integer onPost = RiskPostStatusEnum.ON_POST.getValue();
        Integer doseMonitorMat = AcceptanceMaterialsTypeEnum.DOSE_MONITOR.getValue();
        Integer deviceCheckedMat = AcceptanceMaterialsTypeEnum.DEVICE_CHECKED.getValue();
        Integer roomCheckedMat = AcceptanceMaterialsTypeEnum.ROOM_CHECKED.getValue();
        Integer healthCheckedOnMat = AcceptanceMaterialsTypeEnum.HEALTH_CHECKED_ON.getValue();
        Integer healthCheckedBeforeMat = AcceptanceMaterialsTypeEnum.HEALTH_CHECKED_BEFORE.getValue();
        for (RRiskBasicSource riskSource : riskBasicSourceListOrigin) {
            BaseImportDto errorData;
            boolean isRestrictedRiskType = this.isRestrictedRiskType(riskSource, performanceTest, exceptionPlaceTest, doseMonitoring, physicalExamination, prePost, onPost);
            boolean isImproperMaterialSelection = this.isImproperMaterialType(param, doseMonitorMat, deviceCheckedMat, roomCheckedMat, healthCheckedOnMat, healthCheckedBeforeMat);
            if (isRestrictedRiskType && isImproperMaterialSelection) {
                errorData = new BaseImportDto();
                errorData.setErrorReason(riskSource.getName() + "\uff0c\u8be5\u98ce\u9669\u7c7b\u578b\u53ea\u80fd\u5728\"\u7ea2\u8272\u9884\u8b66\"\u72b6\u6001\u624d\u80fd\u9009\u62e9\"\u5df2\u6309\u8981\u6c42\u5f00\u5c55...\"\u7c7b\u578b\u7684\u4f50\u8bc1\u6750\u6599\uff01\u8bf7\u68c0\u67e5\uff01");
                errDataList.add(errorData);
            }
            if (!riskSource.getTimeSpecialType().equals(RiskTimeSpecialTypeEnum.COMMON.getValue())) {
                errorData = new BaseImportDto();
                errorData.setErrorReason(riskSource.getName() + "\uff0c\u8be5\u7f16\u53f7\u98ce\u9669\u65e0\u6cd5\u901a\u8fc7\u4f50\u8bc1\u6750\u6599\u5316\u89e3\uff0c\u8bf7\u68c0\u67e5\uff01");
                errDataList.add(errorData);
            }
            if (riskSource.getWarningStatus().equals(RiskWarningStatusEnum.RED.getValue()) || !riskSource.getType().equals(RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue())) continue;
            errorData = new BaseImportDto();
            errorData.setErrorReason(riskSource.getName() + "\uff0c\u8be5\u7f16\u53f7\u98ce\u9669\uff08\u4f53\u68c0\u5f02\u5e38-\u590d\u67e5\uff09\u53ea\u80fd\u5728\u201c\u7ea2\u8272\u9884\u8b66\u201d\u72b6\u6001\u624d\u53ef\u6574\u6539\u5316\u89e3\uff0c\u8bf7\u68c0\u67e5\uff01");
            errDataList.add(errorData);
        }
        if (!errDataList.isEmpty()) {
            return errDataList;
        }
        param.getIds().forEach(accId -> {
            RRiskAcceptanceRecord record = this.converter.SubmitParam2entity(param);
            record.setId(accId);
            record.setCid(param.getLoginCid());
            record.setCreateBy(param.getLoginUserId());
            record.setUpdateBy(param.getLoginUserId());
            record.setUpdateDate(LocalDateTime.now());
            record.setSubmitTime(LocalDateTime.now());
            record.setRequireFinishTime(null);
            record.setBusinessLastDate(param.getBusinessLastDate());
            record.setBusinessLastOrg(param.getBusinessLastOrg());
            record.setHealthLastType(param.getHealthLastType());
            record.setDoseMonitorLastStartDate(param.getDoseMonitorLastStartDate());
            record.setDoseMonitorLastEndDate(param.getDoseMonitorLastEndDate());
            record.setStatus(param.getStatus());
            this.updateById(record);
            if (Objects.equals(param.getStatus(), RiskAcceptanceStatusEnum.PENDING_AUDIT.getValue())) {
                RRiskBasic riskBasic = (RRiskBasic)this.riskBasicService.getById(param.getRiskId());
                riskBasic.setStatus(BasicRiskStatusEnum.UNRESOLVED.getValue());
                riskBasic.setUnresolvedType(RiskUnresolvedTypeEnum.UN_ACCEPT.getValue());
                riskBasic.setUpdateBy(param.getLoginUserId());
                riskBasic.setUpdateDate(LocalDateTime.now());
                this.riskBasicService.updateById(riskBasic);
                this.riskBasicSourceService.updateBatchByAcceptRecordSubmit(param);
            }
        });
        return errDataList;
    }

    private boolean isRestrictedRiskType(RRiskBasicSource riskSource, Integer performanceTest, Integer exceptionPlaceTest, Integer doseMonitoring, Integer physicalExamination, Integer prePost, Integer onPost) {
        Integer riskType = riskSource.getType();
        if (riskType == null) {
            return false;
        }
        if (riskType.equals(performanceTest) || riskType.equals(exceptionPlaceTest) || riskType.equals(doseMonitoring)) {
            return !riskSource.getWarningStatus().equals(RiskWarningStatusEnum.RED.getValue());
        }
        if (riskType.equals(physicalExamination)) {
            Integer postType = riskSource.getPostType();
            return postType != null && (postType.equals(prePost) || postType.equals(onPost)) && !riskSource.getWarningStatus().equals(RiskWarningStatusEnum.RED.getValue());
        }
        return false;
    }

    private boolean isImproperMaterialType(RiskAcceptRecordSubmitParam param, Integer doseMonitorMat, Integer deviceCheckedMat, Integer roomCheckedMat, Integer healthCheckedOnMat, Integer healthCheckedBeforeMat) {
        Integer materialType = param.getMaterialsType();
        if (materialType == null) {
            return false;
        }
        return materialType.equals(doseMonitorMat) || materialType.equals(deviceCheckedMat) || materialType.equals(roomCheckedMat) || materialType.equals(healthCheckedOnMat) || materialType.equals(healthCheckedBeforeMat);
    }
}

