/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.g;

import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.modules.health.supervise.service.basic.IOrganizationUserService;
import cn.smarthse.modules.health.supervise.vo.sys.v3.organization.OrganizationUserV3OneVo;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.dao.g.GEquipmentSelfCheckMapper;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.g.IGProtectiveEquipmentService;
import cn.smarthse.rho.modules.company.service.r.IRKeyFactorAuditService;
import cn.smarthse.rho.modules.company.service.r.IRRiskAcceptanceRecordService;
import cn.smarthse.rho.modules.company.service.r.IRRiskBasicSourceService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.g.GEquipmentSelfCheck;
import cn.smarthse.rho.modules.sys.entity.r.RKeyFactorAudit;
import cn.smarthse.rho.modules.sys.entity.r.RRiskAcceptanceRecord;
import cn.smarthse.rho.modules.sys.entity.r.RRiskBasicSource;
import cn.smarthse.rho.modules.sys.entity.sys.SysBusinessOperateLog;
import cn.smarthse.rho.modules.sys.enums.risk.AcceptanceRecordResultEnum;
import cn.smarthse.rho.modules.sys.enums.risk.AcceptanceRecordStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.KeyFactoAuditStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskSourceEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogModuleEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogTypeEnum;
import cn.smarthse.rho.modules.sys.model.g.param.GEquipmentSelfCheckEditParam;
import cn.smarthse.rho.modules.sys.model.g.param.GEquipmentSelfCheckListParam;
import cn.smarthse.rho.modules.sys.model.g.param.GEquipmentSelfCheckLogListParam;
import cn.smarthse.rho.modules.sys.model.g.param.GEquipmentSelfCheckReturnParam;
import cn.smarthse.rho.modules.sys.model.g.vo.GEquipmentSelfCheckListVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GEquipmentSelfCheckLogListVo;
import cn.smarthse.rho.modules.sys.model.g.vo.GEquipmentSelfCheckOneVo;
import cn.smarthse.rho.modules.sys.model.r.param.AddRiskForCommonParam;
import cn.smarthse.rho.modules.sys.model.r.param.RiskMangerGenParam;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskAboutStatusManagerProvider;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysBusinessOperateLogProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysChangeLogProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import com.github.pagehelper.PageHelper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GProtectiveEquipmentServiceImpl
extends ServiceImpl<GEquipmentSelfCheckMapper, GEquipmentSelfCheck>
implements IGProtectiveEquipmentService {
    @DubboReference
    private ISysFileProvider sysFileProvider;
    @DubboReference
    private IRiskProvider riskProvider;
    @DubboReference
    private ISysChangeLogProvider sysChangeLogProvider;
    @DubboReference
    private ISysBusinessOperateLogProvider businessOperateLogProvider;
    @DubboReference(registry={"public_nacos"})
    private IOrganizationUserService organizationUserService;
    @DubboReference
    private IRiskAboutStatusManagerProvider riskAboutStatusManagerProvider;
    @Autowired
    private IRRiskBasicSourceService riskSourceService;
    @Autowired
    private IRRiskAcceptanceRecordService riskAcceptanceRecordService;
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private IRKeyFactorAuditService keyFactorAuditService;
    @Autowired
    @Lazy
    private GProtectiveEquipmentServiceImpl selfBean;
    private static final long MAX_FILE_SIZE = 0x300000L;
    private static final Set<String> SUPPORT_FILE_TYPES = new HashSet<String>(Arrays.asList("pdf", "jpg", "jpeg", "png"));

    @Override
    public LayuiGridData<GEquipmentSelfCheckListVo> getSelfCheckList(GEquipmentSelfCheckListParam param) {
        List<GEquipmentSelfCheckListVo> voList = ((GEquipmentSelfCheckMapper)this.baseMapper).getSelfCheckList(param);
        Set fileIds = voList.stream().flatMap(item -> Stream.of(item.getCertificateFile(), item.getCommitmentFile())).filter(Objects::nonNull).collect(Collectors.toSet());
        if (CollectionUtil.isNotEmpty(fileIds)) {
            String idsStr = fileIds.stream().map(String::valueOf).collect(Collectors.joining(","));
            Map<Long, SysFileVo> fileVoMap = this.sysFileProvider.getFileVoByIds(idsStr).stream().collect(Collectors.toMap(SysFileVo::getId, vo -> vo));
            voList.forEach(vo -> {
                vo.setCertificateFileVo((SysFileVo)fileVoMap.get(vo.getCertificateFile()));
                vo.setCommitmentFileVo((SysFileVo)fileVoMap.get(vo.getCommitmentFile()));
            });
        }
        if (CollectionUtil.isEmpty(voList)) {
            return new LayuiGridData();
        }
        return new LayuiGridData(voList, Integer.valueOf(param.getPage()), Integer.valueOf(param.getLimit()));
    }

    @Override
    public void addOrEditOneSelfCheck(GEquipmentSelfCheckEditParam param) {
        this.paramCheck(param);
        GEquipmentSelfCheck selfCheck = (GEquipmentSelfCheck)((GEquipmentSelfCheckMapper)this.baseMapper).selectById(param.getId());
        Boolean isAdd = selfCheck == null;
        selfCheck = this.selfBean.addOrEditOneselfCheck(param, isAdd, selfCheck);
        BCompany company = (BCompany)this.companyService.getById(param.getCid());
        if (Objects.equals(company.getIsPilotUnit(), 1)) {
            this.selfBean.maintainSelfCheckRisk(param.getCid(), RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue(), isAdd, false);
        }
        this.addKeyFactorAudit(selfCheck.getCid(), selfCheck.getId());
    }

    @Transactional
    public GEquipmentSelfCheck addOrEditOneselfCheck(GEquipmentSelfCheckEditParam param, Boolean isAdd, GEquipmentSelfCheck selfCheck) {
        if (isAdd.booleanValue()) {
            selfCheck = new GEquipmentSelfCheck().setCid(param.getCid()).setCheckTime(param.getCheckTime()).setCertificateFile(param.getCertificateFile()).setName(param.getName()).setPhone(param.getPhone()).setCommitmentFile(param.getCommitmentFile());
            ((GEquipmentSelfCheckMapper)this.baseMapper).insert(selfCheck);
        } else {
            selfCheck.setId(param.getId()).setCheckTime(param.getCheckTime()).setCertificateFile(param.getCertificateFile()).setName(param.getName()).setPhone(param.getPhone()).setCommitmentFile(param.getCommitmentFile()).setStatus(Integer.valueOf(1));
            ((GEquipmentSelfCheckMapper)this.baseMapper).updateById(selfCheck);
        }
        return selfCheck;
    }

    private void addKeyFactorAudit(Long cid, Long checkId) {
        BCompany company = (BCompany)this.companyService.getById(cid);
        if (company == null) {
            throw new ServiceException("\u672a\u627e\u5230\u6709\u6548\u7684\u533b\u9662");
        }
        RKeyFactorAudit oneByBusinessId = this.keyFactorAuditService.getOneByBusinessId(checkId);
        RKeyFactorAudit keyFactorAudit = oneByBusinessId != null ? oneByBusinessId : new RKeyFactorAudit();
        keyFactorAudit.setCid(cid);
        keyFactorAudit.setCompanyName(company.getName());
        keyFactorAudit.setCompanyAddress(company.getAddress());
        keyFactorAudit.setType(RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue());
        keyFactorAudit.setStatus(KeyFactoAuditStatusEnum.NOT_NEED_AUDIT.getCode());
        keyFactorAudit.setBusinessId(checkId);
        keyFactorAudit.setUpdateDate(new Date());
        this.keyFactorAuditService.addOrUpdateOneAudit(keyFactorAudit);
    }

    private void paramCheck(GEquipmentSelfCheckEditParam param) {
        if (param.getCheckTime().isAfter(LocalDateTime.now())) {
            throw new ServiceException("\u81ea\u68c0\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
        }
        SysFileVo commitmentFile = this.sysFileProvider.getFileById(param.getCommitmentFile());
        SysFileVo certificateFile = this.sysFileProvider.getFileById(param.getCertificateFile());
        if (certificateFile == null || commitmentFile == null) {
            throw new ServiceException("\u6587\u4ef6ID\u4e0d\u5408\u6cd5");
        }
        String commitmentExt = commitmentFile.getFileExt();
        if (commitmentExt == null || !SUPPORT_FILE_TYPES.contains(commitmentExt.toLowerCase())) {
            throw new ServiceException("\u4e0d\u652f\u6301\u7684\u627f\u8bfa\u4e66\u6587\u4ef6\u7c7b\u578b");
        }
        String certificateExt = certificateFile.getFileExt();
        if (certificateExt == null || !SUPPORT_FILE_TYPES.contains(certificateExt.toLowerCase())) {
            throw new ServiceException("\u4e0d\u652f\u6301\u7684\u4f50\u8bc1\u6750\u6599\u6587\u4ef6\u7c7b\u578b");
        }
        if (Long.parseLong(commitmentFile.getFileSize()) > 0x300000L) {
            throw new ServiceException("\u627f\u8bfa\u4e66\u6587\u4ef6\u8fc7\u5927");
        }
        if (Long.parseLong(certificateFile.getFileSize()) > 0x300000L) {
            throw new ServiceException("\u4f50\u8bc1\u6750\u6599\u6587\u4ef6\u8fc7\u5927");
        }
        if (param.getCid() == null) {
            throw new ServiceException("cid\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    @Override
    public LayuiGridData<GEquipmentSelfCheckLogListVo> getSelfCheckLog(GEquipmentSelfCheckLogListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List voList = this.sysChangeLogProvider.getEquipmentSelfCheckLog(param);
        if (CollectionUtil.isEmpty((Collection)voList)) {
            return new LayuiGridData();
        }
        return new LayuiGridData(voList, Integer.valueOf(param.getPage()), Integer.valueOf(param.getLimit()));
    }

    @Override
    public GEquipmentSelfCheckOneVo getOneById(Long id) {
        GEquipmentSelfCheckOneVo vo = ((GEquipmentSelfCheckMapper)this.baseMapper).selectVoById(id);
        SysFileVo certificateFile = this.sysFileProvider.getFileById(vo.getCertificateFile());
        SysFileVo commitmentFile = this.sysFileProvider.getFileById(vo.getCommitmentFile());
        vo.setCertificateFileVo(certificateFile).setCommitmentFileVo(commitmentFile);
        return vo;
    }

    @Override
    public void returnSelfCheck(GEquipmentSelfCheckReturnParam param) {
        GEquipmentSelfCheck selfCheck = (GEquipmentSelfCheck)((GEquipmentSelfCheckMapper)this.baseMapper).selectById(param.getId());
        if (selfCheck == null) {
            throw new ServiceException("\u81ea\u68c0\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        selfCheck.setStatus(Integer.valueOf(2));
        ((GEquipmentSelfCheckMapper)this.baseMapper).updateById(selfCheck);
        this.maintainSelfCheckRisk(selfCheck.getCid(), RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue(), false, true);
        this.addBusinessOperateLog(param.getLoginUserId(), selfCheck);
    }

    private void addBusinessOperateLog(Long loginUserId, GEquipmentSelfCheck selfCheck) {
        OrganizationUserV3OneVo loginUser = this.organizationUserService.getOrganizationUserOne(loginUserId);
        SysBusinessOperateLog log = new SysBusinessOperateLog();
        log.setModule(SysBusinessOperateLogModuleEnum.KEY_FACTOR_AUDIT_3.getValue());
        log.setCid(selfCheck.getCid());
        log.setBusinessId(selfCheck.getId());
        log.setType(SysBusinessOperateLogTypeEnum.BACK.getValue());
        log.setOperator(loginUser != null ? loginUser.getUsername() : null);
        log.setOperatorCompanyName(loginUser != null ? loginUser.getOname() : null);
        log.setReason(null);
        this.businessOperateLogProvider.addOrUpdateLog(log);
    }

    public void maintainSelfCheckRisk(Long cid, Integer riskType, Boolean isAdd, Boolean isReturn) {
        GEquipmentSelfCheck latestPassed = ((GEquipmentSelfCheckMapper)this.baseMapper).selectLatestSelfCheckByCid(cid);
        RRiskBasicSource currentRisk = this.riskSourceService.getUnResolveSelfCheckRisk(riskType, cid);
        if (latestPassed == null) {
            if (currentRisk == null) {
                this.selfBean.genNewRisk(cid, null, null);
                this.selfBean.changeRiskStatus();
            } else {
                this.updateRisk(currentRisk, null, isAdd, isReturn);
            }
        } else {
            LocalDateTime threshold;
            LocalDateTime checkTime = latestPassed.getCheckTime();
            if (checkTime.isAfter(threshold = LocalDateTime.now().minusMonths(9L))) {
                if (currentRisk != null && currentRisk.getStatus() == 1) {
                    this.resolveRisk(currentRisk, isAdd, false);
                }
            } else if (currentRisk == null) {
                this.selfBean.genNewRisk(cid, latestPassed, null);
                this.selfBean.changeRiskStatus();
            } else {
                this.updateRisk(currentRisk, latestPassed, isAdd, isReturn);
            }
        }
    }

    @Transactional
    public void genNewRisk(Long cid, GEquipmentSelfCheck latestPassed, LocalDate startTime) {
        Boolean existData = latestPassed != null;
        AddRiskForCommonParam genParam = new AddRiskForCommonParam();
        genParam.setCid(cid);
        genParam.setThirdOrgId(null);
        genParam.setBusinessId(existData != false ? latestPassed.getId() : null);
        genParam.setSubBusinessId(null);
        genParam.setName(existData != false ? "\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u81ea\u68c0\u5373\u5c06\u5931\u6548" : "\u672a\u53ca\u65f6\u5f00\u5c55\u4e2a\u4eba\u9632\u62a4\u7528\u54c1\u81ea\u68c0");
        genParam.setSource(RiskSourceEnum.PORTRAIT.getValue());
        genParam.setType(RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue());
        genParam.setFinderName("\u7cfb\u7edf");
        genParam.setDescription(null);
        genParam.setFiles(null);
        genParam.setStartTime(startTime != null ? startTime : (existData != false ? latestPassed.getCheckTime().toLocalDate() : null));
        genParam.setIsGenerateByData(Integer.valueOf(existData != false ? 1 : 0));
        this.riskProvider.genRiskOfCommon(List.of(genParam));
    }

    @Transactional
    public void changeRiskStatus() {
        RiskMangerGenParam param = new RiskMangerGenParam();
        if (param.getYear() == null) {
            param.setYear(Integer.valueOf(LocalDate.now().getYear()));
        }
        this.riskAboutStatusManagerProvider.changeRiskStatus(param);
    }

    private void resolveRisk(RRiskBasicSource risk, Boolean isAdd, Boolean isReturn) {
        List<Long> sourceIdList = List.of(risk.getId());
        List<RRiskAcceptanceRecord> acceptanceRecordList = this.riskAcceptanceRecordService.getAcceptRecordListBySourceIds(sourceIdList);
        if (CollectionUtil.isEmpty(acceptanceRecordList)) {
            throw new ServiceException("\u98ce\u9669\u9a8c\u6536\u8bb0\u5f55\u4e3a\u7a7a\uff0c\u98ce\u9669\u5316\u89e3\u5931\u8d25");
        }
        RRiskAcceptanceRecord acceptanceRecord = acceptanceRecordList.get(0);
        acceptanceRecord.setAcceptanceDate(LocalDate.now());
        acceptanceRecord.setRequireFinishTime(risk.getRequireFinishTime());
        acceptanceRecord.setActualFinishTime(LocalDate.now());
        acceptanceRecord.setSubmitTime(LocalDateTime.now());
        acceptanceRecord.setStatus(AcceptanceRecordStatusEnum.DONE.getValue());
        acceptanceRecord.setAcceptanceResult(AcceptanceRecordResultEnum.PASS.getValue());
        if (StringUtils.isEmpty((CharSequence)acceptanceRecord.getReformDirectorName())) {
            acceptanceRecord.setReformDirectorName(ShiroUtil.getLoginUserSuperuserName());
            String typeStr = isReturn != false ? "\u9000\u56de" : (isAdd != false ? "\u65b0\u589e" : "\u4fee\u6539");
            String measureStr = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy\u5e74MM\u6708dd\u65e5")) + "\uff0c" + typeStr + "\u4e86\u5b89\u5168\u88c5\u7f6e\u548c\u8b66\u793a\u6807\u8bc6\u81ea\u67e5\u8bb0\u5f55";
            acceptanceRecord.setReformMeasure(measureStr);
        }
        this.selfBean.updateAcceptanceRecord(acceptanceRecord);
        this.selfBean.resolveRisk(sourceIdList);
    }

    @Transactional
    public void updateAcceptanceRecord(RRiskAcceptanceRecord acceptanceRecord) {
        this.riskAcceptanceRecordService.updateById(acceptanceRecord);
    }

    @Transactional
    public void resolveRisk(List<Long> sourceIdList) {
        this.riskProvider.resolveRiskOfCommon(sourceIdList);
    }

    private void updateRisk(RRiskBasicSource risk, GEquipmentSelfCheck latestPassed, Boolean isAdd, Boolean isReturn) {
        if (latestPassed == null) {
            if (risk.getStatus() == 1) {
                this.resolveRisk(risk, null, isReturn);
            }
            this.selfBean.genNewRisk(risk.getCid(), null, risk.getBusinessStartDate());
            this.selfBean.changeRiskStatus();
        } else {
            if (risk.getStatus() == 1) {
                this.resolveRisk(risk, isAdd, isReturn);
            }
            this.selfBean.genNewRisk(risk.getCid(), latestPassed, null);
            this.selfBean.changeRiskStatus();
        }
    }

    @Generated
    public GProtectiveEquipmentServiceImpl() {
    }
}

