/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.f;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.dao.f.FProjectMapper;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.e.IEmachineRoomService;
import cn.smarthse.rho.modules.company.service.f.IFProjectDetailService;
import cn.smarthse.rho.modules.company.service.f.IFProjectService;
import cn.smarthse.rho.modules.company.service.r.IRKeyFactorAuditService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.f.FProject;
import cn.smarthse.rho.modules.sys.entity.f.FProjectDetail;
import cn.smarthse.rho.modules.sys.entity.r.RKeyFactorAudit;
import cn.smarthse.rho.modules.sys.entity.sys.SysBusinessOperateLog;
import cn.smarthse.rho.modules.sys.enums.f.FProjectDetailFillTypeEnum;
import cn.smarthse.rho.modules.sys.enums.f.FProjectDetailStatusEnum;
import cn.smarthse.rho.modules.sys.enums.f.FProjectStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.KeyFactoAuditStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogModuleEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogTypeEnum;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceDetailVo;
import cn.smarthse.rho.modules.sys.model.f.param.FThreeTimesProjectAddParam;
import cn.smarthse.rho.modules.sys.model.f.param.FThreeTimesProjectEditParam;
import cn.smarthse.rho.modules.sys.model.f.param.ThreeProjectDetailQueryParam;
import cn.smarthse.rho.modules.sys.model.f.param.ThreeProjectQueryParam;
import cn.smarthse.rho.modules.sys.model.f.vo.FThreeTimesProjectDetailVo;
import cn.smarthse.rho.modules.sys.model.f.vo.FThreeTimesProjectVo;
import cn.smarthse.rho.modules.sys.provider.e.IEDeviceCommonProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysBusinessOperateLogProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Arrays;
import java.util.Date;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class FProjectServiceImpl
extends ServiceImpl<FProjectMapper, FProject>
implements IFProjectService {
    @Autowired
    private IFProjectDetailService projectDetailService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private IRKeyFactorAuditService keyFactorAuditService;
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private IEmachineRoomService roomService;
    @DubboReference
    private ISysBusinessOperateLogProvider logProvider;
    @DubboReference
    private IEDeviceCommonProvider deviceCommonProvider;
    @DubboReference
    private ISysFileProvider sysFileProvider;

    @Override
    public LayuiGridData<FThreeTimesProjectVo> getThreeProjectList(ThreeProjectQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        Page page = (Page)((FProjectMapper)this.baseMapper).getThreeProjectList(param);
        return new LayuiGridData(page, (LayuiGridParam)param);
    }

    @Override
    public FThreeTimesProjectDetailVo getDetailByProjectId(ThreeProjectDetailQueryParam param) {
        FProjectDetail projectDetail2;
        FProject projectVoById;
        FThreeTimesProjectDetailVo result = new FThreeTimesProjectDetailVo();
        RKeyFactorAudit keyFactorAudit = this.keyFactorAuditService.getOneByBusinessId(param.getProjectId());
        if (keyFactorAudit != null) {
            result.setKeyFactorAuditId(keyFactorAudit.getId());
        }
        if ((projectVoById = this.getFProjectVoById(param.getProjectId())) != null && projectVoById.getDeviceId() != null) {
            projectVoById.setRoomList(this.roomService.listRelationMachineRoomByDId(projectVoById.getDeviceId()));
        }
        result.setBaseInfo(projectVoById);
        FProjectDetail projectDetail1 = (FProjectDetail)this.projectDetailService.getById(param.getDetail1Id());
        if (projectDetail1 != null && StringUtils.isNotEmpty((String)projectDetail1.getCheckReportIds())) {
            projectDetail1.setCheckReportFiles(this.sysFileProvider.getFileVoByIds(projectDetail1.getCheckReportIds()));
        }
        if ((projectDetail2 = (FProjectDetail)this.projectDetailService.getById(param.getDetail2Id())) != null && StringUtils.isNotEmpty((String)projectDetail2.getCheckReportIds())) {
            projectDetail2.setCheckReportFiles(this.sysFileProvider.getFileVoByIds(projectDetail2.getCheckReportIds()));
        }
        result.setProjectDetail1(projectDetail1);
        result.setProjectDetail2(projectDetail2);
        return result;
    }

    @Override
    @Transactional
    public void editThreeTimesProject(FThreeTimesProjectEditParam param) {
        FProject fProject = param.getBaseInfo();
        FProjectDetail projectDetail1 = param.getProjectDetail1();
        FProjectDetail projectDetail2 = param.getProjectDetail2();
        BCompany company = (BCompany)this.companyService.getById(ShiroUtil.getLoginUserCid());
        fProject.setCid(ShiroUtil.getLoginUserCid());
        fProject.setCname(company.getHospitalName());
        fProject.setCbranch(company.getName());
        fProject.setStatus(FProjectStatusEnum.DRAFT.getValue());
        this.saveOrUpdate(fProject);
        this.setThreeTimesProjectPreAndCvaStatus(projectDetail1);
        this.setThreeTimesProjectPreAndCvaStatus(projectDetail2);
        projectDetail1.setProjectId(fProject.getId());
        projectDetail1.setType(Integer.valueOf(1));
        projectDetail2.setProjectId(fProject.getId());
        projectDetail2.setType(Integer.valueOf(2));
        this.projectDetailService.saveOrUpdate(projectDetail1);
        this.projectDetailService.saveOrUpdate(projectDetail2);
        RKeyFactorAudit keyFactorAudit = new RKeyFactorAudit();
        keyFactorAudit.setType(RiskTypeEnum.THREE.getValue());
        keyFactorAudit.setStatus(KeyFactoAuditStatusEnum.DRAFT.getCode());
        keyFactorAudit.setBusinessId(fProject.getId());
        keyFactorAudit.setCid(fProject.getCid());
        keyFactorAudit.setCompanyName(fProject.getCname());
        keyFactorAudit.setCompanyAddress(fProject.getAddress());
        if (param.getKeyFactorAuditId() != null) {
            keyFactorAudit.setId(param.getKeyFactorAuditId());
        }
        this.keyFactorAuditService.saveOrUpdate(keyFactorAudit);
        SysBusinessOperateLog log = new SysBusinessOperateLog();
        log.setBusinessId(param.getKeyFactorAuditId() != null ? param.getKeyFactorAuditId() : keyFactorAudit.getId()).setModule(SysBusinessOperateLogModuleEnum.KEY_FACTOR_AUDIT_2.getValue()).setType(SysBusinessOperateLogTypeEnum.DRAFT.getValue()).setCid(fProject.getCid()).setOperator(ShiroUtil.getJWTUsername()).setOperatorCompanyName(fProject.getCbranch());
        this.logProvider.addOrUpdateLog(log);
    }

    @Override
    @Transactional
    public void submitThreeTimesProject(FThreeTimesProjectEditParam param) {
        FProject fProject = param.getBaseInfo();
        FProjectDetail projectDetail1 = param.getProjectDetail1();
        FProjectDetail projectDetail2 = param.getProjectDetail2();
        BCompany company = (BCompany)this.companyService.getById(ShiroUtil.getLoginUserCid());
        fProject.setCid(ShiroUtil.getLoginUserCid());
        fProject.setCname(company.getHospitalName());
        fProject.setCbranch(company.getName());
        projectDetail1.setType(Integer.valueOf(1));
        projectDetail2.setType(Integer.valueOf(2));
        this.setThreeTimesProjectPreAndCvaStatus(projectDetail1);
        this.setThreeTimesProjectPreAndCvaStatus(projectDetail2);
        if (param.getProjectDetail1().getFillType().equals(FProjectDetailFillTypeEnum.TYPE_2.getValue()) || param.getProjectDetail2().getFillType().equals(FProjectDetailFillTypeEnum.TYPE_2.getValue())) {
            fProject.setStatus(FProjectStatusEnum.AUDIT.getValue());
            RKeyFactorAudit keyFactorAudit = new RKeyFactorAudit();
            keyFactorAudit.setType(RiskTypeEnum.THREE.getValue());
            keyFactorAudit.setStatus(KeyFactoAuditStatusEnum.AUDIT.getCode());
            keyFactorAudit.setBusinessId(fProject.getId());
            keyFactorAudit.setCid(fProject.getCid());
            keyFactorAudit.setCompanyName(fProject.getCname());
            keyFactorAudit.setCompanyAddress(fProject.getAddress());
            if (param.getKeyFactorAuditId() != null) {
                keyFactorAudit.setId(param.getKeyFactorAuditId());
            }
            this.keyFactorAuditService.saveOrUpdate(keyFactorAudit);
            SysBusinessOperateLog log = new SysBusinessOperateLog();
            log.setBusinessId(param.getKeyFactorAuditId() != null ? param.getKeyFactorAuditId() : keyFactorAudit.getId()).setModule(SysBusinessOperateLogModuleEnum.KEY_FACTOR_AUDIT_2.getValue()).setType(SysBusinessOperateLogTypeEnum.SUBMIT.getValue()).setCid(fProject.getCid()).setOperator(ShiroUtil.getJWTUsername()).setOperatorCompanyName(fProject.getCbranch());
            this.logProvider.addOrUpdateLog(log);
        } else if (param.getProjectDetail1().getPreStatus().equals(FProjectDetailStatusEnum.FINISHED.getValue()) && param.getProjectDetail2().getPreStatus().equals(FProjectDetailStatusEnum.FINISHED.getValue()) && param.getProjectDetail1().getCvaStatus().equals(FProjectDetailStatusEnum.FINISHED.getValue()) && param.getProjectDetail2().getCvaStatus().equals(FProjectDetailStatusEnum.FINISHED.getValue())) {
            fProject.setStatus(FProjectStatusEnum.NOT_NEED_AUDIT.getValue());
        }
        this.saveOrUpdate(fProject);
        projectDetail1.setProjectId(fProject.getId());
        projectDetail2.setProjectId(fProject.getId());
        this.projectDetailService.saveOrUpdate(param.getProjectDetail1());
        this.projectDetailService.saveOrUpdate(param.getProjectDetail2());
    }

    void setThreeTimesProjectPreAndCvaStatus(FProjectDetail detail) {
        if (StringUtils.isNotEmpty((String)detail.getPreReportNo()) && StringUtils.isNotEmpty((String)detail.getPreTechName()) && detail.getPreReportDate() != null) {
            detail.setPreStatus(FProjectDetailStatusEnum.FINISHED.getValue());
        } else {
            detail.setPreStatus(FProjectDetailStatusEnum.UN_FINISH.getValue());
        }
        if (StringUtils.isNotEmpty((String)detail.getCvaReportNo()) && StringUtils.isNotEmpty((String)detail.getCvaTechName()) && StringUtils.isNotEmpty((String)detail.getCheckReportNo()) && detail.getCvaReportDate() != null) {
            detail.setCvaStatus(FProjectDetailStatusEnum.FINISHED.getValue());
        } else {
            detail.setCvaStatus(FProjectDetailStatusEnum.UN_FINISH.getValue());
        }
    }

    @Override
    @Transactional
    public FProject generateThreeTimesProject(FThreeTimesProjectAddParam param) {
        FProject fProject = new FProject();
        fProject.setCid(param.getCid());
        fProject.setName(param.getDeviceName());
        fProject.setDeviceId(param.getDeviceId());
        fProject.setDeviceNo(param.getDeviceNo());
        fProject.setRoomId(param.getRoomIds());
        fProject.setRoomName(param.getRoomNames());
        fProject.setBeginDate(new Date());
        fProject.setStatus(FProjectStatusEnum.DRAFT.getValue());
        BCompany company = (BCompany)this.companyService.getById(param.getCid());
        if (company != null) {
            fProject.setCname(company.getName());
            fProject.setAddress(company.getAddress());
            fProject.setCbranch(company.getHospitalName());
        }
        this.save(fProject);
        FProjectDetail projectDetail1 = new FProjectDetail();
        projectDetail1.setProjectId(fProject.getId());
        projectDetail1.setType(Integer.valueOf(1));
        FProjectDetail projectDetail2 = new FProjectDetail();
        projectDetail2.setProjectId(fProject.getId());
        projectDetail2.setType(Integer.valueOf(2));
        this.projectDetailService.saveBatch(Arrays.asList(projectDetail1, projectDetail2));
        return fProject;
    }

    public FProject getFProjectVoById(Long id) {
        EDeviceDetailVo deviceRayDetailVo;
        FProject fProject = (FProject)this.getById(id);
        if (fProject != null && (deviceRayDetailVo = this.deviceCommonProvider.getEDeviceDetailVo(fProject.getDeviceId())) != null) {
            fProject.setDeviceType(deviceRayDetailVo.getType());
            fProject.setDeviceNo(deviceRayDetailVo.getFactoryNo());
            fProject.setCategory(deviceRayDetailVo.getCategory());
            fProject.setMobilityType(deviceRayDetailVo.getMobilityType());
        }
        return fProject;
    }
}

