/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.e.manage;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.core.domain.ResponseStateEnum;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.converter.EDeviceConverter;
import cn.smarthse.rho.modules.company.dao.e.EdeviceMapper;
import cn.smarthse.rho.modules.company.service.b.IBCompanyErrorDeviceService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceRayService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceSourceService;
import cn.smarthse.rho.modules.company.service.e.IEsourceNonSealedService;
import cn.smarthse.rho.modules.company.service.e.IEsourceSealedService;
import cn.smarthse.rho.modules.company.service.e.manage.IEDeviceManageService;
import cn.smarthse.rho.modules.sys.entity.e.EDevice;
import cn.smarthse.rho.modules.sys.entity.e.EDeviceRay;
import cn.smarthse.rho.modules.sys.entity.e.EDeviceSource;
import cn.smarthse.rho.modules.sys.entity.e.ESourceNonSealed;
import cn.smarthse.rho.modules.sys.entity.e.ESourceSealed;
import cn.smarthse.rho.modules.sys.entity.sys.SysDeviceCategory;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceDiagnosisTypeEnum;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceLicenseStatusEnum;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceLicenseStatusTypeEnum;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceRayCheckTypeEnum;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceTypeEnum;
import cn.smarthse.rho.modules.sys.enums.lock.DistributedLockEnum;
import cn.smarthse.rho.modules.sys.model.easyexcel.device.DeviceRayImportDto;
import cn.smarthse.rho.modules.sys.model.easyexcel.device.DeviceSourceImportDto;
import cn.smarthse.rho.modules.sys.model.easyexcel.device.SourceNonSealedImportDto;
import cn.smarthse.rho.modules.sys.model.easyexcel.device.SourceSealedImportDto;
import cn.smarthse.rho.modules.sys.model.easyexcel.device.TransformedDeviceImportDto;
import cn.smarthse.rho.modules.sys.model.sys.param.SysElementListParam;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysParamVo;
import cn.smarthse.rho.modules.sys.provider.sys.ISysDeviceCategoryProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysElementProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysParamProvider;
import cn.smarthse.rho.modules.sys.utils.NeutronNameUtil;
import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class EDeviceManageServiceImpl
implements IEDeviceManageService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EDeviceManageServiceImpl.class);
    private final RedissonClient redissonClient;
    @Autowired
    private EDeviceConverter deviceConverter;
    @Autowired
    private IEdeviceService deviceService;
    @Autowired
    private IEdeviceRayService rayService;
    @Autowired
    private IEdeviceSourceService deviceSourceService;
    @Autowired
    private IEsourceNonSealedService sourceNonSealedService;
    @Autowired
    private IEsourceSealedService sourceSealedService;
    @DubboReference
    private ISysParamProvider sysParamProvider;
    @DubboReference
    private ISysElementProvider sysElementProvider;
    @DubboReference
    private ISysDeviceCategoryProvider deviceCategoryProvider;
    @Autowired
    private IBCompanyErrorDeviceService deviceErrorService;
    @Autowired
    private EdeviceMapper edeviceMapper;
    private static final String DATE_PATTERN = "^\\d{4}[-/]\\d{1,2}[-/]\\d{1,2}$";
    private static final String[] DATE_FORMATS = new String[]{"yyyy-MM-dd", "yyyy/MM/dd"};

    @Override
    public Boolean judgeDeviceExistByFactoryNo(String factoryNo) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(EDevice::getFactoryNo, (Object)factoryNo)).eq(BaseEntity::getIsValid, (Object)1)).last("limit 1")).select(new SFunction[]{EDevice::getId});
        EDevice device = (EDevice)this.deviceService.getOne((Wrapper)wrapper);
        return device != null;
    }

    @Override
    @Transactional
    public void importDeviceRay(List<DeviceRayImportDto> importDataList) {
        StringBuilder sb = new StringBuilder(DistributedLockEnum.IMPORT_DEVICE_BATCH.getKey()).append(ShiroUtil.getLoginUserCid());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(60L, 60L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.importDeviceRayLock(importDataList);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw e;
            }
            finally {
                if (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:importStaff()", (Object)sb);
            throw new ServiceException("\u6574\u4f53\u8d85\u65f6");
        }
    }

    @Transactional
    public void importDeviceRayLock(List<DeviceRayImportDto> importList) {
        this.checkDeviceRayImportInfoList(importList);
        List<TransformedDeviceImportDto> transformedDataList = this.transformImportInfoList(importList);
        transformedDataList.stream().forEach(transformedDto -> {
            EDevice deviceBase = transformedDto.getDeviceBase();
            deviceBase.setOutId(IdWorker.get32UUID());
            this.deviceService.save(deviceBase);
            EDeviceRay deviceRay = transformedDto.getDeviceRay();
            this.rayService.save(deviceRay);
            Boolean hasError = this.deviceErrorService.checkErrorForDevice(deviceBase);
            if (hasError.booleanValue()) {
                deviceBase.setInformationStatus(Integer.valueOf(0));
                this.deviceService.updateById(deviceBase);
            } else {
                deviceBase.setInformationStatus(Integer.valueOf(1));
                this.deviceService.updateById(deviceBase);
            }
            this.edeviceMapper.updateCompanyDeviceError(ShiroUtil.getLoginUserCid());
        });
    }

    public void checkDeviceRayImportInfoList(List<DeviceRayImportDto> importList) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<DeviceRayImportDto> errorInfoList = new ArrayList<DeviceRayImportDto>();
        int rowIndex = 4;
        for (DeviceRayImportDto importDto : importList) {
            StringBuilder sb = new StringBuilder();
            if (StrUtil.isBlank((CharSequence)importDto.getName())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getFactoryNo())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getParameters())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u4e3b\u8981\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getFactory())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u751f\u4ea7\u5382\u5bb6\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getModel())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getStatusStr())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!(importDto.getStatusStr().equals("\u6b63\u5e38") || importDto.getStatusStr().equals("\u6682\u505c\u4f7f\u7528") || importDto.getStatusStr().equals("\u9000\u5f79\u62a5\u5e9f"))) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u72b6\u6001\u53ea\u80fd\u4e3a\"\u6b63\u5e38\u3001\u6682\u505c\u4f7f\u7528\u3001\u9000\u5f79\u62a5\u5e9f\"\u5176\u4e2d\u7684\u4e00\u9879\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getMobilityTypeStr())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!(importDto.getMobilityTypeStr().equals("\u56fa\u5b9a\u8bbe\u5907") || importDto.getMobilityTypeStr().equals("\u79fb\u52a8\u8bbe\u5907\uff1a\u5e8a\u8fb9\u673a") || importDto.getMobilityTypeStr().equals("\u79fb\u52a8\u8bbe\u5907\uff1a\u975e\u5e8a\u8fb9\u673a") || importDto.getMobilityTypeStr().equals("\u8f66\u8f7d\u8bbe\u5907"))) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u7c7b\u578b\u53ea\u80fd\u4e3a\"\u56fa\u5b9a\u8bbe\u5907\u3001\u79fb\u52a8\u8bbe\u5907\uff1a\u5e8a\u8fb9\u673a\u3001\u79fb\u52a8\u8bbe\u5907\uff1a\u975e\u5e8a\u8fb9\u673a\u3001\u8f66\u8f7d\u8bbe\u5907\"\u5176\u4e2d\u7684\u4e00\u9879\n", rowIndex));
            }
            this.validateDeviceCategory(importDto, sb, rowIndex);
            if (StrUtil.isBlank((CharSequence)importDto.getCheckTypeStr())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u653e\u5c04\u68c0\u67e5\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else {
                if (!(!importDto.getCategoryStr1().equals("X\u5c04\u7ebf\u5f71\u50cf\u8bca\u65ad") || importDto.getCheckTypeStr().equals(EdeviceRayCheckTypeEnum.XRAY_DIFF_ROOM.getName()) || importDto.getCheckTypeStr().equals(EdeviceRayCheckTypeEnum.XRAY_SAME_ROOM.getName()) || importDto.getCheckTypeStr().equals(EdeviceRayCheckTypeEnum.XRAY_TEETH.getName()) || importDto.getCheckTypeStr().equals(EdeviceRayCheckTypeEnum.CT_TEETH.getName()) || importDto.getCheckTypeStr().equals(EdeviceRayCheckTypeEnum.CT_BODY_SCAN.getName()) || importDto.getCheckTypeStr().equals(EdeviceRayCheckTypeEnum.BEDSIDE_PHOTOGRAPHY.getName()) || importDto.getCheckTypeStr().equals(EdeviceRayCheckTypeEnum.ORTHOPEDIC_REDUCTION.getName()))) {
                    sb.append(String.format("\u7b2c%s\u884c\uff0c\u653e\u5c04\u68c0\u67e5\u7c7b\u578b\u6709\u8bef\n", rowIndex));
                }
                if (importDto.getCategoryStr1().equals("\u4ecb\u5165\u653e\u5c04\u5b66") && !importDto.getCheckTypeStr().equals(EdeviceRayCheckTypeEnum.DEVICE_RAY.getName())) {
                    sb.append(String.format("\u7b2c%s\u884c\uff0c\u653e\u5c04\u68c0\u67e5\u7c7b\u578b\u6709\u8bef\n", rowIndex));
                }
            }
            if (!StrUtil.isBlank((CharSequence)importDto.getBulbNum()) && !importDto.getBulbNum().matches("^[0-9]+$")) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u7403\u7ba1\u4e2a\u6570\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u586b\u5199\u6574\u6570\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getProductionDate())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u51fa\u5382\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!this.isValidDateForImport(importDto.getProductionDate())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u51fa\u5382\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e,\u8bf7\u6309\u7167\u6a21\u677f\u4e2d\u63d0\u4f9b\u7684\u683c\u5f0f\u8fdb\u884c\u586b\u5199\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getPersonInCharge())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a", rowIndex));
            }
            if (sb.length() > 0) {
                importDto.setRowIndex(Integer.valueOf(rowIndex));
                importDto.setHaveError(Boolean.valueOf(true));
                importDto.setErrorReason(sb.toString());
                errorInfoList.add(importDto);
            }
            ++rowIndex;
        }
        if (errorInfoList.size() > 0) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u6839\u636e\u9519\u8bef\u4fe1\u606f\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165", (Object)JSON.toJSONString(errorInfoList));
        }
    }

    public List<TransformedDeviceImportDto> transformImportInfoList(List<DeviceRayImportDto> importList) {
        ArrayList<TransformedDeviceImportDto> resultList = new ArrayList<TransformedDeviceImportDto>();
        for (DeviceRayImportDto importDto : importList) {
            TransformedDeviceImportDto transformedDto = new TransformedDeviceImportDto();
            EDevice deviceBase = this.deviceConverter.importDto2BaseEntity(importDto);
            deviceBase.setId(Long.valueOf(IdWorker.getId()));
            deviceBase.setCid(ShiroUtil.getLoginUserCid());
            deviceBase.setType(EdeviceTypeEnum.DEVICE_RAY.getValue());
            deviceBase.setLicenseStatus(EdeviceLicenseStatusEnum.UNAUTHORIZED.getValue());
            deviceBase.setLicenseStatusType(EdeviceLicenseStatusTypeEnum.NONE.getValue());
            deviceBase.setCreateBy(ShiroUtil.getJWTUserId());
            EDeviceRay deviceRay = this.deviceConverter.importDto2RayEntity(importDto);
            deviceRay.setId(Long.valueOf(IdWorker.getId()));
            deviceRay.setDid(deviceBase.getId());
            deviceRay.setCid(ShiroUtil.getLoginUserCid());
            deviceRay.setCreateBy(ShiroUtil.getJWTUserId());
            deviceRay.setProductionDate(EDeviceManageServiceImpl.convertStringToDateForImport(importDto.getProductionDate()));
            SysDeviceCategory param = new SysDeviceCategory();
            param.setLevel1(importDto.getCategoryStr1());
            param.setLevel2(importDto.getCategoryStr2());
            param.setLevel3(importDto.getCategoryStr3());
            deviceRay.setCategory(this.deviceCategoryProvider.findByLevelAndName(param).getId());
            deviceRay.setDiagnosisType(Objects.requireNonNull(EdeviceDiagnosisTypeEnum.getCodeByName((String)importDto.getCategoryStr2())).toString());
            transformedDto.setDeviceBase(deviceBase);
            transformedDto.setDeviceRay(deviceRay);
            resultList.add(transformedDto);
        }
        return resultList;
    }

    @Override
    @Transactional
    public void importDeviceSource(List<DeviceSourceImportDto> importDataList) {
        StringBuilder sb = new StringBuilder(DistributedLockEnum.IMPORT_DEVICE_BATCH.getKey()).append(ShiroUtil.getLoginUserCid());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(60L, 60L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.importDeviceSourceLock(importDataList);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw e;
            }
            finally {
                if (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:importStaff()", (Object)sb);
            throw new ServiceException("\u6574\u4f53\u8d85\u65f6");
        }
    }

    @Transactional
    public void importDeviceSourceLock(List<DeviceSourceImportDto> importList) {
        this.checkDeviceSourceImportData(importList);
        List<TransformedDeviceImportDto> transformedDataList = this.transformDeviceSourceImportData(importList);
        transformedDataList.stream().forEach(transformedDto -> {
            EDevice deviceBase = transformedDto.getDeviceBase();
            deviceBase.setOutId(IdWorker.get32UUID());
            this.deviceService.save(deviceBase);
            EDeviceSource deviceSource = transformedDto.getDeviceSource();
            this.deviceSourceService.save(deviceSource);
            Boolean hasError = this.deviceErrorService.checkErrorForDevice(deviceBase);
            if (hasError.booleanValue()) {
                deviceBase.setInformationStatus(Integer.valueOf(0));
                this.deviceService.updateById(deviceBase);
            } else {
                deviceBase.setInformationStatus(Integer.valueOf(1));
                this.deviceService.updateById(deviceBase);
            }
            this.edeviceMapper.updateCompanyDeviceError(ShiroUtil.getLoginUserCid());
        });
    }

    public void checkDeviceSourceImportData(List<DeviceSourceImportDto> importList) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<DeviceSourceImportDto> errorInfoList = new ArrayList<DeviceSourceImportDto>();
        int rowIndex = 4;
        for (DeviceSourceImportDto importDto : importList) {
            StringBuilder sb = new StringBuilder();
            if (StrUtil.isBlank((CharSequence)importDto.getName())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getFactoryNo())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getModel())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u578b\u53f7\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getFactory())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u751f\u4ea7\u5382\u5bb6\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getDiagnosisTypeStr())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u653e\u5c04\u8bca\u7597\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!(importDto.getDiagnosisTypeStr().equals("X\u5c04\u7ebf\u5f71\u50cf\u8bca\u65ad") || importDto.getDiagnosisTypeStr().equals("\u4ecb\u5165\u653e\u5c04\u5b66") || importDto.getDiagnosisTypeStr().equals("\u6838\u533b\u5b66") || importDto.getDiagnosisTypeStr().equals("\u653e\u5c04\u6cbb\u7597"))) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u653e\u5c04\u8bca\u7597\u7c7b\u522b\u53ea\u80fd\u4e3a\"X\u5c04\u7ebf\u5f71\u50cf\u8bca\u65ad\u3001\u4ecb\u5165\u653e\u5c04\u5b66\u3001\u6838\u533b\u5b66\u3001\u653e\u5c04\u6cbb\u7597\"\u5176\u4e2d\u7684\u4e00\u9879\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getStatusStr())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!(importDto.getStatusStr().equals("\u6b63\u5e38") || importDto.getStatusStr().equals("\u6682\u505c\u4f7f\u7528") || importDto.getStatusStr().equals("\u9000\u5f79\u62a5\u5e9f"))) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8bbe\u5907\u72b6\u6001\u53ea\u80fd\u4e3a\"\u6b63\u5e38\u3001\u6682\u505c\u4f7f\u7528\u3001\u9000\u5f79\u62a5\u5e9f\"\u5176\u4e2d\u7684\u4e00\u9879\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getPersonInCharge())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (sb.length() > 0) {
                importDto.setRowIndex(Integer.valueOf(rowIndex));
                importDto.setHaveError(Boolean.valueOf(true));
                importDto.setErrorReason(sb.toString());
                errorInfoList.add(importDto);
            }
            ++rowIndex;
        }
        if (errorInfoList.size() > 0) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u6839\u636e\u9519\u8bef\u4fe1\u606f\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165", (Object)JSON.toJSONString(errorInfoList));
        }
    }

    public List<TransformedDeviceImportDto> transformDeviceSourceImportData(List<DeviceSourceImportDto> importList) {
        ArrayList<TransformedDeviceImportDto> resultList = new ArrayList<TransformedDeviceImportDto>();
        for (DeviceSourceImportDto importDto : importList) {
            TransformedDeviceImportDto transformedDto = new TransformedDeviceImportDto();
            EDevice deviceBase = this.deviceConverter.importDto2BaseEntity(importDto);
            deviceBase.setId(Long.valueOf(IdWorker.getId()));
            deviceBase.setCid(ShiroUtil.getLoginUserCid());
            deviceBase.setType(EdeviceTypeEnum.DEVICE_SOURCE.getValue());
            deviceBase.setLicenseStatus(EdeviceLicenseStatusEnum.UNAUTHORIZED.getValue());
            deviceBase.setLicenseStatusType(EdeviceLicenseStatusTypeEnum.NONE.getValue());
            deviceBase.setCreateBy(ShiroUtil.getJWTUserId());
            EDeviceSource deviceSource = this.deviceConverter.importDto2DeviceSourceEntity(importDto);
            deviceSource.setId(Long.valueOf(IdWorker.getId()));
            deviceSource.setDid(deviceBase.getId());
            deviceSource.setCid(ShiroUtil.getLoginUserCid());
            deviceSource.setCreateBy(ShiroUtil.getJWTUserId());
            transformedDto.setDeviceBase(deviceBase);
            transformedDto.setDeviceSource(deviceSource);
            resultList.add(transformedDto);
        }
        return resultList;
    }

    @Override
    @Transactional
    public void importSourceNonSealed(List<SourceNonSealedImportDto> importDataList) {
        StringBuilder sb = new StringBuilder(DistributedLockEnum.IMPORT_DEVICE_BATCH.getKey()).append(ShiroUtil.getLoginUserCid());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(60L, 60L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.importSourceNonSealedLock(importDataList);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw e;
            }
            finally {
                if (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:importStaff()", (Object)sb);
            throw new ServiceException("\u6574\u4f53\u8d85\u65f6");
        }
    }

    @Transactional
    public void importSourceNonSealedLock(List<SourceNonSealedImportDto> importDataList) {
        this.checkSourceNonSealedImportData(importDataList);
        List<TransformedDeviceImportDto> transformedDataList = this.transformSourceNonSealedImportData(importDataList);
        transformedDataList.stream().forEach(transformedDto -> {
            EDevice deviceBase = transformedDto.getDeviceBase();
            deviceBase.setOutId(IdWorker.get32UUID());
            this.deviceService.save(deviceBase);
            ESourceNonSealed sourceNonSealed = transformedDto.getSourceNonSealed();
            this.sourceNonSealedService.save(sourceNonSealed);
            Boolean hasError = this.deviceErrorService.checkErrorForDevice(deviceBase);
            if (hasError.booleanValue()) {
                deviceBase.setInformationStatus(Integer.valueOf(0));
                this.deviceService.updateById(deviceBase);
            } else {
                deviceBase.setInformationStatus(Integer.valueOf(1));
                this.deviceService.updateById(deviceBase);
            }
            this.edeviceMapper.updateCompanyDeviceError(ShiroUtil.getLoginUserCid());
        });
    }

    public void checkSourceNonSealedImportData(List<SourceNonSealedImportDto> importList) {
        ArrayList<SourceNonSealedImportDto> errorInfoList = new ArrayList<SourceNonSealedImportDto>();
        int rowIndex = 4;
        for (SourceNonSealedImportDto importDto : importList) {
            StringBuilder sb = new StringBuilder();
            if (StrUtil.isBlank((CharSequence)importDto.getName())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6838\u7d20\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!this.judgeSourceName(importDto.getName())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6838\u7d20\u540d\u79f0\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u6838\u7d20\u540d\u79f0\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getPhysicalStateStr())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u7269\u7406\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!(importDto.getPhysicalStateStr().equals("\u56fa\u6001") || importDto.getPhysicalStateStr().equals("\u6db2\u6001") || importDto.getPhysicalStateStr().equals("\u6c14\u6001"))) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u7269\u7406\u72b6\u6001\u53ea\u80fd\u4e3a\"\u56fa\u6001\u3001\u6db2\u6001\u3001\u6c14\u6001\"\u5176\u4e2d\u7684\u4e00\u9879\n", rowIndex));
            }
            if (!StrUtil.isBlank((CharSequence)importDto.getFactoryActivity()) && !importDto.getFactoryActivity().contains("\u00d710^")) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u51fa\u5382\u6d3b\u5ea6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\"\u6570\u5b57\u00d710^\u6570\u5b57\"\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getMaxDailyDose())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6700\u5927\u7b49\u6548\u65e5\u64cd\u4f5c\u91cf\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!importDto.getMaxDailyDose().contains("\u00d710^")) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6700\u5927\u7b49\u6548\u65e5\u64cd\u4f5c\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\"\u6570\u5b57\u00d710^\u6570\u5b57\"\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getMaxYearDose())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6700\u5927\u7b49\u6548\u5e74\u64cd\u4f5c\u91cf\u4e0d\u80fd\u4e3a\u7a7a", rowIndex));
            } else if (!importDto.getMaxYearDose().contains("\u00d710^")) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6700\u5927\u7b49\u6548\u5e74\u64cd\u4f5c\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\"\u6570\u5b57\u00d710^\u6570\u5b57\"\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getPersonInCharge())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (sb.length() > 0) {
                importDto.setRowIndex(Integer.valueOf(rowIndex));
                importDto.setHaveError(Boolean.valueOf(true));
                importDto.setErrorReason(sb.toString());
                errorInfoList.add(importDto);
            }
            ++rowIndex;
        }
        if (errorInfoList.size() > 0) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u6839\u636e\u9519\u8bef\u4fe1\u606f\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165", (Object)JSON.toJSONString(errorInfoList));
        }
    }

    public List<TransformedDeviceImportDto> transformSourceNonSealedImportData(List<SourceNonSealedImportDto> importList) {
        ArrayList<TransformedDeviceImportDto> resultList = new ArrayList<TransformedDeviceImportDto>();
        List paramList = this.sysParamProvider.getList(Long.valueOf(201L));
        Map<String, String> paramSourceNameMap = paramList.stream().collect(Collectors.toMap(vo -> vo.getName().replaceAll("[^a-zA-Z]", ""), SysParamVo::getName));
        for (SourceNonSealedImportDto importDto : importList) {
            TransformedDeviceImportDto transformedDto = new TransformedDeviceImportDto();
            String[] nameArray = importDto.getName().split("-");
            EDevice deviceBase = this.deviceConverter.importDto2BaseEntity(importDto);
            deviceBase.setId(Long.valueOf(IdWorker.getId()));
            deviceBase.setCid(ShiroUtil.getLoginUserCid());
            deviceBase.setName(NeutronNameUtil.formatName((String)nameArray[0], (String)nameArray[1], (String)""));
            deviceBase.setType(EdeviceTypeEnum.SOURCE_NON_SEALED.getValue());
            deviceBase.setLicenseStatus(EdeviceLicenseStatusEnum.UNAUTHORIZED.getValue());
            deviceBase.setLicenseStatusType(EdeviceLicenseStatusTypeEnum.NONE.getValue());
            deviceBase.setStatus(Integer.valueOf(1));
            deviceBase.setCreateBy(ShiroUtil.getJWTUserId());
            ESourceNonSealed sourceNonSealed = this.deviceConverter.importDto2SourceNonSealedEntity(importDto);
            sourceNonSealed.setId(Long.valueOf(IdWorker.getId()));
            sourceNonSealed.setDid(deviceBase.getId());
            sourceNonSealed.setCid(ShiroUtil.getLoginUserCid());
            sourceNonSealed.setCreateBy(ShiroUtil.getJWTUserId());
            transformedDto.setDeviceBase(deviceBase);
            transformedDto.setSourceNonSealed(sourceNonSealed);
            resultList.add(transformedDto);
        }
        return resultList;
    }

    @Override
    @Transactional
    public void importSourceSealed(List<SourceSealedImportDto> importDataList) {
        StringBuilder sb = new StringBuilder(DistributedLockEnum.IMPORT_DEVICE_BATCH.getKey()).append(ShiroUtil.getLoginUserCid());
        RLock lock = this.redissonClient.getLock(sb.toString());
        boolean resLock = false;
        try {
            resLock = lock.tryLock(60L, 60L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.importSourceSealedLock(importDataList);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw e;
            }
            finally {
                if (lock.isHeldByCurrentThread()) {
                    lock.unlock();
                }
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:importStaff()", (Object)sb);
            throw new ServiceException("\u6574\u4f53\u8d85\u65f6");
        }
    }

    @Transactional
    public void importSourceSealedLock(List<SourceSealedImportDto> importDataList) {
        this.checkSourceSealedImportData(importDataList);
        List<TransformedDeviceImportDto> transformedDataList = this.transformSourceSealedImportData(importDataList);
        transformedDataList.stream().forEach(transformedDto -> {
            EDevice deviceBase = transformedDto.getDeviceBase();
            deviceBase.setOutId(IdWorker.get32UUID());
            this.deviceService.save(deviceBase);
            ESourceSealed sourceSealed = transformedDto.getSourceSealed();
            this.sourceSealedService.save(sourceSealed);
            Boolean hasError = this.deviceErrorService.checkErrorForDevice(deviceBase);
            if (hasError.booleanValue()) {
                deviceBase.setInformationStatus(Integer.valueOf(0));
                this.deviceService.updateById(deviceBase);
            } else {
                deviceBase.setInformationStatus(Integer.valueOf(1));
                this.deviceService.updateById(deviceBase);
            }
            this.edeviceMapper.updateCompanyDeviceError(ShiroUtil.getLoginUserCid());
        });
    }

    public void checkSourceSealedImportData(List<SourceSealedImportDto> importList) {
        ArrayList<SourceSealedImportDto> errorInfoList = new ArrayList<SourceSealedImportDto>();
        int rowIndex = 4;
        for (SourceSealedImportDto importDto : importList) {
            StringBuilder sb = new StringBuilder();
            if (StrUtil.isBlank((CharSequence)importDto.getName())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6838\u7d20\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!this.judgeSourceName(importDto.getName())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6838\u7d20\u540d\u79f0\u4e0d\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u6838\u7d20\u540d\u79f0\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getFactory())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6838\u7d20\u751f\u4ea7\u5382\u5bb6\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getStatusStr())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u653e\u5c04\u6e90\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!(importDto.getStatusStr().equals("\u6b63\u5e38") || importDto.getStatusStr().equals("\u6682\u505c\u4f7f\u7528") || importDto.getStatusStr().equals("\u9000\u5f79\u62a5\u5e9f"))) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u653e\u5c04\u6e90\u72b6\u6001\u53ea\u80fd\u4e3a\"\u6b63\u5e38\u3001\u6682\u505c\u4f7f\u7528\u3001\u9000\u5f79\u62a5\u5e9f\"\u5176\u4e2d\u7684\u4e00\u9879\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getUseTo())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getFactoryActivity())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u51fa\u5382\u6d3b\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!importDto.getFactoryActivity().contains("\u00d710^")) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u51fa\u5382\u6d3b\u5ea6\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u8f93\u5165\"\u6570\u5b57\u00d710^\u6570\u5b57\"\n", rowIndex));
            }
            if (importDto.getMeasurementDate() == null) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6d3b\u5ea6\u6d4b\u91cf\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            } else if (!this.isValidDateForImport(importDto.getMeasurementDate())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u6d3b\u5ea6\u6d4b\u91cf\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u6309\u7167\u6a21\u677f\u4e2d\u63d0\u4f9b\u7684\u683c\u5f0f\u8fdb\u884c\u586b\u5199\n", rowIndex));
            }
            if (importDto.getProductionDate() != null && !this.isValidDateForImport(importDto.getProductionDate())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u51fa\u5382\u65e5\u671f\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u6309\u7167\u6a21\u677f\u4e2d\u63d0\u4f9b\u7684\u683c\u5f0f\u8fdb\u884c\u586b\u5199\n", rowIndex));
            }
            if (StrUtil.isBlank((CharSequence)importDto.getPersonInCharge())) {
                sb.append(String.format("\u7b2c%s\u884c\uff0c\u8d1f\u8d23\u4eba\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            }
            if (sb.length() > 0) {
                importDto.setRowIndex(Integer.valueOf(rowIndex));
                importDto.setHaveError(Boolean.valueOf(true));
                importDto.setErrorReason(sb.toString());
                errorInfoList.add(importDto);
            }
            ++rowIndex;
        }
        if (errorInfoList.size() > 0) {
            throw new ServiceException(ResponseStateEnum.fail_deal.getValue(), "\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u6839\u636e\u9519\u8bef\u4fe1\u606f\u4fee\u6539\u540e\u91cd\u65b0\u5bfc\u5165", (Object)JSON.toJSONString(errorInfoList));
        }
    }

    private boolean judgeSourceName(String name) {
        List elementList = this.sysElementProvider.listNeutronsByProton(new SysElementListParam());
        return elementList.stream().anyMatch(element -> (element.getSymbol() + "-" + element.getNeutrons()).equals(name));
    }

    public List<TransformedDeviceImportDto> transformSourceSealedImportData(List<SourceSealedImportDto> importList) {
        ArrayList<TransformedDeviceImportDto> resultList = new ArrayList<TransformedDeviceImportDto>();
        List paramList = this.sysParamProvider.getList(Long.valueOf(201L));
        Map<String, String> paramSourceNameMap = paramList.stream().collect(Collectors.toMap(vo -> vo.getName().replaceAll("[^a-zA-Z]", ""), SysParamVo::getName));
        for (SourceSealedImportDto importDto : importList) {
            TransformedDeviceImportDto transformedDto = new TransformedDeviceImportDto();
            String[] nameArray = importDto.getName().split("-");
            EDevice deviceBase = this.deviceConverter.importDto2BaseEntity(importDto);
            deviceBase.setId(Long.valueOf(IdWorker.getId()));
            deviceBase.setCid(ShiroUtil.getLoginUserCid());
            deviceBase.setName(NeutronNameUtil.formatName((String)nameArray[0], (String)nameArray[1], (String)""));
            deviceBase.setType(EdeviceTypeEnum.SOURCE_SEALED.getValue());
            deviceBase.setLicenseStatus(EdeviceLicenseStatusEnum.UNAUTHORIZED.getValue());
            deviceBase.setLicenseStatusType(EdeviceLicenseStatusTypeEnum.NONE.getValue());
            deviceBase.setStatus(Integer.valueOf(1));
            deviceBase.setCreateBy(ShiroUtil.getJWTUserId());
            ESourceSealed sourceSealed = this.deviceConverter.importDto2SourceSealedEntity(importDto);
            sourceSealed.setId(Long.valueOf(IdWorker.getId()));
            sourceSealed.setDid(deviceBase.getId());
            sourceSealed.setCid(ShiroUtil.getLoginUserCid());
            sourceSealed.setCreateBy(ShiroUtil.getJWTUserId());
            sourceSealed.setMeasurementDate(EDeviceManageServiceImpl.convertStringToDateForImport(importDto.getMeasurementDate()));
            sourceSealed.setProductionDate(EDeviceManageServiceImpl.convertStringToDateForImport(importDto.getProductionDate()));
            transformedDto.setDeviceBase(deviceBase);
            transformedDto.setSourceSealed(sourceSealed);
            resultList.add(transformedDto);
        }
        return resultList;
    }

    public boolean isValidDateForImport(String dateStr) {
        Pattern pattern = Pattern.compile(DATE_PATTERN);
        Matcher matcher = pattern.matcher(dateStr);
        return matcher.matches();
    }

    public static Date convertStringToDateForImport(String dateStr) {
        if (dateStr == null) {
            return null;
        }
        Boolean isSuccess = true;
        for (String format : DATE_FORMATS) {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            sdf.setLenient(false);
            try {
                return sdf.parse(dateStr);
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    void validateDeviceCategory(DeviceRayImportDto importDto, StringBuilder sb, int rowIndex) {
        String categoryStr1 = importDto.getCategoryStr1();
        String categoryStr2 = importDto.getCategoryStr2();
        String categoryStr3 = importDto.getCategoryStr3();
        if (StrUtil.isBlank((CharSequence)categoryStr1)) {
            sb.append(String.format("\u7b2c%s\u884c\uff0c\u88c5\u7f6e\u7c7b\u578b\u4e00\u7ea7\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            return;
        }
        if (!(importDto.getCategoryStr1().equals(EdeviceDiagnosisTypeEnum.XRAY.getName()) || importDto.getCategoryStr1().equals(EdeviceDiagnosisTypeEnum.INTERVENTIONAL.getName()) || importDto.getCategoryStr1().equals(EdeviceDiagnosisTypeEnum.NUCLEAR.getName()) || importDto.getCategoryStr1().equals(EdeviceDiagnosisTypeEnum.RADIATION_THERAPY.getName()))) {
            sb.append(String.format("\u7b2c%s\u884c\uff0c\u88c5\u7f6e\u7c7b\u578b\u4e00\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728\n", rowIndex));
        }
        if (StrUtil.isBlank((CharSequence)categoryStr2)) {
            sb.append(String.format("\u7b2c%s\u884c\uff0c\u88c5\u7f6e\u7c7b\u578b\u4e8c\u7ea7\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            return;
        }
        SysDeviceCategory categoryLevel2 = this.deviceCategoryProvider.findByLevelAndName(Integer.valueOf(2), categoryStr2);
        if (categoryLevel2 == null) {
            sb.append(String.format("\u7b2c%s\u884c\uff0c\u88c5\u7f6e\u7c7b\u578b\u4e8c\u7ea7\u5206\u7c7b\u4e0d\u5b58\u5728\n", rowIndex));
            return;
        }
        if (!categoryLevel2.getLevel1().equals(categoryStr1)) {
            sb.append(String.format("\u7b2c%s\u884c\uff0c\u88c5\u7f6e\u7c7b\u578b\u4e8c\u7ea7\u5206\u7c7b\u4e0d\u5c5e\u4e8e\u5f53\u524d\u4e00\u7ea7\u5206\u7c7b\n", rowIndex));
            return;
        }
        if (StrUtil.isBlank((CharSequence)categoryStr3)) {
            sb.append(String.format("\u7b2c%s\u884c\uff0c\u88c5\u7f6e\u7c7b\u578b\u4e09\u7ea7\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\n", rowIndex));
            return;
        }
        SysDeviceCategory param = new SysDeviceCategory();
        param.setLevel1(categoryStr1);
        param.setLevel2(categoryStr2);
        param.setLevel3(categoryStr3);
        SysDeviceCategory categoryLevel3 = this.deviceCategoryProvider.findByLevelAndName(param);
        if (categoryLevel3 == null) {
            sb.append(String.format("\u7b2c%s\u884c\uff0c\u88c5\u7f6e\u7c7b\u578b\u4e09\u7ea7\u5206\u7c7b\u6709\u8bef\n", rowIndex));
            return;
        }
    }

    @Generated
    public EDeviceManageServiceImpl(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

