/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.e;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.Constant;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.core.framework.mybatis.SysChangeLog;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.converter.EDeviceConverter;
import cn.smarthse.rho.modules.company.converter.ERelationConverter;
import cn.smarthse.rho.modules.company.dao.e.EdeviceMapper;
import cn.smarthse.rho.modules.company.service.b.IBCompanyErrorDeviceService;
import cn.smarthse.rho.modules.company.service.b.IBOrgService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceFactoryService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceRayService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceRoomChangeLogService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceSourceService;
import cn.smarthse.rho.modules.company.service.e.IEmachineRoomService;
import cn.smarthse.rho.modules.company.service.e.IErelationService;
import cn.smarthse.rho.modules.company.service.e.IEsourceNonSealedService;
import cn.smarthse.rho.modules.company.service.e.IEsourceSealedService;
import cn.smarthse.rho.modules.company.service.f.manage.IFProjectManageService;
import cn.smarthse.rho.modules.sys.entity.e.EDevice;
import cn.smarthse.rho.modules.sys.entity.e.EDeviceRay;
import cn.smarthse.rho.modules.sys.entity.e.EMachineRoom;
import cn.smarthse.rho.modules.sys.entity.e.ERelation;
import cn.smarthse.rho.modules.sys.entity.e.ESourceNonSealed;
import cn.smarthse.rho.modules.sys.entity.e.ESourceSealed;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceLicenseStatusEnum;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.BCompanyErrorDeviceCodeEnum;
import cn.smarthse.rho.modules.sys.model.b.param.license.BChangeLicenseDeviceParam;
import cn.smarthse.rho.modules.sys.model.e.param.EDeviceDetailParam;
import cn.smarthse.rho.modules.sys.model.e.param.EDeviceDto;
import cn.smarthse.rho.modules.sys.model.e.param.EDeviceListParam;
import cn.smarthse.rho.modules.sys.model.e.param.ERelationDto;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceBaseVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceCurBindDeviceVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceCurBindSourceVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceErrorInfoVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceForLicenseVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceHistorySourceVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceLicenseOptLogVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceListDetailVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceListVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDevicePerformanceCheckVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceRayVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceRoomForSealedVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceSourceVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceStatisticVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceThreeProjectVo;
import cn.smarthse.rho.modules.sys.model.e.vo.ESourceBindDeviceVo;
import cn.smarthse.rho.modules.sys.model.e.vo.ESourceBindRoomVo;
import cn.smarthse.rho.modules.sys.model.e.vo.ESourceNonSealedVo;
import cn.smarthse.rho.modules.sys.model.e.vo.ESourceSealedVo;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysDeviceCategoryProvider;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class EdeviceServiceImpl
extends ServiceImpl<EdeviceMapper, EDevice>
implements IEdeviceService {
    @Autowired
    private IEdeviceRayService deviceRayService;
    @Autowired
    private IEsourceNonSealedService sourceNonSealedService;
    @Autowired
    private IEsourceSealedService sourceSealedService;
    @Autowired
    private IEdeviceSourceService deviceSourceService;
    @Autowired
    private IEdeviceRoomChangeLogService roomChangeLogService;
    @Autowired
    private IErelationService relationService;
    @Autowired
    private IBOrgService bOrgService;
    @Autowired
    private IEmachineRoomService roomService;
    @Autowired
    private IBCompanyErrorDeviceService deviceErrorService;
    @Autowired
    private IFProjectManageService projectManageService;
    @DubboReference
    private IRiskProvider riskProvider;
    @DubboReference
    private ISysDeviceCategoryProvider sysDeviceCategoryProvider;
    @Autowired(required=false)
    private EDeviceConverter deviceConverter;
    @Autowired(required=false)
    private ERelationConverter relationConverter;
    @Autowired
    private IEdeviceFactoryService deviceFactoryService;

    @Override
    public EDeviceStatisticVo getStatisticData(EDeviceListParam param) {
        return ((EdeviceMapper)this.baseMapper).getStatisticData(param);
    }

    @Override
    public LayuiGridData<EDeviceListVo> listDevice(EDeviceListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<EDeviceListVo> rst = ((EdeviceMapper)this.baseMapper).listDevice(param);
        rst.forEach(item -> item.setLocationName(this.relationService.getRoomNameForMobilityDevice(item.getId())));
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public EDeviceListDetailVo getDeviceDetailById(EDeviceDetailParam param) {
        if (param.getId() == null) {
            throw new RuntimeException("id\u4e3a\u7a7a\uff01");
        }
        EDevice deviceBase = (EDevice)this.getById(param.getId());
        if (deviceBase == null) {
            return null;
        }
        EDeviceListDetailVo rst = new EDeviceListDetailVo();
        EDeviceBaseVo deviceBaseVo = this.deviceConverter.baseEntity2Vo(deviceBase);
        deviceBaseVo.setUseDepartmentName(this.bOrgService.getNameByIds(deviceBaseVo.getUseDepartmentId()));
        deviceBaseVo.setLocationName(this.relationService.getRoomNameForDevice(deviceBaseVo.getId()));
        rst.setDeviceBaseVo(deviceBaseVo);
        rst.setRelationDtoList(this.relationService.listRoomRelationByDeviceId(deviceBaseVo.getId()));
        rst.setLastCheckDate(((EdeviceMapper)this.baseMapper).getLastCheckDateByDeviceId(deviceBaseVo.getId()));
        rst.setLastCheckResult(((EdeviceMapper)this.baseMapper).getLastCheckResultByDeviceId(deviceBaseVo.getId()));
        Integer type = deviceBase.getType();
        if (type == EdeviceTypeEnum.DEVICE_RAY.getValue()) {
            EDeviceRayVo rayVo = this.deviceConverter.rayEntity2Vo(this.deviceRayService.getDeviceRayByDid(param.getId()));
            rayVo.setCategoryName(this.sysDeviceCategoryProvider.getCategoryNameById(rayVo.getCategory()));
            rst.setDeviceRayVo(rayVo);
            List<EDeviceHistorySourceVo> bindSourceList = ((EdeviceMapper)this.baseMapper).listSourceByDevice(param);
            rst.setDeviceBindSourceList(bindSourceList);
        } else if (type == EdeviceTypeEnum.DEVICE_SOURCE.getValue()) {
            EDeviceSourceVo deviceSource = this.deviceConverter.deviceSourceEntity2Vo(this.deviceSourceService.getDeviceSourceByDid(param.getId()));
            rst.setDeviceSourceVo(deviceSource);
            List<EDeviceHistorySourceVo> bindSourceList = ((EdeviceMapper)this.baseMapper).listSourceByDevice(param);
            rst.setDeviceBindSourceList(bindSourceList);
        } else if (type == EdeviceTypeEnum.SOURCE_NON_SEALED.getValue()) {
            ESourceNonSealed sourceNonSealed = this.sourceNonSealedService.getNonSealedByDid(param.getId());
            ESourceNonSealedVo sourceNonSealedVo = this.deviceConverter.sourceNonEntity2Vo(sourceNonSealed);
            sourceNonSealedVo.setCurDeviceList(this.listCurBindingDevice(param.getId()));
            rst.setSourceNonSealedVo(sourceNonSealedVo);
        } else if (type == EdeviceTypeEnum.SOURCE_SEALED.getValue()) {
            ESourceSealed sourceSealed = this.sourceSealedService.getSourceSealedByDid(param.getId());
            ESourceSealedVo sourceSealedVo = this.deviceConverter.sourceSealedEntity2Vo(sourceSealed);
            sourceSealedVo.setCurDeviceList(this.listCurBindingDevice(param.getId()));
            rst.setSourceSealedVo(sourceSealedVo);
        }
        return rst;
    }

    @Override
    @Transactional
    public Long addEDevice(EDeviceDto param) {
        EDevice deviceBase = this.deviceConverter.baseDto2Entity(param.getDeviceBaseDto());
        deviceBase.setId(null);
        deviceBase.setCid(ShiroUtil.getLoginUserCid());
        deviceBase.setLicenseStatus(EdeviceLicenseStatusEnum.UNAUTHORIZED.getValue());
        deviceBase.setDataSource(Integer.valueOf(1));
        if (deviceBase.getStatus() == null) {
            deviceBase.setStatus(Integer.valueOf(1));
        }
        deviceBase.setOutId(IdWorker.get32UUID());
        this.save(deviceBase);
        param.getDeviceBaseDto().setId(deviceBase.getId());
        param.setCid(ShiroUtil.getLoginUserCid());
        Integer type = deviceBase.getType();
        if (Objects.equals(type, EdeviceTypeEnum.DEVICE_RAY.getValue())) {
            device = this.deviceConverter.rayDto2Entity(param.getDeviceRayDto());
            device.setId(null);
            device.setDid(deviceBase.getId());
            device.setCid(ShiroUtil.getLoginUserCid());
            this.deviceRayService.save(device);
            if (device.getMobilityType() == 2) {
                this.addRoomRelationForMobiltyDevice("-", param.getRelationDtoList(), deviceBase);
            } else {
                this.addRoomRelationForDevice(null, deviceBase);
            }
            try {
                this.deviceRayService.saveParametersToClickhouse(device.getParameters());
            }
            catch (Exception e) {
                this.log.error("\u4fdd\u5b58\u201c\u4e3b\u8981\u53c2\u6570\u201d\u5b57\u6bb5\u5230clickHouse\u4e2d\u5931\u8d25\uff1a{}", (Throwable)e);
            }
        } else if (Objects.equals(type, EdeviceTypeEnum.DEVICE_SOURCE.getValue())) {
            device = this.deviceConverter.deviceSourceDto2Entity(param.getDeviceSourceDto());
            device.setId(null);
            device.setDid(deviceBase.getId());
            device.setCid(ShiroUtil.getLoginUserCid());
            this.deviceSourceService.save(device);
            this.addRoomRelationForDevice(null, deviceBase);
        } else if (Objects.equals(type, EdeviceTypeEnum.SOURCE_NON_SEALED.getValue())) {
            device = this.deviceConverter.sourceNonDto2Entity(param.getSourceNonSealedDto());
            device.setId(null);
            device.setDid(deviceBase.getId());
            device.setCid(ShiroUtil.getLoginUserCid());
            this.sourceNonSealedService.save(device);
        } else if (Objects.equals(type, EdeviceTypeEnum.SOURCE_SEALED.getValue())) {
            device = this.deviceConverter.sourceSealedDto2Entity(param.getSourceSealedDto());
            device.setId(null);
            device.setDid(deviceBase.getId());
            device.setCid(ShiroUtil.getLoginUserCid());
            this.sourceSealedService.save(device);
        }
        this.deviceFactoryService.addFactory(deviceBase.getFactory());
        Boolean hasError = this.deviceErrorService.checkErrorForDevice(deviceBase);
        if (hasError.booleanValue()) {
            deviceBase.setInformationStatus(Integer.valueOf(0));
            this.updateById(deviceBase);
        } else {
            deviceBase.setInformationStatus(Integer.valueOf(1));
            this.updateById(deviceBase);
        }
        ((EdeviceMapper)this.baseMapper).updateCompanyDeviceError(ShiroUtil.getLoginUserCid());
        return deviceBase.getId();
    }

    @Override
    @Transactional
    public Long editEDevice(EDeviceDto param) {
        EDevice beforeChangeDevice = (EDevice)this.getById(param.getDeviceBaseDto().getId());
        Long paramLocationId = param.getDeviceBaseDto().getLocationId();
        EDevice deviceBase = this.deviceConverter.baseDto2Entity(param.getDeviceBaseDto());
        this.updateById(deviceBase);
        EDevice entity = (EDevice)this.getById(deviceBase.getId());
        Integer type = entity.getType();
        if (type == EdeviceTypeEnum.DEVICE_RAY.getValue()) {
            this.deviceRayService.updateById(this.deviceConverter.rayDto2Entity(param.getDeviceRayDto()));
            EDeviceRay ray = (EDeviceRay)this.deviceRayService.getById(param.getDeviceRayDto().getId());
            if (ray.getMobilityType() == 2) {
                List<ERelationDto> curRelation = this.relationService.listCurRelationByType(4, deviceBase.getId());
                this.determineAndChangeRoomRelationForMobiltyDevice(deviceBase, curRelation, param.getRelationDtoList());
            } else if (!Objects.equals(beforeChangeDevice.getLocationId(), paramLocationId)) {
                this.changeRoomRelationForDevice(beforeChangeDevice.getLocationId(), deviceBase);
            }
            try {
                this.deviceRayService.saveParametersToClickhouse(ray.getParameters());
            }
            catch (Exception e) {
                this.log.error("\u4fdd\u5b58\u201c\u4e3b\u8981\u53c2\u6570\u201d\u5b57\u6bb5\u5230clickHouse\u4e2d\u5931\u8d25\uff1a{}", (Throwable)e);
            }
        } else if (type == EdeviceTypeEnum.DEVICE_SOURCE.getValue()) {
            this.deviceSourceService.updateById(this.deviceConverter.deviceSourceDto2Entity(param.getDeviceSourceDto()));
            if (!Objects.equals(beforeChangeDevice.getLocationId(), paramLocationId)) {
                this.changeRoomRelationForDevice(beforeChangeDevice.getLocationId(), deviceBase);
            }
        } else if (type == EdeviceTypeEnum.SOURCE_NON_SEALED.getValue()) {
            this.sourceNonSealedService.updateById(this.deviceConverter.sourceNonDto2Entity(param.getSourceNonSealedDto()));
        } else if (type == EdeviceTypeEnum.SOURCE_SEALED.getValue()) {
            this.sourceSealedService.updateById(this.deviceConverter.sourceSealedDto2Entity(param.getSourceSealedDto()));
        }
        this.deviceFactoryService.addFactory(deviceBase.getFactory());
        Boolean hasError = this.deviceErrorService.checkErrorForDevice(entity);
        if (hasError.booleanValue()) {
            entity.setInformationStatus(Integer.valueOf(0));
            this.updateById(entity);
        } else {
            entity.setInformationStatus(Integer.valueOf(1));
            this.updateById(entity);
        }
        ((EdeviceMapper)this.baseMapper).updateCompanyDeviceError(ShiroUtil.getLoginUserCid());
        return entity.getId();
    }

    @Override
    @Transactional
    public void delEDevice(EDeviceDetailParam param) {
        if (param.getId() == null) {
            throw new RuntimeException("id\u4e3a\u7a7a\uff01");
        }
        EDevice deviceBase = (EDevice)this.getById(param.getId());
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(BaseEntity::getIsValid, (Object)Constant.ACTIVE_NO)).eq(EDevice::getId, (Object)param.getId())).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES);
        this.update((Wrapper)updateWrapper);
        Integer type = deviceBase.getType();
        if (type == EdeviceTypeEnum.DEVICE_RAY.getValue()) {
            this.deviceRayService.delRayByDid(param.getId());
            this.relationService.disassociateByDeviceIdAndType(param.getId(), type);
        } else if (type == EdeviceTypeEnum.DEVICE_SOURCE.getValue()) {
            this.deviceSourceService.delDeviceSourceByDid(param.getId());
            this.relationService.disassociateByDeviceIdAndType(param.getId(), type);
        } else if (type == EdeviceTypeEnum.SOURCE_NON_SEALED.getValue()) {
            this.sourceNonSealedService.delNonSealedByDid(param.getId());
            this.relationService.disassociateByDeviceIdAndType(param.getId(), type);
        } else if (type == EdeviceTypeEnum.SOURCE_SEALED.getValue()) {
            this.sourceSealedService.delSourceSealedByDid(param.getId());
            this.relationService.disassociateByDeviceIdAndType(param.getId(), type);
        }
        this.deviceErrorService.delErrorForDevice(param.getId());
        ((EdeviceMapper)this.baseMapper).updateCompanyDeviceError(ShiroUtil.getLoginUserCid());
    }

    @Override
    public EDeviceCurBindSourceVo getCurBindingSource(Long id) {
        return ((EdeviceMapper)this.baseMapper).getCurBindingSource(id);
    }

    @Override
    public List<EDeviceCurBindDeviceVo> listCurBindingDevice(Long id) {
        return ((EdeviceMapper)this.baseMapper).listCurBindingDevice(id);
    }

    @Override
    public List<ESourceBindRoomVo> listRoomDeviceForSource(EDeviceDetailParam param) {
        List<ESourceBindRoomVo> roomVoList = ((EdeviceMapper)this.baseMapper).listRoomForSource(param);
        if (!CollectionUtils.isEmpty(roomVoList)) {
            for (ESourceBindRoomVo room : roomVoList) {
                List<ESourceBindDeviceVo> deviceList = ((EdeviceMapper)this.baseMapper).listDeviceForSourceAndRoom(room.getRoomId(), param.getId());
                if (CollectionUtils.isEmpty(deviceList)) continue;
                room.setDeviceList(deviceList);
                room.setDeviceNum(Integer.valueOf(deviceList.size()));
            }
        }
        return roomVoList;
    }

    @Override
    @Transactional
    public void addRelationForSource(List<ERelationDto> paramList) {
        if (CollectionUtils.isEmpty(paramList)) {
            return;
        }
        Long sourceId = null;
        for (ERelationDto param : paramList) {
            if (param.getSourceId() == null) {
                throw new RuntimeException("\u6838\u7d20id\u4e3a\u7a7a\uff01");
            }
            sourceId = param.getSourceId();
            if (param.getDeviceId() == null) {
                wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(ERelation::getDeviceId)).eq(ERelation::getSourceId, (Object)param.getSourceId())).eq(ERelation::getRoomId, (Object)param.getRoomId())).eq(ERelation::getIsCur, (Object)1)).eq(BaseEntity::getIsValid, (Object)1)).last("limit 1");
                isExistRelation = (ERelation)this.relationService.getOne((Wrapper)wrapper);
                if (isExistRelation != null) {
                    continue;
                }
            } else {
                wrapper = new LambdaQueryWrapper();
                ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ERelation::getDeviceId, (Object)param.getDeviceId())).eq(ERelation::getSourceId, (Object)param.getSourceId())).eq(ERelation::getRoomId, (Object)param.getRoomId())).eq(ERelation::getIsCur, (Object)1)).eq(BaseEntity::getIsValid, (Object)1)).last("limit 1");
                isExistRelation = (ERelation)this.relationService.getOne((Wrapper)wrapper);
                if (isExistRelation != null) continue;
            }
            Object afterChangeName = ((EMachineRoom)this.roomService.getById(param.getRoomId())).getName();
            EDevice device = (EDevice)this.getById(param.getDeviceId());
            if (device != null) {
                afterChangeName = (String)afterChangeName + "-" + device.getName();
            }
            ERelation relation = this.relationConverter.baseDto2Entity(param);
            relation.setChangeDate(LocalDateTime.now());
            relation.setBatchId(Long.valueOf(IdWorker.getId()));
            relation.setProjectId(null);
            relation.setBeforeChangeName("-");
            relation.setAfterChangeName((String)afterChangeName);
            relation.setOperatorName(ShiroUtil.getJWTUsername());
            this.relationService.addAssociationForSource(relation);
        }
        EDevice source = (EDevice)this.getById(sourceId);
        Integer type = source.getType();
        if (Objects.equals(type, EdeviceTypeEnum.SOURCE_NON_SEALED.getValue())) {
            this.deviceErrorService.delErrorByDeviceAndErrorCode(sourceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_21.getCode());
        } else if (Objects.equals(type, EdeviceTypeEnum.SOURCE_SEALED.getValue())) {
            this.deviceErrorService.delErrorByDeviceAndErrorCode(sourceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_30.getCode());
        }
        List<EDeviceErrorInfoVo> sourceErrorList = this.deviceErrorService.listErrorInfoForDevice(sourceId);
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        if (CollectionUtils.isEmpty(sourceErrorList)) {
            ((LambdaUpdateWrapper)updateWrapper.eq(EDevice::getId, (Object)sourceId)).set(EDevice::getInformationStatus, (Object)1);
        } else {
            ((LambdaUpdateWrapper)updateWrapper.eq(EDevice::getId, (Object)sourceId)).set(EDevice::getInformationStatus, (Object)0);
        }
        this.update((Wrapper)updateWrapper);
        for (ERelationDto param : paramList) {
            updateWrapper.clear();
            this.deviceErrorService.delErrorByDeviceAndErrorCode(param.getDeviceId(), BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_40.getCode());
            List<EDeviceErrorInfoVo> deviceErrorList = this.deviceErrorService.listErrorInfoForDevice(param.getDeviceId());
            if (CollectionUtils.isEmpty(deviceErrorList)) {
                ((LambdaUpdateWrapper)updateWrapper.eq(EDevice::getId, (Object)param.getDeviceId())).set(EDevice::getInformationStatus, (Object)1);
            } else {
                ((LambdaUpdateWrapper)updateWrapper.eq(EDevice::getId, (Object)param.getDeviceId())).set(EDevice::getInformationStatus, (Object)0);
            }
            this.update((Wrapper)updateWrapper);
        }
        ((EdeviceMapper)this.baseMapper).updateCompanyDeviceError(ShiroUtil.getLoginUserCid());
    }

    @Override
    @Transactional
    public void delRelationForSource(ERelationDto param) {
        List<ERelationDto> deviceRelationList;
        EDevice device;
        this.relationService.delAssociationByRelationId(param);
        List<ERelationDto> relationList = this.relationService.listCurRelationByType(1, param.getSourceId());
        if (CollectionUtils.isEmpty(relationList)) {
            EDevice source = (EDevice)this.getById(param.getSourceId());
            Integer type = source.getType();
            Integer code = null;
            if (Objects.equals(type, EdeviceTypeEnum.SOURCE_NON_SEALED.getValue())) {
                code = BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_21.getCode();
            } else if (Objects.equals(type, EdeviceTypeEnum.SOURCE_SEALED.getValue())) {
                code = BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_30.getCode();
            }
            this.deviceErrorService.addErrorForDevice(source.getCid(), source.getId(), code);
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)updateWrapper.eq(EDevice::getId, (Object)param.getSourceId())).set(EDevice::getInformationStatus, (Object)0);
            this.update((Wrapper)updateWrapper);
        }
        if (param.getDeviceId() != null && (device = (EDevice)this.getById(param.getDeviceId())) != null && Objects.equals(device.getType(), EdeviceTypeEnum.DEVICE_SOURCE.getValue()) && CollectionUtils.isEmpty(deviceRelationList = this.relationService.listCurRelationByType(5, param.getDeviceId()))) {
            this.deviceErrorService.addErrorForDevice(device.getCid(), device.getId(), BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_40.getCode());
            LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(EDevice::getId, (Object)param.getDeviceId())).set(EDevice::getInformationStatus, (Object)0);
            this.update((Wrapper)updateWrapper);
        }
        ((EdeviceMapper)this.baseMapper).updateCompanyDeviceError(ShiroUtil.getLoginUserCid());
    }

    @Override
    public LayuiGridData<SysChangeLog> listFieldChangeRecord(EDeviceListParam param) {
        if (param.getId() == null) {
            return new LayuiGridData();
        }
        EDevice device = (EDevice)this.getById(param.getId());
        Long subId = ((EdeviceMapper)this.baseMapper).getSubIdByDeviceId(device.getId(), device.getType());
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        return new LayuiGridData((Page)((EdeviceMapper)this.baseMapper).listFieldChangeRecord(device.getId(), subId), (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<EDeviceHistorySourceVo> listSourceByDevice(EDeviceDetailParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<EDeviceHistorySourceVo> rst = ((EdeviceMapper)this.baseMapper).listSourceByDevice(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<EDeviceHistorySourceVo> listSourceHistoryByDevice(EDeviceDetailParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<EDeviceHistorySourceVo> rst = ((EdeviceMapper)this.baseMapper).listSourceHistoryByDevice(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<EDeviceRoomForSealedVo> listDeviceForSealSource(EDeviceListParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<EDeviceRoomForSealedVo> deviceList = ((EdeviceMapper)this.baseMapper).listDeviceForSealSource(param);
        deviceList.forEach(device -> {
            device.setMachineRoomList(this.roomService.listRelationMachineRoomByDId(device.getId()));
            if (Objects.equals(device.getType(), EdeviceTypeEnum.DEVICE_RAY.getValue())) {
                device.setCategoryName(this.sysDeviceCategoryProvider.getCategoryNameById(device.getCategory()));
            }
        });
        return new LayuiGridData((Page)deviceList, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<EDevicePerformanceCheckVo> listPerformanceCheckRecord(EDeviceDetailParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<EDevicePerformanceCheckVo> rst = ((EdeviceMapper)this.baseMapper).listPerformanceCheckRecord(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<EDeviceThreeProjectVo> listThreeProject(EDeviceDetailParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<EDeviceThreeProjectVo> rst = ((EdeviceMapper)this.baseMapper).listThreeProjectByDevice(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<EDeviceLicenseOptLogVo> listLicenseOptLog(EDeviceDetailParam param) {
        if (param.getId() == null) {
            return null;
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<EDeviceLicenseOptLogVo> rst = ((EdeviceMapper)this.baseMapper).listLicenseOptLog(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<EDeviceForLicenseVo> listDeviceForLicense(BChangeLicenseDeviceParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<EDeviceForLicenseVo> rst = ((EdeviceMapper)this.baseMapper).listDeviceForLicense(param);
        return new LayuiGridData((Page)rst, (LayuiGridParam)param);
    }

    @Override
    public List<ERelationDto> listRoomForLicenseDevice(BChangeLicenseDeviceParam param) {
        if (param.getDeviceId() == null) {
            return null;
        }
        EDevice device = (EDevice)this.getById(param.getDeviceId());
        param.setDeviceType(device.getType());
        return ((EdeviceMapper)this.baseMapper).listRoomForLicenseDevice(param);
    }

    @Transactional
    public void addRoomRelationForDevice(Long beforeRoomId, EDevice device) {
        if (device.getLocationId() == null) {
            return;
        }
        EMachineRoom machineRoom = (EMachineRoom)this.roomService.getById(device.getLocationId());
        String roomName = machineRoom.getName();
        ERelation relation = new ERelation();
        relation.setDeviceId(device.getId());
        relation.setRoomId(device.getLocationId());
        relation.setSourceId(null);
        relation.setChangeDate(LocalDateTime.now());
        relation.setIsCur(Integer.valueOf(1));
        relation.setBatchId(Long.valueOf(IdWorker.getId()));
        relation.setBeforeChangeName("-");
        relation.setAfterChangeName(roomName);
        relation.setOperatorName(ShiroUtil.getJWTUsername());
        this.relationService.addRelationForDevice(relation);
        if (machineRoom.getEnableStatus() == 0) {
            machineRoom.setEnableStatus(Integer.valueOf(1));
            this.roomService.updateById(machineRoom);
        }
    }

    @Transactional
    public void addRoomRelationForMobiltyDevice(String beforeChangeName, List<ERelationDto> relationDtoList, EDevice device) {
        if (CollectionUtils.isEmpty(relationDtoList)) {
            return;
        }
        long batchId = IdWorker.getId();
        for (ERelationDto relationDto : relationDtoList) {
            ERelation relation = new ERelation();
            relation.setId(null);
            relation.setDeviceId(device.getId());
            relation.setRoomId(relationDto.getRoomId());
            relation.setSourceId(relationDto.getSourceId());
            relation.setChangeDate(LocalDateTime.now());
            relation.setIsCur(Integer.valueOf(1));
            relation.setProjectId(null);
            relation.setBatchId(Long.valueOf(batchId));
            relation.setBeforeChangeName(beforeChangeName);
            relation.setAfterChangeName(((EMachineRoom)this.roomService.getById(relationDto.getRoomId())).getName());
            relation.setOperatorName(ShiroUtil.getJWTUsername());
            this.relationService.addRelationForDevice(relation);
        }
    }

    @Transactional
    public void changeRoomRelationForDevice(Long beforeRoomId, EDevice device) {
        Long afterRoomId = device.getLocationId();
        if (afterRoomId == null) {
            this.relationService.freeRoomRelationForDevice(device.getId());
            return;
        }
        this.relationService.changeSourceOfRoomRelationForDevice(beforeRoomId, device.getId(), afterRoomId);
        this.relationService.freeRoomRelationForDevice(device.getId());
        ERelation relation = new ERelation();
        relation.setDeviceId(device.getId());
        relation.setRoomId(afterRoomId);
        relation.setSourceId(null);
        relation.setChangeDate(LocalDateTime.now());
        relation.setIsCur(Integer.valueOf(1));
        relation.setProjectId(null);
        relation.setBatchId(Long.valueOf(IdWorker.getId()));
        relation.setBeforeChangeName(beforeRoomId == null ? "-" : ((EMachineRoom)this.roomService.getById(beforeRoomId)).getName());
        relation.setAfterChangeName(((EMachineRoom)this.roomService.getById(afterRoomId)).getName());
        relation.setOperatorName(ShiroUtil.getJWTUsername());
        this.relationService.addRelationForDevice(relation);
    }

    @Transactional
    public void determineAndChangeRoomRelationForMobiltyDevice(EDevice device, List<ERelationDto> beforeRelationList, List<ERelationDto> afterRelationList) {
        if (CollectionUtils.isEmpty(afterRelationList)) {
            this.relationService.freeRoomRelationForDevice(device.getId());
            this.relationService.freeSourceRelationForDevice(device.getId());
            return;
        }
        ArrayList<ERelationDto> newRelationList = new ArrayList<ERelationDto>();
        ArrayList<ERelationDto> oldRelationList = new ArrayList<ERelationDto>();
        ArrayList<ERelationDto> needFreeRelationList = new ArrayList<ERelationDto>();
        String beforeName = "-";
        if (CollectionUtils.isEmpty(beforeRelationList)) {
            newRelationList.addAll(afterRelationList);
        } else {
            for (ERelationDto afterRelation : afterRelationList) {
                if (afterRelation.getId() == null) {
                    newRelationList.add(afterRelation);
                    continue;
                }
                for (ERelationDto beforeRelation : beforeRelationList) {
                    if (!Objects.equals(afterRelation.getId(), beforeRelation.getId())) continue;
                    oldRelationList.add(beforeRelation);
                }
            }
            for (ERelationDto beforeRelation : beforeRelationList) {
                boolean needFree = true;
                for (ERelationDto oldRelation : oldRelationList) {
                    if (!Objects.equals(beforeRelation.getId(), oldRelation.getId())) continue;
                    needFree = false;
                    break;
                }
                if (!needFree) continue;
                needFreeRelationList.add(beforeRelation);
            }
            List<Long> freeIdList = needFreeRelationList.stream().map(ERelationDto::getId).collect(Collectors.toList());
            this.relationService.freeBatchRelationById(freeIdList);
            beforeName = needFreeRelationList.stream().map(ERelationDto::getRoomName).distinct().collect(Collectors.joining(","));
        }
        this.addRoomRelationForMobiltyDevice(beforeName, newRelationList, device);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)queryWrapper.eq(ERelation::getDeviceId, (Object)device.getId())).isNotNull(ERelation::getSourceId)).eq(ERelation::getIsCur, (Object)1)).eq(BaseEntity::getIsValid, (Object)1);
        if (!CollectionUtils.isEmpty(needFreeRelationList)) {
            queryWrapper.in(ERelation::getRoomId, (Collection)needFreeRelationList.stream().map(ERelationDto::getRoomId).collect(Collectors.toList()));
        }
        List sourceRelationList = this.relationService.list((Wrapper)queryWrapper);
        for (ERelation relation : sourceRelationList) {
            relation.setIsCur(Integer.valueOf(0));
        }
        this.relationService.updateBatchById(sourceRelationList);
        List sourceIdList = sourceRelationList.stream().map(ERelation::getSourceId).distinct().collect(Collectors.toList());
        List<ERelation> newRelationAboutDeviceAndRoomList = this.relationConverter.dtoList2EntityList(newRelationList);
        ArrayList<ERelation> addSourceRelationList = new ArrayList<ERelation>();
        long batchId = IdWorker.getId();
        for (Long sourceId : sourceIdList) {
            for (ERelation relationAboutDeviceAndRoom : newRelationAboutDeviceAndRoomList) {
                relationAboutDeviceAndRoom.setId(null);
                relationAboutDeviceAndRoom.setSourceId(sourceId);
                relationAboutDeviceAndRoom.setDeviceId(device.getId());
                relationAboutDeviceAndRoom.setChangeDate(LocalDateTime.now());
                relationAboutDeviceAndRoom.setBeforeChangeName(beforeName);
                relationAboutDeviceAndRoom.setAfterChangeName(this.roomService.getNameById(relationAboutDeviceAndRoom.getRoomId()));
                relationAboutDeviceAndRoom.setBatchId(Long.valueOf(batchId));
                relationAboutDeviceAndRoom.setIsCur(Integer.valueOf(1));
                addSourceRelationList.add(relationAboutDeviceAndRoom);
            }
        }
        this.relationService.saveBatch(addSourceRelationList);
    }
}

