/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.d;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.modules.company.dao.d.DLocationCheckMapper;
import cn.smarthse.rho.modules.company.service.d.IDLocationCheckDataService;
import cn.smarthse.rho.modules.company.service.d.IDLocationCheckService;
import cn.smarthse.rho.modules.sys.entity.d.DLocationCheck;
import cn.smarthse.rho.modules.sys.entity.d.DLocationCheckData;
import cn.smarthse.rho.modules.sys.model.d.param.AddLocationCheckVo;
import cn.smarthse.rho.modules.sys.model.d.param.DLocationCheckQueryParam;
import cn.smarthse.rho.modules.sys.model.d.vo.DLocationCheckVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DLocationCheckServiceImpl
extends ServiceImpl<DLocationCheckMapper, DLocationCheck>
implements IDLocationCheckService {
    @Autowired
    private IDLocationCheckDataService locationCheckDataService;

    @Override
    public LayuiGridData<DLocationCheckVo> getCheckList(DLocationCheckQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        Page page = (Page)((DLocationCheckMapper)this.baseMapper).getCheckList(param);
        return new LayuiGridData(page, (LayuiGridParam)param);
    }

    @Override
    public DLocationCheck getCheckDetail(Long checkId) {
        return (DLocationCheck)this.getById(checkId);
    }

    @Override
    @Transactional
    public void addLocationCheckByManual(AddLocationCheckVo param) {
        DLocationCheck locationCheck = param.getLocationCheck();
        if (locationCheck.getCid() == null || locationCheck.getCheckTime() == null || locationCheck.getHospitalCode() == null) {
            throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff01cid/checkTime/hospitalCode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        locationCheck.setId(null);
        this.save(locationCheck);
        List locationCheckDataList = param.getLocationCheckDataList();
        for (DLocationCheckData locationCheckData : locationCheckDataList) {
            if (locationCheckData.getLocationId() == null) {
                throw new RuntimeException("\u53c2\u6570\u9519\u8bef\uff01locationId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            locationCheckData.setId(null);
            locationCheckData.setCheckId(locationCheck.getId());
            locationCheckData.setCid(locationCheck.getCid());
            locationCheckData.setHospitalCode(locationCheck.getHospitalCode());
            locationCheckData.setHospital(locationCheck.getHospital());
            locationCheckData.setCheckTime(locationCheck.getCheckTime());
        }
        this.locationCheckDataService.saveBatch(locationCheckDataList);
    }
}

