/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.c;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.rho.core.framework.Constant;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.core.framework.utils.StringUtils;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.converter.CTrainingCertConverter;
import cn.smarthse.rho.modules.company.dao.c.CTrainingCertMapper;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.company.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.company.service.r.IRKeyFactorAuditService;
import cn.smarthse.rho.modules.company.service.r.IRRiskBasicSourceService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.entity.c.CTrainingCert;
import cn.smarthse.rho.modules.sys.entity.r.RKeyFactorAudit;
import cn.smarthse.rho.modules.sys.entity.sys.SysBusinessOperateLog;
import cn.smarthse.rho.modules.sys.enums.risk.KeyFactoAuditStatusEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.enums.staff.StaffCertSourceEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogModuleEnum;
import cn.smarthse.rho.modules.sys.enums.sys.SysBusinessOperateLogTypeEnum;
import cn.smarthse.rho.modules.sys.enums.train.TrainingCertAuditStatusEnum;
import cn.smarthse.rho.modules.sys.enums.train.TrainingCertResultEnum;
import cn.smarthse.rho.modules.sys.enums.train.TrainingCertSourceEnum;
import cn.smarthse.rho.modules.sys.enums.train.TrainingCertTypeEnum;
import cn.smarthse.rho.modules.sys.model.c.param.CTrainingCertPageParam;
import cn.smarthse.rho.modules.sys.model.c.param.TrainingCertEditParam;
import cn.smarthse.rho.modules.sys.model.sys.param.SysBusinessOperateLogParam;
import cn.smarthse.rho.modules.sys.provider.sys.ISysBusinessOperateLogProvider;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.smarthse.framework.exception.ServiceException;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class CTrainingCertServiceImpl
extends ServiceImpl<CTrainingCertMapper, CTrainingCert>
implements ICTrainingCertService {
    @Autowired
    private CTrainingCertConverter converter;
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private IRKeyFactorAuditService keyFactorAuditService;
    @Autowired
    private IRRiskBasicSourceService riskBasicSourceService;
    @Autowired
    @Lazy
    private ICStaffBaseInfoService staffBaseInfoService;
    @DubboReference
    private ISysBusinessOperateLogProvider logProvider;

    private void calculateEcologicalRadiationCertValidDate(CTrainingCert cert) {
        if (cert == null || cert.getCertType() == null || cert.getIssuanceDate() == null) {
            return;
        }
        if (cert.getCertType().equals(TrainingCertTypeEnum.TYPE_4.getValue())) {
            LocalDate maxSystemExpireDate;
            LocalDate actualExpireDate = cert.getIssuanceDate().plusYears(5L);
            if (actualExpireDate.isAfter(maxSystemExpireDate = LocalDate.now().plusYears(2L))) {
                cert.setCertValidDate(maxSystemExpireDate);
            } else {
                cert.setCertValidDate(actualExpireDate);
            }
        }
        if (cert.getCertType().equals(TrainingCertTypeEnum.TYPE_2.getValue())) {
            cert.setCertValidDate(cert.getIssuanceDate().plusYears(2L));
        }
    }

    @Override
    public LayuiGridData<CTrainingCert> getListForArchive(CTrainingCertPageParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CTrainingCert> list = ((CTrainingCertMapper)this.baseMapper).getListForArchive(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<CTrainingCert> getListForKeyFactor(CTrainingCertPageParam param) {
        param.setKeywordEn(param.getKeyword());
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<CTrainingCert> list = ((CTrainingCertMapper)this.baseMapper).getListForKeyFactor(param);
        if (!CollectionUtils.isEmpty(list)) {
            list.forEach(item -> {
                if (StringUtils.isNotEmpty((String)item.getStaffName())) {
                    item.setStaffName(DesensitizationUtils.desensitized((CharSequence)item.getStaffName(), (DesensitizationType)DesensitizationType.NAME));
                    item.setStaffNameNow(DesensitizationUtils.desensitized((CharSequence)item.getStaffNameNow(), (DesensitizationType)DesensitizationType.NAME));
                }
            });
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    @Transactional
    public void addOrEditCert(TrainingCertEditParam param) {
        boolean isDraft = param.getIfDraft();
        if (!isDraft && (StringUtils.isEmpty((CharSequence)param.getStaffName()) || StringUtils.isEmpty((CharSequence)param.getIdcard()))) {
            throw new ServiceException("\u4eba\u5458\u59d3\u540d\u6216\u8eab\u4efd\u8bc1\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        CTrainingCert cert = this.converter.param2Entity(param);
        cert.setSource(StaffCertSourceEnum.HOSPITAL.getValue());
        cert.setIdcard(StrUtil.toUpperCase((CharSequence)param.getIdcard()));
        cert.setResult(TrainingCertResultEnum.QUALIFIED.getValue());
        BCompany company = (BCompany)this.companyService.getById(cert.getCid());
        if (company != null) {
            cert.setCompName(company.getName());
        }
        if (!isDraft) {
            cert.setAuditStatus(TrainingCertAuditStatusEnum.WAIT_AUDIT.getValue());
        } else {
            cert.setAuditStatus(TrainingCertAuditStatusEnum.DRAFT.getValue());
        }
        if (param.getStaffBaseInfoId() != null) {
            CStaffBaseInfo staffBaseInfo = (CStaffBaseInfo)this.staffBaseInfoService.getById(param.getStaffBaseInfoId());
            cert.setStaffName(staffBaseInfo.getName());
            cert.setIdcard(staffBaseInfo.getIdcard());
        }
        this.calculateEcologicalRadiationCertValidDate(cert);
        this.saveOrUpdate(cert);
        RKeyFactorAudit keyFactorAudit = new RKeyFactorAudit();
        keyFactorAudit.setType(RiskTypeEnum.TRAINING.getValue());
        keyFactorAudit.setBusinessId(cert.getId());
        keyFactorAudit.setCid(cert.getCid());
        if (isDraft) {
            keyFactorAudit.setStatus(KeyFactoAuditStatusEnum.DRAFT.getCode());
        } else {
            keyFactorAudit.setStatus(KeyFactoAuditStatusEnum.AUDIT.getCode());
        }
        if (param.getKeyFactorAuditId() != null) {
            keyFactorAudit.setId(param.getKeyFactorAuditId());
        }
        if (company != null) {
            keyFactorAudit.setCompanyName(company.getName());
            keyFactorAudit.setCompanyAddress(company.getAddress());
        }
        this.keyFactorAuditService.saveOrUpdate(keyFactorAudit);
        SysBusinessOperateLog log = new SysBusinessOperateLog();
        log.setBusinessId(param.getKeyFactorAuditId() != null ? param.getKeyFactorAuditId() : keyFactorAudit.getId()).setModule(SysBusinessOperateLogModuleEnum.KEY_FACTOR_AUDIT_1.getValue()).setCid(param.getCid()).setOperator(ShiroUtil.getJWTUsername()).setOperatorCompanyName(ShiroUtil.getLoginUserCompanyName());
        if (param.getIfDraft().booleanValue()) {
            log.setType(SysBusinessOperateLogTypeEnum.DRAFT.getValue());
        } else {
            log.setType(SysBusinessOperateLogTypeEnum.SUBMIT.getValue());
        }
        this.logProvider.addOrUpdateLog(log);
        if (!isDraft && cert.getCertValidDate().isAfter(LocalDate.now())) {
            this.riskBasicSourceService.updateRiskByTrainingCertSubmit(cert);
        }
    }

    @Override
    public CTrainingCert getLastData(Long staffBaseInfoId) {
        return ((CTrainingCertMapper)this.baseMapper).getLastData(staffBaseInfoId);
    }

    @Override
    public CTrainingCert getTrainingCertDetailById(Long id) {
        CTrainingCert result = ((CTrainingCertMapper)this.baseMapper).getTrainingCertDetailById(id);
        if (StrUtil.isNotBlank((CharSequence)result.getTrainingHours()) && result.getTrainingHours().equals("0.0")) {
            result.setTrainingHours("-");
        }
        return ((CTrainingCertMapper)this.baseMapper).getTrainingCertDetailById(id);
    }

    @Override
    @Transactional
    public void suspendApplication(Long id) {
        this.updateStatusById(id, TrainingCertAuditStatusEnum.TERMINATED.getValue());
        List<Integer> statusList = Arrays.asList(KeyFactoAuditStatusEnum.AUDIT.getCode(), KeyFactoAuditStatusEnum.BACK.getCode());
        List<RKeyFactorAudit> lists = this.keyFactorAuditService.getListsByBusinessId(id, statusList);
        if (!CollectionUtils.isEmpty(lists)) {
            lists.forEach(item -> {
                item.setStatus(KeyFactoAuditStatusEnum.CLOSED.getCode());
                item.setUpdateBy(ShiroUtil.getJWTOidOrCid());
                item.setUpdateDate(new Date());
            });
            this.keyFactorAuditService.updateBatchById(lists);
        }
        ArrayList logs = new ArrayList();
        if (!CollectionUtils.isEmpty(lists)) {
            lists.forEach(item -> {
                SysBusinessOperateLog log = new SysBusinessOperateLog();
                log.setBusinessId(item.getId()).setModule(SysBusinessOperateLogModuleEnum.KEY_FACTOR_AUDIT_1.getValue()).setType(SysBusinessOperateLogTypeEnum.TERMINATED.getValue()).setCid(item.getCid()).setOperator(ShiroUtil.getJWTFullName()).setOperatorCompanyName(ShiroUtil.getLoginUserCompanyName());
                logs.add(log);
            });
            this.logProvider.addBatchLog(logs);
        }
    }

    @Override
    @Transactional
    public void revokeApplication(Long id) {
        Integer preStatus = KeyFactoAuditStatusEnum.DRAFT.getCode();
        CTrainingCert cert = this.getTrainingCertDetailById(id);
        if (cert == null) {
            throw new ServiceException("\u672a\u67e5\u8be2\u5230\u57f9\u8bad\u8bc1\u660e\u6570\u636e");
        }
        if (!Objects.equals(cert.getAuditStatus(), TrainingCertAuditStatusEnum.WAIT_AUDIT.getValue())) {
            throw new ServiceException("\u975e\u5f85\u5ba1\u6838\u72b6\u6001\uff0c\u4e0d\u80fd\u64a4\u56de\u7533\u8bf7");
        }
        RKeyFactorAudit keyFactorAudit = (RKeyFactorAudit)this.keyFactorAuditService.getById(cert.getKeyFactorAuditId());
        SysBusinessOperateLogParam logParam = new SysBusinessOperateLogParam();
        logParam.setBusinessId(cert.getKeyFactorAuditId());
        logParam.setPage(1);
        logParam.setLimit(Integer.MAX_VALUE);
        List logs = this.logProvider.getListData(logParam);
        if (!CollectionUtils.isEmpty((Collection)logs)) {
            if (logs.size() == 1 && Objects.equals(((SysBusinessOperateLog)logs.get(0)).getType(), SysBusinessOperateLogTypeEnum.SUBMIT.getValue())) {
                preStatus = KeyFactoAuditStatusEnum.DRAFT.getCode();
            }
            if (logs.size() > 1 && Objects.equals(((SysBusinessOperateLog)logs.get(0)).getType(), SysBusinessOperateLogTypeEnum.SUBMIT.getValue()) && (((SysBusinessOperateLog)logs.get(1)).getType().equals(SysBusinessOperateLogTypeEnum.BACK.getValue()) || ((SysBusinessOperateLog)logs.get(1)).getType().equals(SysBusinessOperateLogTypeEnum.DRAFT.getValue()))) {
                preStatus = ((SysBusinessOperateLog)logs.get(1)).getType();
            }
        }
        this.updateStatusById(id, preStatus);
        if (!CollectionUtils.isEmpty((Collection)logs)) {
            keyFactorAudit.setStatus(preStatus);
            this.keyFactorAuditService.updateById(keyFactorAudit);
            SysBusinessOperateLog log = new SysBusinessOperateLog();
            log.setBusinessId(keyFactorAudit.getId()).setModule(SysBusinessOperateLogModuleEnum.KEY_FACTOR_AUDIT_1.getValue()).setType(preStatus).setCid(keyFactorAudit.getCid()).setOperator(ShiroUtil.getJWTFullName()).setOperatorCompanyName(ShiroUtil.getLoginUserCompanyName()).setReason("\u64a4\u56de\u7533\u8bf7");
            this.logProvider.addOrUpdateLog(log);
        }
    }

    @Override
    public void updateStatusById(Long id, Integer status) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)wrapper.eq(CTrainingCert::getId, (Object)id)).set(CTrainingCert::getAuditStatus, (Object)status);
        ((CTrainingCertMapper)this.baseMapper).update((Wrapper)wrapper);
    }

    @Override
    public void delById(Long id) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)wrapper.eq(CTrainingCert::getId, (Object)id)).eq(BaseEntity::getIsValid, (Object)Constant.ACTIVE_YES)).eq(CTrainingCert::getSource, (Object)TrainingCertSourceEnum.UNIT.getValue())).eq(CTrainingCert::getAuditStatus, (Object)TrainingCertAuditStatusEnum.DRAFT.getValue())).set(BaseEntity::getIsValid, (Object)Constant.ACTIVE_NO);
        ((CTrainingCertMapper)this.baseMapper).update((Wrapper)wrapper);
    }
}

