/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.c;

import cn.hutool.core.collection.CollUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.modules.company.converter.CStaffConverter;
import cn.smarthse.rho.modules.company.dao.c.CStaffMapper;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.b.IBOrgService;
import cn.smarthse.rho.modules.company.service.c.ICStaffService;
import cn.smarthse.rho.modules.company.service.c.ICStaffWorkExperienceService;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.entity.c.CStaffWorkExperience;
import cn.smarthse.rho.modules.sys.enums.staff.PostStatusEnum;
import cn.smarthse.rho.modules.sys.model.b.vo.BPostVo;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffEditParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffPostPre2OnParam;
import cn.smarthse.rho.modules.sys.provider.c.IStaffProvider;
import cn.smarthse.rho.modules.sys.provider.company.IPostProvider;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
@Service
public class CStaffServiceImpl
extends ServiceImpl<CStaffMapper, CStaff>
implements ICStaffService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CStaffServiceImpl.class);
    @Autowired
    private CStaffConverter converter;
    @Autowired
    private ICStaffWorkExperienceService cStaffWorkExperienceService;
    @Autowired
    private IBCompanyService companyService;
    @Autowired
    private IBOrgService orgService;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private RedissonClient redissonClient;
    @DubboReference
    private IStaffProvider staffProvider;
    private static final String LOCK_KEY = "CStaffServiceImpl";
    @DubboReference
    private IPostProvider postProvider;

    @Override
    @Transactional
    public void editInfo(CStaffEditParam param) {
        this.staffProvider.editStaffInfo(param);
    }

    @Override
    @Transactional
    public void addInfo(CStaffEditParam param) {
        this.staffProvider.addStaffInfo(param);
    }

    @Override
    public CStaff getByBaseIdAndCid(Long baseId, Long cid) {
        QueryWrapper wrapper = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.lambda().eq(CStaff::getBaseId, (Object)baseId)).eq(CStaff::getCid, (Object)cid)).last("limit 1");
        return (CStaff)this.getOne((Wrapper)wrapper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public void pre2On(StaffPostPre2OnParam param) {
        log.debug("\u5c97\u4f4d\u7ef4\u62a4\uff1a\u6682\u79bb\uff08\u9884\u4e0a\u5c97\uff09\u8f6c\u4e0a\u5c97 pre2On() start");
        RLock lock = this.redissonClient.getLock(LOCK_KEY);
        boolean resLock = false;
        try {
            resLock = lock.tryLock(10L, 10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        if (resLock) {
            try {
                this.pre2OnLock(param);
                log.debug("\u5c97\u4f4d\u7ef4\u62a4\uff1a\u6682\u79bb\uff08\u9884\u4e0a\u5c97\uff09\u8f6c\u4e0a\u5c97 pre2On( end");
            }
            catch (Exception e) {
                log.error("\u3010\u6682\u65f6\u79bb\u5c97\u8f6c\u4e0a\u5c97\u3011\u5931\u8d25", (Throwable)e);
            }
            finally {
                lock.unlock();
            }
        } else {
            log.error("{}\uff1aPending lock timeout\uff0cmethod:pre2On()", (Object)LOCK_KEY);
        }
    }

    @Transactional
    public void pre2OnLock(StaffPostPre2OnParam param) {
        List<CStaff> dbList = ((CStaffMapper)this.baseMapper).getNeedPre2OnList(param);
        ArrayList<CStaff> upEntityList = new ArrayList<CStaff>();
        LocalDateTime current = LocalDateTime.now();
        for (CStaff entity : dbList) {
            if (current.isBefore(entity.getPrePostStartTime())) continue;
            CStaff upEntity = new CStaff();
            upEntity.setId(entity.getId());
            upEntity.setPostStatus(PostStatusEnum.ON_POST.getValue());
            upEntityList.add(upEntity);
        }
        if (CollUtil.isNotEmpty(upEntityList)) {
            this.updateBatchById(upEntityList);
        }
    }

    @Override
    public CStaff getByBaseIdAndBranchCid(Long staffBaseInfoId, Long branchCid) {
        return ((CStaffMapper)this.baseMapper).getByBaseIdAndBranchCid(staffBaseInfoId, branchCid);
    }

    @Override
    public CStaff getMaxTime(Long staffBaseInfoId, Long branchCid) {
        return ((CStaffMapper)this.baseMapper).getMaxTime(staffBaseInfoId, branchCid);
    }

    @Transactional
    public void recordWorkExperience(CStaff oldData, CStaff newestData, CStaffBaseInfo baseInfo, CStaffEditParam param) {
        BPostVo postInfo = this.postProvider.getPostInfo(newestData.getPost());
        BPostVo bPostVo = postInfo = postInfo == null ? new BPostVo() : postInfo;
        if (param.getType() != null) {
            if (param.getType() == 0) {
                CStaffWorkExperience newestWorkExperienceInfo = this.cStaffWorkExperienceService.getNewestInfo(baseInfo.getId(), oldData.getCid());
                if (newestWorkExperienceInfo != null && (PostStatusEnum.ON_POST.getValue().equals(newestWorkExperienceInfo.getPostStatus()) || PostStatusEnum.TP_NON_POST.getValue().equals(newestWorkExperienceInfo.getPostStatus()))) {
                    newestWorkExperienceInfo.setPostDepartureTime(param.getPostDepartureTime());
                    newestWorkExperienceInfo.setPostStatus(PostStatusEnum.NON_POST.getValue());
                    this.cStaffWorkExperienceService.updateById(newestWorkExperienceInfo);
                } else {
                    CStaffWorkExperience staffWorkExperience = new CStaffWorkExperience();
                    staffWorkExperience.setCid(newestData.getCid());
                    staffWorkExperience.setOrgId(newestData.getOrgId());
                    staffWorkExperience.setStaffBaseInfoId(baseInfo.getId());
                    staffWorkExperience.setPost(newestData.getPost());
                    staffWorkExperience.setPostName(postInfo.getName());
                    staffWorkExperience.setPostStatus(PostStatusEnum.NON_POST.getValue());
                    staffWorkExperience.setType(param.getType());
                    staffWorkExperience.setRaType(baseInfo.getRaType());
                    staffWorkExperience.setPostStartTime(param.getPostStartTime());
                    staffWorkExperience.setPostDepartureTime(param.getPostDepartureTime());
                    this.cStaffWorkExperienceService.save(staffWorkExperience);
                }
            } else if (param.getType() == 1) {
                CStaffWorkExperience staffWorkExperience = new CStaffWorkExperience();
                staffWorkExperience.setCid(newestData.getCid());
                staffWorkExperience.setOrgId(newestData.getOrgId());
                staffWorkExperience.setStaffBaseInfoId(baseInfo.getId());
                staffWorkExperience.setPost(newestData.getPost());
                staffWorkExperience.setPostName(postInfo.getName());
                staffWorkExperience.setPostStatus(PostStatusEnum.ON_POST.getValue());
                staffWorkExperience.setType(param.getType());
                staffWorkExperience.setRaType(baseInfo.getRaType());
                staffWorkExperience.setPostStartTime(param.getPostStartTime());
                this.cStaffWorkExperienceService.save(staffWorkExperience);
            } else if (param.getType() == 2) {
                CStaffWorkExperience staffWorkExperience;
                CStaffWorkExperience newestWorkExperienceInfo = this.cStaffWorkExperienceService.getNewestInfo(baseInfo.getId(), oldData.getCid());
                if (newestWorkExperienceInfo != null && PostStatusEnum.ON_POST.getValue().equals(newestWorkExperienceInfo.getPostStatus())) {
                    staffWorkExperience = new CStaffWorkExperience();
                    staffWorkExperience.setId(newestWorkExperienceInfo.getId());
                    staffWorkExperience.setPostStatus(PostStatusEnum.NON_POST.getValue());
                    staffWorkExperience.setType(param.getType());
                    staffWorkExperience.setPostDepartureTime(param.getPostDepartureTime());
                    this.cStaffWorkExperienceService.updateById(staffWorkExperience);
                }
                staffWorkExperience = new CStaffWorkExperience();
                staffWorkExperience.setCid(newestData.getCid());
                staffWorkExperience.setOrgId(newestData.getOrgId());
                staffWorkExperience.setStaffBaseInfoId(baseInfo.getId());
                staffWorkExperience.setPost(newestData.getPost());
                staffWorkExperience.setPostName(postInfo.getName());
                staffWorkExperience.setPostStatus(PostStatusEnum.ON_POST.getValue());
                staffWorkExperience.setType(param.getType());
                staffWorkExperience.setRaType(baseInfo.getRaType());
                staffWorkExperience.setPostStartTime(param.getPostStartTime());
                this.cStaffWorkExperienceService.save(staffWorkExperience);
            } else if (param.getType() == 3) {
                CStaffWorkExperience newestWorkExperienceInfo = this.cStaffWorkExperienceService.getNewestInfo(baseInfo.getId(), oldData.getCid());
                if (newestWorkExperienceInfo != null && PostStatusEnum.ON_POST.getValue().equals(newestWorkExperienceInfo.getPostStatus())) {
                    newestWorkExperienceInfo.setTpPostDepartureTime(param.getTpPostDepartureTime());
                    newestWorkExperienceInfo.setPrePostStartTime(param.getPrePostStartTime());
                    newestWorkExperienceInfo.setPostStatus(PostStatusEnum.TP_NON_POST.getValue());
                    this.cStaffWorkExperienceService.updateById(newestWorkExperienceInfo);
                } else {
                    CStaffWorkExperience staffWorkExperience = new CStaffWorkExperience();
                    staffWorkExperience.setCid(newestData.getCid());
                    staffWorkExperience.setOrgId(newestData.getOrgId());
                    staffWorkExperience.setStaffBaseInfoId(baseInfo.getId());
                    staffWorkExperience.setPost(newestData.getPost());
                    staffWorkExperience.setPostName(postInfo.getName());
                    staffWorkExperience.setPostStatus(PostStatusEnum.TP_NON_POST.getValue());
                    staffWorkExperience.setType(param.getType());
                    staffWorkExperience.setRaType(baseInfo.getRaType());
                    staffWorkExperience.setTpPostDepartureTime(param.getTpPostDepartureTime());
                    staffWorkExperience.setPrePostStartTime(param.getPrePostStartTime());
                    this.cStaffWorkExperienceService.save(staffWorkExperience);
                }
            }
        }
    }
}

