/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.c;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.encrypt.spring.utils.SpringEncryptUtils;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import cn.smarthse.framework.sensitive.utils.DesensitizationUtils;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.model.LayuiGridParam;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.dao.c.CStaffBaseInfoMapper;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.b.IBStatisticService;
import cn.smarthse.rho.modules.company.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.company.service.c.ICStaffService;
import cn.smarthse.rho.modules.company.service.c.ICStaffWorkExperienceService;
import cn.smarthse.rho.modules.company.service.c.ICTrainingCertService;
import cn.smarthse.rho.modules.company.service.r.IRRiskBasicSourceService;
import cn.smarthse.rho.modules.sys.entity.b.BCompany;
import cn.smarthse.rho.modules.sys.entity.c.CDoseData;
import cn.smarthse.rho.modules.sys.entity.c.CHealthCheckData;
import cn.smarthse.rho.modules.sys.entity.c.CStaff;
import cn.smarthse.rho.modules.sys.entity.c.CStaffBaseInfo;
import cn.smarthse.rho.modules.sys.entity.c.CTrainingCert;
import cn.smarthse.rho.modules.sys.model.b.param.RayStaffQueryParam;
import cn.smarthse.rho.modules.sys.model.b.vo.company.CompanyAddressVo;
import cn.smarthse.rho.modules.sys.model.c.param.CStaffDeleteParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffAcInfoParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffChooseListPageParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffCmPageParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffInfoParam;
import cn.smarthse.rho.modules.sys.model.c.param.StaffStatisticsParam;
import cn.smarthse.rho.modules.sys.model.c.param.staff.CheckStaffRelationParam;
import cn.smarthse.rho.modules.sys.model.c.vo.CompanyStaffArchiveStatisticsVo;
import cn.smarthse.rho.modules.sys.model.c.vo.OrgStaffListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.RayStaffListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffAcVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffArchiveListVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffArchiveStatisticsCMVo;
import cn.smarthse.rho.modules.sys.model.c.vo.StaffChooseListVo;
import cn.smarthse.rho.modules.sys.model.easyexcel.StaffImportDto;
import cn.smarthse.rho.modules.sys.model.home.vo.HomeData31;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.provider.c.ICDoseDataProvider;
import cn.smarthse.rho.modules.sys.provider.c.ICHealthCheckDataProvider;
import cn.smarthse.rho.modules.sys.provider.c.IRayCertProvider;
import cn.smarthse.rho.modules.sys.provider.c.IStaffProvider;
import cn.smarthse.rho.modules.sys.provider.company.IBCompanyAddressProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CStaffBaseInfoServiceImpl
extends ServiceImpl<CStaffBaseInfoMapper, CStaffBaseInfo>
implements ICStaffBaseInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CStaffBaseInfoServiceImpl.class);
    @Autowired
    private ICStaffService cStaffService;
    @Autowired
    private IBCompanyService bCompanyService;
    @Autowired
    private IBCompanyAddressProvider companyAddressProvider;
    @Autowired
    private IBStatisticService bStatisticService;
    @Autowired
    private ICStaffWorkExperienceService staffWorkExperienceService;
    @Autowired
    private ICTrainingCertService trainingCertService;
    @Autowired
    private IRRiskBasicSourceService riskBasicSourceService;
    @DubboReference
    private ICDoseDataProvider doseDataProvider;
    @DubboReference
    private IStaffProvider staffProvider;
    @DubboReference
    private ICHealthCheckDataProvider healthCheckDataService;
    @DubboReference
    private ISysFileProvider fileProvider;
    @DubboReference
    private IRayCertProvider rayCertProvider;

    @Override
    public LayuiGridData<List<OrgStaffListVo>> getListForOrg(StaffCmPageParam param) {
        param.setKeywordEn(param.getKeyword());
        boolean sameHospital = this.bCompanyService.isSameHospital(param.getCid(), ShiroUtil.getLoginUserCid());
        if (!sameHospital) {
            throw new ServiceException("\u65e0\u6cd5\u67e5\u770b\u5176\u4ed6\u533b\u9662\u4fe1\u606f");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<OrgStaffListVo> list = ((CStaffBaseInfoMapper)this.baseMapper).getListForOrg(param);
        for (OrgStaffListVo vo : list) {
            vo.genAll();
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<StaffArchiveListVo> getStaffArchiveList(StaffCmPageParam param) {
        param.setKeywordEn(param.getKeyword());
        BCompany company = (BCompany)this.bCompanyService.getById(ShiroUtil.getLoginUserCid());
        param.setCreditCode(company.getCreditCode());
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit(), (boolean)param.getCount());
        List<StaffArchiveListVo> list = ((CStaffBaseInfoMapper)this.baseMapper).getStaffArchiveList(param);
        if (CollectionUtil.isEmpty(list)) {
            return new LayuiGridData((Page)list, (LayuiGridParam)param);
        }
        for (StaffArchiveListVo vo : list) {
            vo.setCertConditionVo(this.rayCertProvider.getCertCondition(vo.getId()));
        }
        List sbIdList = list.stream().map(v -> v.getId()).collect(Collectors.toList());
        param.setSbIdList(sbIdList);
        List<StaffArchiveListVo> timeList = ((CStaffBaseInfoMapper)this.baseMapper).getAllNewestCheckTime(param);
        if (CollUtil.isNotEmpty(timeList)) {
            Map<Long, List<StaffArchiveListVo>> timeLitMap = timeList.stream().collect(Collectors.groupingBy(v -> v.getId()));
            for (StaffArchiveListVo vo : list) {
                if (!timeLitMap.containsKey(vo.getId())) continue;
                List<StaffArchiveListVo> temp = timeLitMap.get(vo.getId());
                vo.setHealCheckDate(temp.get(0).getHealCheckDate());
                vo.setTrainingCheckDate(temp.get(0).getTrainingCheckDate());
                vo.setDoseCheckDate(temp.get(0).getDoseCheckDate());
            }
        }
        for (StaffArchiveListVo vo : list) {
            vo.setThresholdTime(this.getThresholdTime(vo.getId(), param.getCid()));
            vo.setHasRelatedData(Integer.valueOf(this.staffProvider.hasRelatedData(new CheckStaffRelationParam(ShiroUtil.getLoginUserCid(), vo.getId())) ? 1 : 0));
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<StaffArchiveListVo> getPostStaffArchiveList(StaffCmPageParam param) {
        if (param.getPost() == null) {
            throw new ServiceException("\u7f3a\u5c11\u53c2\u6570");
        }
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<StaffArchiveListVo> list = ((CStaffBaseInfoMapper)this.baseMapper).getPostStaffArchiveList(param);
        if (CollectionUtil.isEmpty(list)) {
            return new LayuiGridData((Page)list, (LayuiGridParam)param);
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    @Transactional
    public void delete(CStaffDeleteParam param) {
        Long staffId = param.getStaffId();
        if (staffId == null) {
            return;
        }
        CStaff staff = (CStaff)this.cStaffService.getById(staffId);
        if (staff == null) {
            return;
        }
        if (this.hasRelatedData(staff.getBaseId()).booleanValue()) {
            throw new ServiceException("\u4eba\u5458\u65e0\u6cd5\u5220\u9664");
        }
        this.riskBasicSourceService.deleteByBaseIdAndCid(staff.getBaseId(), staff.getCid());
        staff.setUniqueReference(String.valueOf(staff.getId()));
        this.cStaffService.updateById(staff);
        this.cStaffService.removeById(staff.getId());
    }

    @Override
    public StaffArchiveListVo getInfo(StaffInfoParam param) {
        SysFileVo sysFileVo;
        StaffArchiveListVo vo = ((CStaffBaseInfoMapper)this.baseMapper).getInfoById(param);
        if (vo == null) {
            return null;
        }
        if (vo.getHeadId() != null && (sysFileVo = this.fileProvider.getFileById(vo.getHeadId())) != null) {
            vo.setHeadFileName(sysFileVo.getFileName());
            vo.setHeadFileUrl(sysFileVo.getFullOssUrl());
        }
        if (vo.getSubCid() != null) {
            CompanyAddressVo companyAddressVo = this.companyAddressProvider.getOneAddressVo(vo.getSubCid());
            vo.setCompanyAddressVo(companyAddressVo);
        }
        vo.setCertConditionVo(this.rayCertProvider.getCertCondition(vo.getId()));
        vo.setThresholdTime(this.getThresholdTime(param.getId(), param.getCid()));
        vo.setHasRelatedData(Integer.valueOf(this.hasRelatedData(param.getId()) != false ? 1 : 0));
        return vo;
    }

    @Override
    public Boolean hasRelatedData(Long staffBaseInfo) {
        CHealthCheckData lastData1 = this.healthCheckDataService.getLastData(staffBaseInfo);
        CDoseData lastData2 = this.doseDataProvider.getLastData(staffBaseInfo);
        CTrainingCert lastData3 = this.trainingCertService.getLastData(staffBaseInfo);
        return lastData1 != null || lastData2 != null || lastData3 != null;
    }

    @Override
    public StaffArchiveListVo getRayManagerInfo(StaffInfoParam param) {
        StaffArchiveListVo result = new StaffArchiveListVo();
        StaffArchiveListVo db = ((CStaffBaseInfoMapper)this.baseMapper).getInfoById(param);
        result.setId(db.getId());
        result.setName(db.getName());
        result.setIfRaManager(db.getIfRaManager());
        result.setStaffType(db.getStaffType());
        result.setPhone(db.getPhone());
        return result;
    }

    private LocalDateTime getThresholdTime(Long staffBaseInfoId, Long cid) {
        CStaff staff = this.cStaffService.getMaxTime(staffBaseInfoId, cid);
        if (staff == null) {
            return null;
        }
        ArrayList<LocalDateTime> list = new ArrayList<LocalDateTime>();
        LocalDateTime postStartTime = staff.getPostStartTime();
        LocalDateTime postDepartureTime = staff.getPostDepartureTime();
        LocalDateTime tpPostDepartureTime = staff.getTpPostDepartureTime();
        if (postStartTime != null) {
            list.add(postStartTime);
        }
        if (postDepartureTime != null) {
            list.add(postDepartureTime);
        }
        if (tpPostDepartureTime != null) {
            list.add(tpPostDepartureTime);
        }
        if (CollUtil.isEmpty(list)) {
            return null;
        }
        CollUtil.sort(list, Comparator.reverseOrder());
        return (LocalDateTime)list.get(0);
    }

    @Override
    public StaffArchiveStatisticsCMVo getStaffArchiveStatistics(StaffStatisticsParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getStaffArchiveStatistics(param);
    }

    @Override
    public LayuiGridData<StaffChooseListVo> getChooseList(StaffChooseListPageParam param) {
        param.setKeywordEn(param.getKeyword());
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<StaffChooseListVo> list = ((CStaffBaseInfoMapper)this.baseMapper).getChooseList(param);
        for (StaffChooseListVo vo : list) {
            String idCard = vo.getIdCard();
            boolean validCard = IdcardUtil.isValidCard((String)idCard);
            if (!validCard) continue;
            vo.setSex(Integer.valueOf(IdcardUtil.getGenderByIdCard((String)idCard)));
            vo.setAge(Integer.valueOf(IdcardUtil.getAgeByIdCard((String)idCard)));
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public LayuiGridData<RayStaffListVo> rayStaffList(RayStaffQueryParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<RayStaffListVo> list = ((CStaffBaseInfoMapper)this.baseMapper).rayStaffList(param);
        for (RayStaffListVo vo : list) {
            vo.setThresholdTime(this.getThresholdTime(vo.getId(), param.getCid()));
            vo.desensitizeNameTotal();
        }
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public HomeData31 getHomeData31(Long cid) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getHomeData31(cid);
    }

    @Override
    public StaffAcVo getAcInfo(StaffAcInfoParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getAcInfo(param);
    }

    @Override
    public CompanyStaffArchiveStatisticsVo getCMStaffArchiveStatistics(StaffStatisticsParam param) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getCMStaffArchiveStatistics(param);
    }

    @Override
    public boolean hasIdCardConflict(Long id, String idCard) {
        if (StrUtil.isEmpty((CharSequence)idCard)) {
            return false;
        }
        CStaffBaseInfo entity = this.getOneByIdCard(idCard);
        return entity != null && !entity.getId().equals(id);
    }

    @Override
    public CStaffBaseInfo getOneByIdCard(String idCard) {
        if (StrUtil.isBlank((CharSequence)idCard)) {
            return null;
        }
        String idCardEn = SpringEncryptUtils.encrypt((String)idCard);
        CStaffBaseInfo oneByIdCardEn = ((CStaffBaseInfoMapper)this.baseMapper).getOneByIdCard(idCardEn);
        CStaffBaseInfo oneByIdCard = ((CStaffBaseInfoMapper)this.baseMapper).getOneByIdCard(idCard);
        if (oneByIdCardEn != null && oneByIdCard != null && !oneByIdCardEn.getId().equals(oneByIdCard.getId())) {
            throw new ServiceException("error:\u4eba\u5458\u6570\u636e\u91cd\u590d,\u5931\u8d25,idCard:" + DesensitizationUtils.desensitized((CharSequence)idCard, (DesensitizationType)DesensitizationType.ID_CARD));
        }
        return oneByIdCardEn != null ? oneByIdCardEn : oneByIdCard;
    }

    @Override
    public Long getStaffCid(Long staffBaseInfoId, Long loginUserCid) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getStaffCid(staffBaseInfoId, loginUserCid);
    }

    @Override
    public void importStaff(List<StaffImportDto> cachedDataList) {
    }

    @Override
    public List<Long> getCidListForView(Long staffBaseInfoId) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getCidListForView(staffBaseInfoId);
    }

    @Override
    public List<Long> getCidList(Long id) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getCidList(id);
    }

    @Override
    public List<Long> getCidListForCheckRange(Long staffBaseInfoId) {
        return ((CStaffBaseInfoMapper)this.baseMapper).getCidListForCheckRange(staffBaseInfoId);
    }
}

