/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.b;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.TreeUtil;
import cn.hutool.core.util.StrUtil;
import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.modules.company.converter.BOrgConverter;
import cn.smarthse.rho.modules.company.dao.b.BOrgMapper;
import cn.smarthse.rho.modules.company.service.b.IBOrgService;
import cn.smarthse.rho.modules.sys.entity.b.BOrg;
import cn.smarthse.rho.modules.sys.model.b.param.BOrgEditParam;
import cn.smarthse.rho.modules.sys.model.b.param.BOrgInfoParam;
import cn.smarthse.rho.modules.sys.model.b.param.BOrgStatisticsParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BOrgStatisticsVo;
import cn.smarthse.rho.modules.sys.model.b.vo.BOrgVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.time.LocalDateTime;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class BOrgServiceImpl
extends ServiceImpl<BOrgMapper, BOrg>
implements IBOrgService {
    private final BOrgConverter bOrgConverter;
    @Autowired
    private ApplicationContext context;

    @Override
    @Transactional
    public List<Tree<String>> getTree(BOrgInfoParam param) {
        if (param.getCid() == null) {
            throw new ServiceException("\u516c\u53f8id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List nodeList = ((BOrgMapper)this.baseMapper).getListIncludeStaffNum(param);
        nodeList = CollUtil.sort(nodeList, (o1, o2) -> o2.getCreateDate().compareTo(o1.getCreateDate()));
        for (int i = 0; i < nodeList.size(); ++i) {
            ((BOrgVo)nodeList.get(i)).setOrderNum(Integer.valueOf(i + 1));
        }
        TreeNodeConfig treeNodeConfig = new TreeNodeConfig();
        treeNodeConfig.setIdKey("id");
        treeNodeConfig.setParentIdKey("pid");
        treeNodeConfig.setNameKey("name");
        treeNodeConfig.setWeightKey("orderNum");
        treeNodeConfig.setDeep(Integer.valueOf(100));
        List treeNodes = TreeUtil.build((List)nodeList, (Object)(param.getPid() == null ? "0" : String.valueOf(param.getPid())), (TreeNodeConfig)treeNodeConfig, (treeNode, tree) -> {
            tree.setId((Object)String.valueOf(treeNode.getId()));
            tree.setParentId((Object)String.valueOf(treeNode.getPid()));
            tree.setName((CharSequence)treeNode.getName());
            tree.putExtra("staffNum", (Object)treeNode.getStaffNum());
            tree.putExtra("orderNum", (Object)treeNode.getOrderNum());
        });
        return treeNodes;
    }

    @Override
    public List<BOrgVo> getByIds(List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.lambda().in(BOrg::getId, ids);
        return this.bOrgConverter.entityList2VoList(this.list((Wrapper)wrapper));
    }

    @Override
    @Transactional
    public BOrgVo addInfo(BOrgEditParam param) {
        BOrg bOrg = this.bOrgConverter.param2Entity(param);
        bOrg.setEditTime(LocalDateTime.now());
        ((BOrgMapper)this.baseMapper).insert(bOrg);
        if (bOrg.getPid() != 0L) {
            BOrg parent = (BOrg)this.getById(bOrg.getPid());
            StringBuffer sb = new StringBuffer();
            sb.append(parent.getCascadeId()).append(",").append(bOrg.getId());
            StringBuffer sbName = new StringBuffer().append(parent.getCascadeName()).append(",").append(bOrg.getName());
            bOrg.setCascadeId(sb.toString());
            bOrg.setCascadeName(sbName.toString());
            ((BOrgMapper)this.baseMapper).updateById(bOrg);
        } else {
            bOrg.setCascadeId(String.valueOf(bOrg.getId()));
            bOrg.setCascadeName(bOrg.getName());
            ((BOrgMapper)this.baseMapper).updateById(bOrg);
        }
        return this.bOrgConverter.entity2Vo(bOrg);
    }

    @Override
    @Transactional
    public BOrgVo editInfo(BOrgEditParam param) {
        if (param.getId() == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        BOrg bOrg = this.bOrgConverter.param2Entity(param);
        bOrg.setEditTime(LocalDateTime.now());
        if (bOrg.getPid() != 0L) {
            BOrg parent = (BOrg)this.getById(bOrg.getPid());
            StringBuffer sb = new StringBuffer().append(parent.getCascadeId()).append(",").append(bOrg.getId());
            StringBuffer sbName = new StringBuffer().append(parent.getCascadeName()).append(",").append(bOrg.getName());
            bOrg.setCascadeId(sb.toString());
            bOrg.setCascadeName(sbName.toString());
            ((BOrgMapper)this.baseMapper).updateById(bOrg);
        } else {
            bOrg.setCascadeId(String.valueOf(bOrg.getId()));
            bOrg.setCascadeName(bOrg.getName());
            ((BOrgMapper)this.baseMapper).updateById(bOrg);
        }
        return this.bOrgConverter.entity2Vo(bOrg);
    }

    @Override
    @Transactional
    public void removeInfo(BOrgEditParam param) {
        if (param.getId() == null) {
            throw new ServiceException("\u53c2\u6570\u9519\u8bef");
        }
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.lambda().set(BaseEntity::getIsValid, (Object)false)).like(BOrg::getCascadeId, (Object)param.getId());
        ((BOrgMapper)this.baseMapper).update((Wrapper)updateWrapper);
        UpdateWrapper updateWrapper2 = new UpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper2.lambda().set(BaseEntity::getIsValid, (Object)false)).eq(BOrg::getId, (Object)param.getId());
        ((BOrgMapper)this.baseMapper).update((Wrapper)updateWrapper2);
    }

    @Override
    public BOrgStatisticsVo getCountWithDepartmentNum(BOrgStatisticsParam param) {
        return ((BOrgMapper)this.baseMapper).getCountWithDepartmentNum(param);
    }

    @Override
    public String getNameById(Long id) {
        if (id == null) {
            return "";
        }
        BOrg org = (BOrg)this.getById(id);
        if (org == null) {
            return "";
        }
        return org.getName();
    }

    @Override
    public String getNameByIds(String ids) {
        if (ids == null || ids.isEmpty()) {
            return "";
        }
        String[] idArray = ids.split(",");
        StringBuilder rst = new StringBuilder();
        for (String id : idArray) {
            BOrg org = (BOrg)this.getById(Long.valueOf(id));
            if (org == null) continue;
            rst.append(org.getName()).append(",");
        }
        return rst.toString();
    }

    @Override
    public BOrg getCompanyOrgByCascadeName(Long cid, String cascadeName) {
        return ((BOrgMapper)this.baseMapper).getCompanyOrgByCascadeName(cid, cascadeName);
    }

    @Override
    public BOrg getCompanyOrgByCascadeName(Long cid, String cascadeName, String separator) {
        if (StrUtil.isBlank((CharSequence)separator)) {
            return ((BOrgMapper)this.baseMapper).getCompanyOrgByCascadeName(cid, cascadeName);
        }
        return ((BOrgMapper)this.baseMapper).getCompanyOrgByCascadeName(cid, StrUtil.replace((CharSequence)cascadeName, (CharSequence)separator, (CharSequence)","));
    }

    @Generated
    public BOrgServiceImpl(BOrgConverter bOrgConverter) {
        this.bOrgConverter = bOrgConverter;
    }
}

