/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.service.impl.b;

import cn.smarthse.framework.mybatisPlus.service.impl.ServiceImpl;
import cn.smarthse.rho.core.framework.model.BaseEntity;
import cn.smarthse.rho.modules.company.dao.b.BCompanyErrorDeviceMapper;
import cn.smarthse.rho.modules.company.service.b.IBCompanyErrorDeviceService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceRayService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceSourceService;
import cn.smarthse.rho.modules.company.service.e.IErelationService;
import cn.smarthse.rho.modules.company.service.e.IEsourceNonSealedService;
import cn.smarthse.rho.modules.company.service.e.IEsourceSealedService;
import cn.smarthse.rho.modules.sys.entity.b.BCompanyErrorDevice;
import cn.smarthse.rho.modules.sys.entity.e.EDevice;
import cn.smarthse.rho.modules.sys.entity.e.EDeviceRay;
import cn.smarthse.rho.modules.sys.entity.e.EDeviceSource;
import cn.smarthse.rho.modules.sys.entity.e.ESourceNonSealed;
import cn.smarthse.rho.modules.sys.entity.e.ESourceSealed;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceDiagnosisTypeEnum;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.BCompanyErrorDeviceCodeEnum;
import cn.smarthse.rho.modules.sys.model.e.param.EDeviceListParam;
import cn.smarthse.rho.modules.sys.model.e.param.ERelationDto;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceErrorInfoVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@Transactional(readOnly=true)
public class BCompanyErrorDeviceServiceImpl
extends ServiceImpl<BCompanyErrorDeviceMapper, BCompanyErrorDevice>
implements IBCompanyErrorDeviceService {
    @Autowired
    private IErelationService relationService;
    @Autowired
    private IEdeviceRayService deviceRayService;
    @Autowired
    private IEsourceNonSealedService sourceNonSealedService;
    @Autowired
    private IEsourceSealedService sourceSealedService;
    @Autowired
    private IEdeviceSourceService deviceSourceService;

    @Override
    public List<EDeviceErrorInfoVo> listErrorInfoForDevice(EDeviceListParam param) {
        return ((BCompanyErrorDeviceMapper)this.baseMapper).listErrorInfoForDevice(param);
    }

    @Override
    public List<EDeviceErrorInfoVo> listErrorInfoForDevice(Long deviceId) {
        if (deviceId == null) {
            return null;
        }
        EDeviceListParam param = new EDeviceListParam();
        param.setId(deviceId);
        return this.listErrorInfoForDevice(param);
    }

    @Override
    @Transactional
    public Boolean checkErrorForDevice(EDevice device) {
        ArrayList<BCompanyErrorDevice> errorInfoList = new ArrayList<BCompanyErrorDevice>();
        Integer deviceType = device.getType();
        Long deviceId = device.getId();
        Long cid = device.getCid();
        if (Objects.equals(deviceType, EdeviceTypeEnum.DEVICE_RAY.getValue())) {
            List<ERelationDto> eRelationDtos = this.relationService.listCurRelationByType(4, deviceId);
            EDeviceRay rayDto = this.deviceRayService.getDeviceRayByDid(deviceId);
            if (!StringUtils.hasLength((String)device.getName())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_1.getCode()));
            }
            if (rayDto == null || !StringUtils.hasLength((String)rayDto.getModel())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_2.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getFactory())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_3.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getFactoryNo())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_4.getCode()));
            }
            if (rayDto == null || !StringUtils.hasLength((String)rayDto.getParameters())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_5.getCode()));
            }
            if (device.getStatus() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_6.getCode()));
            }
            if (rayDto == null || rayDto.getMobilityType() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_7.getCode()));
            }
            if (rayDto == null || rayDto.getCategory() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_8.getCode()));
            }
            if (rayDto == null || rayDto.getDiagnosisType() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_9.getCode()));
            }
            if (rayDto == null || rayDto.getDiagnosisType() != null && (EdeviceDiagnosisTypeEnum.isXRAYForError((Integer)Integer.valueOf(rayDto.getDiagnosisType())) || EdeviceDiagnosisTypeEnum.isINTERVENTIONALForError((Integer)Integer.valueOf(rayDto.getDiagnosisType()))) && rayDto.getCheckType() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_10.getCode()));
            }
            if (rayDto == null || rayDto.getProductionDate() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_11.getCode()));
            }
            if (device.getStatus() != null && device.getStatus() == 1 && rayDto != null && (rayDto.getIsBedside() == null || rayDto.getIsBedside() != 1) && CollectionUtils.isEmpty(eRelationDtos)) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_12.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getUseDepartmentId())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_13.getCode()));
            }
            if (rayDto == null || !StringUtils.hasLength((String)rayDto.getPersonInCharge())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_14.getCode()));
            }
        } else if (Objects.equals(deviceType, EdeviceTypeEnum.SOURCE_NON_SEALED.getValue())) {
            relationList = this.relationService.listCurRelationByType(1, deviceId);
            ESourceNonSealed sourceNonSealedDto = this.sourceNonSealedService.getNonSealedByDid(deviceId);
            if (!StringUtils.hasLength((String)device.getName())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_15.getCode()));
            }
            if (sourceNonSealedDto == null || sourceNonSealedDto.getPhysicalState() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_16.getCode()));
            }
            if (sourceNonSealedDto == null || sourceNonSealedDto.getData1() == null || sourceNonSealedDto.getData2() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_17.getCode()));
            }
            if (sourceNonSealedDto == null || sourceNonSealedDto.getData3() == null || sourceNonSealedDto.getData4() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_18.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getUseDepartmentId())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_19.getCode()));
            }
            if (sourceNonSealedDto == null || !StringUtils.hasLength((String)sourceNonSealedDto.getPersonInCharge())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_20.getCode()));
            }
            if (CollectionUtils.isEmpty(relationList)) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_21.getCode()));
            }
        } else if (Objects.equals(deviceType, EdeviceTypeEnum.SOURCE_SEALED.getValue())) {
            relationList = this.relationService.listCurRelationByType(1, deviceId);
            ESourceSealed sourceSealedDto = this.sourceSealedService.getSourceSealedByDid(deviceId);
            if (!StringUtils.hasLength((String)device.getName())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_22.getCode()));
            }
            if (sourceSealedDto == null || sourceSealedDto.getData1() == null || sourceSealedDto.getData2() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_23.getCode()));
            }
            if (sourceSealedDto == null || sourceSealedDto.getMeasurementDate() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_24.getCode()));
            }
            if (device.getFactory() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_25.getCode()));
            }
            if (device.getStatus() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_26.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getUseDepartmentId())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_27.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getUseTo())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_28.getCode()));
            }
            if (sourceSealedDto == null || !StringUtils.hasLength((String)sourceSealedDto.getPersonInCharge())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_29.getCode()));
            }
            if (CollectionUtils.isEmpty(relationList)) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_30.getCode()));
            }
        } else if (Objects.equals(deviceType, EdeviceTypeEnum.DEVICE_SOURCE.getValue())) {
            List<ERelationDto> roomRelationList = this.relationService.listCurRelationByType(4, deviceId);
            List<ERelationDto> sourceRelationList = this.relationService.listCurRelationByType(5, deviceId);
            EDeviceSource deviceSourceDto = this.deviceSourceService.getDeviceSourceByDid(deviceId);
            if (!StringUtils.hasLength((String)device.getName())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_31.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getFactoryNo())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_32.getCode()));
            }
            if (deviceSourceDto == null || !StringUtils.hasLength((String)deviceSourceDto.getModel())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_33.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getFactory())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_34.getCode()));
            }
            if (deviceSourceDto == null || !StringUtils.hasLength((String)deviceSourceDto.getDiagnosisType())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_35.getCode()));
            }
            if (device.getStatus() == null) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_36.getCode()));
            }
            if (device.getStatus() != null && device.getStatus() == 1 && CollectionUtils.isEmpty(roomRelationList)) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_37.getCode()));
            }
            if (!StringUtils.hasLength((String)device.getUseDepartmentId())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_38.getCode()));
            }
            if (deviceSourceDto == null || !StringUtils.hasLength((String)deviceSourceDto.getPersonInCharge())) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_39.getCode()));
            }
            if (CollectionUtils.isEmpty(sourceRelationList)) {
                errorInfoList.add(new BCompanyErrorDevice(cid, deviceId, BCompanyErrorDeviceCodeEnum.DEVICE_ERR_CODE_40.getCode()));
            }
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BCompanyErrorDevice::getDid, (Object)deviceId)).eq(BaseEntity::getIsValid, (Object)1);
        List dbErrorList = this.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)dbErrorList)) {
            List<BCompanyErrorDevice> toAdd;
            List<BCompanyErrorDevice> toRemove = dbErrorList.stream().filter(dbError -> errorInfoList.stream().noneMatch(currentError -> Objects.equals(currentError.getErrCode(), dbError.getErrCode()))).toList();
            if (!toRemove.isEmpty()) {
                List<Long> removeIds = toRemove.stream().map(BCompanyErrorDevice::getId).toList();
                this.removeByIds(removeIds);
            }
            if (!(toAdd = errorInfoList.stream().filter(currentError -> dbErrorList.stream().noneMatch(dbError -> Objects.equals(dbError.getErrCode(), currentError.getErrCode()))).toList()).isEmpty()) {
                this.saveBatch(toAdd);
            }
        } else {
            this.saveBatch(errorInfoList);
        }
        queryWrapper.clear();
        ((LambdaQueryWrapper)queryWrapper.eq(BCompanyErrorDevice::getDid, (Object)deviceId)).eq(BaseEntity::getIsValid, (Object)1);
        return !this.list((Wrapper)queryWrapper).isEmpty();
    }

    @Override
    @Transactional
    public void delErrorForDevice(Long deviceId) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)updateWrapper.set(BaseEntity::getIsValid, (Object)0)).eq(BCompanyErrorDevice::getDid, (Object)deviceId);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    @Transactional
    public void delErrorByDeviceAndErrorCode(Long deviceId, Integer errorCode) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(BaseEntity::getIsValid, (Object)0)).eq(BCompanyErrorDevice::getDid, (Object)deviceId)).eq(BCompanyErrorDevice::getErrCode, (Object)errorCode);
        this.update((Wrapper)updateWrapper);
    }

    @Override
    @Transactional
    public void addErrorForDevice(Long cid, Long deviceId, Integer errorCode) {
        this.save(new BCompanyErrorDevice(cid, deviceId, errorCode));
    }

    @Generated
    public BCompanyErrorDeviceServiceImpl() {
    }
}

