/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.manage.home;

import cn.smarthse.rho.modules.company.converter.BStatisticConverter;
import cn.smarthse.rho.modules.company.service.b.IBCompanyService;
import cn.smarthse.rho.modules.company.service.b.IBStatisticService;
import cn.smarthse.rho.modules.company.service.c.ICStaffBaseInfoService;
import cn.smarthse.rho.modules.company.service.c.ICTrainingService;
import cn.smarthse.rho.modules.company.service.e.IEdeviceRayService;
import cn.smarthse.rho.modules.company.service.e.IEmachineRoomService;
import cn.smarthse.rho.modules.company.service.e.IEsourceNonSealedService;
import cn.smarthse.rho.modules.company.service.e.IEsourceSealedService;
import cn.smarthse.rho.modules.sys.entity.b.BStatistic;
import cn.smarthse.rho.modules.sys.enums.company.EdeviceTypeEnum;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.model.b.param.BCompanyInfoParam;
import cn.smarthse.rho.modules.sys.model.e.vo.CmEDeviceRayStatisticsVo;
import cn.smarthse.rho.modules.sys.model.e.vo.CmEDeviceStatisticsVo;
import cn.smarthse.rho.modules.sys.model.e.vo.CmESourceNonSealedStatisticsVo;
import cn.smarthse.rho.modules.sys.model.e.vo.EMachineRoomLevelStatisticsVo;
import cn.smarthse.rho.modules.sys.model.home.vo.HomeData1;
import cn.smarthse.rho.modules.sys.model.home.vo.HomeData2;
import cn.smarthse.rho.modules.sys.model.home.vo.HomeData2Detail;
import cn.smarthse.rho.modules.sys.model.home.vo.HomeData31;
import cn.smarthse.rho.modules.sys.model.home.vo.HomeData32;
import cn.smarthse.rho.modules.sys.model.home.vo.HomeData33;
import cn.smarthse.rho.modules.sys.model.home.vo.HomeData34;
import cn.smarthse.rho.modules.sys.model.home.vo.HomeData41;
import cn.smarthse.rho.modules.sys.model.home.vo.HomeData42;
import cn.smarthse.rho.modules.sys.model.home.vo.HomeData42Detail1;
import cn.smarthse.rho.modules.sys.provider.c.ICDoseDataProvider;
import cn.smarthse.rho.modules.sys.provider.c.ICHealthCheckDataProvider;
import cn.smarthse.rho.modules.sys.provider.company.IBCertProvider;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class HomeManage {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HomeManage.class);
    private final IBCompanyService companyService;
    private final IBStatisticService bStatisticService;
    private final ICStaffBaseInfoService cStaffService;
    private final ICTrainingService cTrainingService;
    private final IEdeviceRayService deviceRayService;
    private final IEmachineRoomService machineRoomService;
    private final IEsourceSealedService sourceSealedService;
    private final IEsourceNonSealedService sourceNonSealedService;
    private final BStatisticConverter converter;
    @DubboReference
    private ICDoseDataProvider doseDataProvider;
    @DubboReference
    private IBCertProvider certService;
    @DubboReference
    private ICHealthCheckDataProvider healthCheckDataService;

    public HomeData1 getBaseInfo(Long cid) {
        BCompanyInfoParam param = new BCompanyInfoParam();
        param.setCid(cid);
        HomeData1 result = this.converter.BCompanyVo2HomeData1(this.companyService.getBaseInfoById(param));
        if (result == null) {
            return new HomeData1();
        }
        BStatistic bStatistic = this.bStatisticService.getByCid(cid, LocalDate.now().getYear());
        if (bStatistic != null) {
            result.setSuperviseTimes(bStatistic.getSuperviseTimes());
            result.setEnforcementTimes(bStatistic.getEnforcementTimes());
            result.setDiseaseAddNum(bStatistic.getDiseaseAddNum());
            result.setDiseaseNum(bStatistic.getDiseaseNum());
        }
        return result;
    }

    public HomeData2 getHomeData2(Long cid) {
        int year = LocalDate.now().getYear();
        final HomeData2 homeData2 = this.bStatisticService.getRiskWarningStatisticsByCid(cid, year);
        if (homeData2 == null) {
            return new HomeData2();
        }
        List<HomeData2Detail> statisticsByCid = this.bStatisticService.getRiskHomeStatisticsByCid(cid, year);
        if (!CollectionUtils.isEmpty(statisticsByCid)) {
            HashMap<Integer, Consumer<HomeData2Detail>> detailSetterMap = new HashMap<Integer, Consumer<HomeData2Detail>>(){
                {
                    this.put(RiskTypeEnum.LICENSE_MANAGEMENT.getValue(), arg_0 -> ((HomeData2)homeData2).setDetail101(arg_0));
                    this.put(RiskTypeEnum.PERFORMANCE_TEST.getValue(), arg_0 -> ((HomeData2)homeData2).setDetail102(arg_0));
                    this.put(RiskTypeEnum.PLACE_TEST.getValue(), arg_0 -> ((HomeData2)homeData2).setDetail103(arg_0));
                    this.put(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue(), arg_0 -> ((HomeData2)homeData2).setDetail104(arg_0));
                    this.put(RiskTypeEnum.DOSE_MONITORING.getValue(), arg_0 -> ((HomeData2)homeData2).setDetail105(arg_0));
                    this.put(RiskTypeEnum.TRAINING.getValue(), arg_0 -> ((HomeData2)homeData2).setDetail106(arg_0));
                    this.put(RiskTypeEnum.PERSONAL_PROTECTIVE_EQUIPMENT.getValue(), arg_0 -> ((HomeData2)homeData2).setDetail108(arg_0));
                    this.put(RiskTypeEnum.SAFETY_DEVICES_AND_ALERTS.getValue(), arg_0 -> ((HomeData2)homeData2).setDetail109(arg_0));
                    this.put(RiskTypeEnum.EXCEPTION_PERFORMANCE_TEST.getValue(), arg_0 -> ((HomeData2)homeData2).setDetail102001(arg_0));
                    this.put(RiskTypeEnum.EXCEPTION_PLACE_TEST.getValue(), arg_0 -> ((HomeData2)homeData2).setDetail103001(arg_0));
                    this.put(RiskTypeEnum.PHYSICAL_EXCEPTION_OCC.getValue(), arg_0 -> ((HomeData2)homeData2).setDetail104004(arg_0));
                    this.put(RiskTypeEnum.PHYSICAL_EXCEPTION_CONTRAINDICATION.getValue(), arg_0 -> ((HomeData2)homeData2).setDetail104005(arg_0));
                    this.put(RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue(), arg_0 -> ((HomeData2)homeData2).setDetail104006(arg_0));
                    this.put(RiskTypeEnum.DOSE_EXCEPTION_OVERDOSE.getValue(), arg_0 -> ((HomeData2)homeData2).setDetail105002(arg_0));
                }
            };
            statisticsByCid.forEach(item -> {
                Consumer setter;
                if (item.getRiskType() != null && (setter = (Consumer)detailSetterMap.get(item.getRiskType())) != null) {
                    setter.accept(item);
                }
            });
        }
        return homeData2;
    }

    public HomeData31 getHomeData31(Long cid) {
        return this.cStaffService.getHomeData31(cid);
    }

    public HomeData32 getHomeData32(Long cid) {
        return this.cTrainingService.getHomeData32(cid);
    }

    public HomeData33 getHomeData33(Long cid) {
        return this.healthCheckDataService.getHomeData33(cid);
    }

    public HomeData34 getHomeData34(Long cid) {
        return this.doseDataProvider.getHomeData34(cid);
    }

    public HomeData41 getHomeData41(Long cid) {
        return this.certService.getHomeData41ByCid(cid);
    }

    public HomeData42 getHomeData42(Long cid) {
        HomeData42 result = new HomeData42();
        CmEDeviceRayStatisticsVo deviceRayStatisticsVo = this.deviceRayService.deviceRayStatisticsForCompany(new BCompanyInfoParam().setCid(cid));
        result.setNum1(deviceRayStatisticsVo.getRadiationTherapyNum().intValue());
        result.setNum2(deviceRayStatisticsVo.getNuclearNum().intValue());
        result.setNum3(deviceRayStatisticsVo.getInterventionalNum().intValue());
        result.setNum4(deviceRayStatisticsVo.getXrayNum().intValue());
        try {
            CmESourceNonSealedStatisticsVo nonSealedStatisticsVo = this.sourceNonSealedService.sourceNonSealedStatisticsForCompany(new BCompanyInfoParam().setCid(cid));
            result.setNum5_1(nonSealedStatisticsVo.getData1());
            result.setNum5_2(nonSealedStatisticsVo.getData2());
            result.setNum6_1(nonSealedStatisticsVo.getData3());
            result.setNum6_2(nonSealedStatisticsVo.getData4());
            result.setNum5(result.getNum5_1() + "E+" + result.getNum5_2());
            result.setNum6(result.getNum6_1() + "E+" + result.getNum6_2());
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        EMachineRoomLevelStatisticsVo machineRoomLevelVo = this.machineRoomService.getLevelStatistics(cid, EdeviceTypeEnum.SOURCE_NON_SEALED.getValue());
        result.setNum7(machineRoomLevelVo.getGradeANum());
        result.setNum8(machineRoomLevelVo.getGradeBNum());
        result.setNum9(machineRoomLevelVo.getGradeCNum());
        try {
            List<CmEDeviceStatisticsVo> sealedSourceStatistics = this.sourceSealedService.sealedSourceStatistics(new BCompanyInfoParam().setCid(cid));
            List<CmEDeviceStatisticsVo> includeSealedSourceStatistics = this.sourceSealedService.includeSealedSourceStatistics(new BCompanyInfoParam().setCid(cid));
            ArrayList<HomeData42Detail1> sourceSealedStatisticsList = new ArrayList<HomeData42Detail1>();
            for (CmEDeviceStatisticsVo t : sealedSourceStatistics) {
                HomeData42Detail1 detail42_1 = new HomeData42Detail1();
                detail42_1.setName(t.getName());
                detail42_1.setNum(t.getTotal().intValue());
                detail42_1.setData1Total(t.getData1Total());
                detail42_1.setData2Total(t.getData2Total());
                sourceSealedStatisticsList.add(detail42_1);
            }
            result.setSealedSources(sourceSealedStatisticsList);
            ArrayList<HomeData42Detail1> sealedDeviceSourceStatisticsList = new ArrayList<HomeData42Detail1>();
            for (CmEDeviceStatisticsVo t : includeSealedSourceStatistics) {
                HomeData42Detail1 detail42_1 = new HomeData42Detail1();
                detail42_1.setName(t.getName());
                detail42_1.setNum(t.getTotal().intValue());
                detail42_1.setData1Total(t.getData1Total());
                detail42_1.setData2Total(t.getData2Total());
                sealedDeviceSourceStatisticsList.add(detail42_1);
            }
            result.setSealedSourceDevices(sealedDeviceSourceStatisticsList);
        }
        catch (Exception e) {
            log.error(e.toString());
        }
        return result;
    }

    @Generated
    public HomeManage(IBCompanyService companyService, IBStatisticService bStatisticService, ICStaffBaseInfoService cStaffService, ICTrainingService cTrainingService, IEdeviceRayService deviceRayService, IEmachineRoomService machineRoomService, IEsourceSealedService sourceSealedService, IEsourceNonSealedService sourceNonSealedService, BStatisticConverter converter) {
        this.companyService = companyService;
        this.bStatisticService = bStatisticService;
        this.cStaffService = cStaffService;
        this.cTrainingService = cTrainingService;
        this.deviceRayService = deviceRayService;
        this.machineRoomService = machineRoomService;
        this.sourceSealedService = sourceSealedService;
        this.sourceNonSealedService = sourceNonSealedService;
        this.converter = converter;
    }
}

