/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.easyexcel;

import cn.hutool.core.util.StrUtil;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.sys.model.c.vo.staff.StaffRelocationImportResultVo;
import cn.smarthse.rho.modules.sys.model.easyexcel.staff.StaffRelocationImportDto;
import cn.smarthse.rho.modules.sys.provider.c.IStaffRelocationProvider;
import cn.smarthse.rho.modules.sys.utils.staff.StaffNameStorageUtil;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.alibaba.fastjson2.JSON;
import java.util.ArrayList;
import java.util.List;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaffRelocationImportListener
extends AnalysisEventListener<StaffRelocationImportDto> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StaffRelocationImportListener.class);
    private static final int BATCH_COUNT = 3000;
    private List<StaffRelocationImportDto> cachedDataList = new ArrayList<StaffRelocationImportDto>();
    private List<StaffRelocationImportResultVo> resultList;
    private IStaffRelocationProvider staffRelocationProvider;

    public StaffRelocationImportListener(IStaffRelocationProvider staffRelocationProvider, List<StaffRelocationImportResultVo> resultInfo) {
        this.staffRelocationProvider = staffRelocationProvider;
        this.resultList = resultInfo;
    }

    public void onException(Exception exception, AnalysisContext context) throws Exception {
        super.onException(exception, context);
    }

    public void invoke(StaffRelocationImportDto data, AnalysisContext context) {
        log.info("\u89e3\u6790\u5230\u4e00\u6761\u6570\u636e:{}", (Object)JSON.toJSONString((Object)data));
        data.setRowIndex(Integer.valueOf(context.readRowHolder().getRowIndex() + 1));
        data.setExcelRowIndex(context.readRowHolder().getRowIndex());
        this.trim(data);
        this.cachedDataList.add(data);
        if (this.cachedDataList.size() >= 3000) {
            throw new ServiceException("\u4e00\u6b21\u6700\u591a\u5bfc\u51653000\u4eba");
        }
    }

    private void trim(StaffRelocationImportDto data) {
        data.setName(StrUtil.trim((CharSequence)data.getName()));
        data.setIdcard(StrUtil.trim((CharSequence)data.getIdcard()));
        data.setName(StaffNameStorageUtil.dealName((String)data.getName()));
        data.setIdcard(StrUtil.toUpperCase((CharSequence)data.getIdcard()));
    }

    public void doAfterAllAnalysed(AnalysisContext context) {
        this.saveData();
        this.cachedDataList.clear();
        log.info("\u6240\u6709\u6570\u636e\u89e3\u6790\u5b8c\u6210\uff01");
    }

    private void saveData() {
        log.info("{}\u6761\u6570\u636e\uff0c\u5f00\u59cb\u5b58\u50a8\u6570\u636e\u5e93\uff01", (Object)this.cachedDataList.size());
        this.resultList.addAll(this.staffRelocationProvider.importRelocationStaff(this.cachedDataList, ShiroUtil.getLoginUserCid()));
        log.info("\u5b58\u50a8\u6570\u636e\u5e93\u6210\u529f\uff01");
    }
}

