/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.risk;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.encrypt.annotation.ApiEncrypt;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.modules.excel.BaseImportDto;
import cn.smarthse.rho.core.framework.annotation.Log;
import cn.smarthse.rho.core.framework.annotation.LogModuleTypeEnum;
import cn.smarthse.rho.core.framework.annotation.LogTypeEnum;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.core.framework.utils.CustomCellWriteWidthConfig;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.easyexcel.RiskBatchChooseImportListener;
import cn.smarthse.rho.modules.company.model.r.param.RiskAcceptRecordSubmitParam;
import cn.smarthse.rho.modules.company.model.r.param.RiskQueryParam;
import cn.smarthse.rho.modules.company.model.r.vo.RiskDetailListItemVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskDetailSourceVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskDetailStatisticDataVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskMenuStatisticsVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskResolutionListItemVo;
import cn.smarthse.rho.modules.company.model.r.vo.RiskResolutionStatisticsVo;
import cn.smarthse.rho.modules.company.service.r.IRRiskAcceptanceRecordService;
import cn.smarthse.rho.modules.company.service.r.IRRiskBasicService;
import cn.smarthse.rho.modules.company.service.r.IRRiskBasicSourceService;
import cn.smarthse.rho.modules.sys.enums.risk.RiskTypeEnum;
import cn.smarthse.rho.modules.sys.model.c.param.CheckOrgChooseQueryParam;
import cn.smarthse.rho.modules.sys.model.c.vo.ThirdOrgVo;
import cn.smarthse.rho.modules.sys.model.easyexcel.RiskBatchChooseExportDto1;
import cn.smarthse.rho.modules.sys.model.easyexcel.RiskBatchChooseExportDto2;
import cn.smarthse.rho.modules.sys.model.easyexcel.RiskBatchChooseExportDto3;
import cn.smarthse.rho.modules.sys.model.easyexcel.RiskBatchChooseExportDto4;
import cn.smarthse.rho.modules.sys.model.easyexcel.RiskBatchChooseExportDto5;
import cn.smarthse.rho.modules.sys.model.easyexcel.RiskBatchChooseImportDto;
import cn.smarthse.rho.modules.sys.model.r.param.RiskQueryCommonParam;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskAcceptanceCommonVo;
import cn.smarthse.rho.modules.sys.model.r.vo.RiskAcceptanceHistoryVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.provider.company.ICompanyErrorInfoProvider;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskAcceptanceProvider;
import cn.smarthse.rho.modules.sys.provider.risk.IRiskProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.exception.ExcelDataConvertException;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Objects;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/riskResolution"})
public class RiskResolutionController
extends ControllerSupport {
    @Autowired
    private OssClientBean ossClientBean;
    @Autowired
    private IRRiskBasicService riskBasicService;
    @Autowired
    private IRRiskBasicSourceService riskBasicSourceService;
    @Autowired
    private IRRiskAcceptanceRecordService acceptanceRecordService;
    @DubboReference
    private ISysFileProvider sysFileProvideService;
    @DubboReference
    private IRiskProvider riskProvider;
    @DubboReference
    private IRiskAcceptanceProvider acceptanceProvider;
    @DubboReference
    private ICompanyErrorInfoProvider companyErrorInfoProvider;

    @GetMapping(value={"/getRiskMenuStatisticsVo"})
    public ResponseData<RiskMenuStatisticsVo> getRiskMenuStatisticsVo() {
        return ResponseData.success((Object)this.riskBasicService.getRiskMenuStatisticsVo(ShiroUtil.getLoginUserCid()));
    }

    @GetMapping(value={"/getRiskResolutionStatisticsData"})
    public ResponseData<RiskResolutionStatisticsVo> getRiskResolutionStatisticsData(RiskQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.riskBasicService.getRiskResolutionStatisticsData(param));
    }

    @GetMapping(value={"/getRiskListData"})
    public ResponseData<LayuiGridData<RiskResolutionListItemVo>> getRiskListData(RiskQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.riskBasicService.getRiskListData(param));
    }

    @GetMapping(value={"/getRiskDetailListData"})
    public ResponseData<List<RiskDetailListItemVo>> getRiskDetailListData(Long riskId, Integer riskType) {
        return ResponseData.success(this.riskBasicService.getRiskDetailListData(riskId, riskType, ShiroUtil.getLoginUserCid()));
    }

    @GetMapping(value={"/getRiskStatisticData"})
    public ResponseData<RiskDetailStatisticDataVo> getRiskStatisticData(RiskQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.riskBasicService.getRiskStatisticData(param));
    }

    @GetMapping(value={"/listSourceByRiskId"})
    @ApiEncrypt(response=true)
    public ResponseData<LayuiGridData<RiskDetailSourceVo>> listSourceByRiskId(RiskQueryParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.riskBasicService.listSourceByRiskId(param));
    }

    @GetMapping(value={"/getRiskDetailAcceptRecordListData"})
    public ResponseData<List<RiskAcceptanceCommonVo>> getRiskDetailAcceptRecordListData(Long sourceId) {
        return ResponseData.success((Object)this.riskProvider.listAcceptanceRecordBySourceId(sourceId));
    }

    @ApiEncrypt(request=true)
    @PostMapping(value={"/rectificationDraftSave"})
    public ResponseData<String> rectificationDraftSave(@RequestBody @Validated RiskAcceptRecordSubmitParam param) {
        this.acceptanceRecordService.rectificationDraftSave(param);
        return ResponseData.success();
    }

    @ApiEncrypt(request=true)
    @PostMapping(value={"/rectificationSubmit"})
    public ResponseData<String> rectificationSubmit(@RequestBody @Validated RiskAcceptRecordSubmitParam param) {
        this.acceptanceRecordService.acceptRecordSubmit(param);
        return ResponseData.success();
    }

    @ApiEncrypt(request=true)
    @PostMapping(value={"/rectificationSubmitBatch"})
    public ResponseData<List<BaseImportDto>> rectificationSubmitBatch(@RequestBody @Validated RiskAcceptRecordSubmitParam param) {
        List<BaseImportDto> errDatas = this.acceptanceRecordService.acceptRecordSubmitBatch(param);
        if (!CollectionUtils.isEmpty(errDatas)) {
            return ResponseData.fail(errDatas);
        }
        return ResponseData.success(errDatas);
    }

    @GetMapping(value={"/listAcceptanceHistory"})
    public ResponseData<List<RiskAcceptanceCommonVo>> listAcceptanceHistory(RiskQueryCommonParam param) {
        return ResponseData.success((Object)this.acceptanceProvider.listAcceptanceRecordBySourceId(param.getSourceId()));
    }

    @GetMapping(value={"/getCheckOrgChooseList"})
    public ResponseData<LayuiGridData<ThirdOrgVo>> getCheckOrgChooseList(CheckOrgChooseQueryParam param) {
        return ResponseData.success((Object)this.riskProvider.getCheckOrgChooseList(param));
    }

    @PostMapping(value={"/exportRiskList"}, produces={"application/octet-stream"})
    public void exportCompanyList(HttpServletResponse response, @RequestBody RiskQueryParam param) {
        List<?> list = this.riskBasicService.getExportListSourceByRiskId(param);
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode(String.format("\u98ce\u9669\u5316\u89e3\u7ba1\u7406\u6e05\u5355%s-%s.xlsx", LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE), RiskTypeEnum.getName((Integer)param.getRiskType())), StandardCharsets.UTF_8).replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName);
            ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), this.getExportClassByRiskType(param.getRiskType())).registerWriteHandler((WriteHandler)new CustomCellWriteWidthConfig())).sheet("Sheet1").doWrite(list);
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51faExcel\u5f02\u5e38\uff0c\u53c2\u6570: {}", (Object)param, (Object)e);
        }
    }

    @Log(type=LogTypeEnum.type_opt_import, logModule=LogModuleTypeEnum.com_risk_association, title="\u98ce\u9669\u6279\u91cf\u6574\u6539\u5bfc\u5165")
    @PostMapping(value={"/batchChooseImport"})
    public ResponseData<List<RiskBatchChooseImportDto>> batchChooseImport(@NotNull(message="\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a") Long fileId, @NotNull(message="\u98ce\u9669\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") @NotNull(message="\u98ce\u9669\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") Integer riskType, Integer healthRiskPostType) throws Exception {
        this.logger.info("\u98ce\u9669\u6574\u6539\u6279\u91cf\u9009\u62e9\u5bfc\u5165\uff1afileId={}", (Object)fileId);
        SysFileVo file = this.sysFileProvideService.getFileById(fileId);
        if (Objects.isNull(file)) {
            return ResponseData.fail((String)"\u6587\u4ef6\u4e22\u5931");
        }
        RiskBatchChooseImportListener readListener = new RiskBatchChooseImportListener(this.riskBasicSourceService, riskType, healthRiskPostType);
        try {
            InputStream inputStream = this.ossClientBean.getInputStreamByUrl(file.getFullOssUrl());
            inputStream.close();
            ((ExcelReaderSheetBuilder)EasyExcel.read((InputStream)inputStream, RiskBatchChooseImportDto.class, (ReadListener)readListener).sheet().headRowNumber(Integer.valueOf(1))).doRead();
        }
        catch (ExcelDataConvertException e) {
            this.logger.error("\u98ce\u9669\u6279\u91cf\u6574\u6539\u5bfc\u5165\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return ResponseData.fail((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u65e5\u671f\u683c\u5f0f\uff01");
        }
        catch (Exception e) {
            this.logger.error("\u98ce\u9669\u6279\u91cf\u6574\u6539\u5bfc\u5165\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            return ResponseData.fail((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\uff01");
        }
        return ResponseData.success(readListener.getList());
    }

    private Class<?> getExportClassByRiskType(Integer riskType) {
        if (riskType == null) {
            return null;
        }
        if (riskType.equals(RiskTypeEnum.PERFORMANCE_TEST.getValue()) || riskType.equals(RiskTypeEnum.EXCEPTION_PERFORMANCE_TEST.getValue())) {
            return RiskBatchChooseExportDto1.class;
        }
        if (riskType.equals(RiskTypeEnum.PLACE_TEST.getValue()) || riskType.equals(RiskTypeEnum.EXCEPTION_PLACE_TEST.getValue())) {
            return RiskBatchChooseExportDto2.class;
        }
        if (riskType.equals(RiskTypeEnum.PHYSICAL_EXAMINATION.getValue()) || riskType.equals(RiskTypeEnum.PHYSICAL_EXCEPTION_OCC.getValue()) || riskType.equals(RiskTypeEnum.PHYSICAL_EXCEPTION_CONTRAINDICATION.getValue()) || riskType.equals(RiskTypeEnum.PHYSICAL_EXCEPTION_REVIEW.getValue())) {
            return RiskBatchChooseExportDto3.class;
        }
        if (riskType.equals(RiskTypeEnum.DOSE_MONITORING.getValue()) || riskType.equals(RiskTypeEnum.DOSE_EXCEPTION_OVERDOSE.getValue())) {
            return RiskBatchChooseExportDto4.class;
        }
        if (riskType.equals(RiskTypeEnum.TRAINING.getValue())) {
            return RiskBatchChooseExportDto5.class;
        }
        return RiskBatchChooseExportDto1.class;
    }

    @ApiEncrypt(response=true)
    @GetMapping(value={"/getHistoryAcceptRecord"})
    public ResponseData<RiskAcceptanceHistoryVo> getHistoryAcceptRecord(Long sourceId) {
        return ResponseData.success((Object)this.riskProvider.getHistoryAcceptRecord(sourceId));
    }
}

