/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.rho.modules.company.controller.license;

import cn.smarthse.framework.core.domain.ResponseData;
import cn.smarthse.framework.oss.bean.OssClientBean;
import cn.smarthse.framework.web.core.ControllerSupport;
import cn.smarthse.rho.core.framework.model.LayuiGridData;
import cn.smarthse.rho.modules.company.bootstrap.security.utils.ShiroUtil;
import cn.smarthse.rho.modules.company.easyexcel.DeviceForLicenseImportListener;
import cn.smarthse.rho.modules.company.service.e.IEdeviceService;
import cn.smarthse.rho.modules.sys.model.b.param.license.BChangeLicenseDeviceParam;
import cn.smarthse.rho.modules.sys.model.b.param.license.BChangeLicenseGenParam;
import cn.smarthse.rho.modules.sys.model.b.param.license.ChangeLicenseParam;
import cn.smarthse.rho.modules.sys.model.b.vo.BCertVo;
import cn.smarthse.rho.modules.sys.model.b.vo.BCompanyVo;
import cn.smarthse.rho.modules.sys.model.b.vo.license.ChangeLicenseListVo;
import cn.smarthse.rho.modules.sys.model.e.param.ERelationDto;
import cn.smarthse.rho.modules.sys.model.e.vo.EDeviceForLicenseVo;
import cn.smarthse.rho.modules.sys.model.sys.vo.SysFileVo;
import cn.smarthse.rho.modules.sys.provider.company.IBCertProvider;
import cn.smarthse.rho.modules.sys.provider.company.IChangeLicenseProvider;
import cn.smarthse.rho.modules.sys.provider.company.ICompanyProvider;
import cn.smarthse.rho.modules.sys.provider.sys.ISysFileProvider;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.longconverter.LongStringConverter;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.excel.read.listener.ReadListener;
import com.alibaba.excel.read.metadata.ReadSheet;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.smarthse.framework.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/change/license"})
public class ChangeLicenseController
extends ControllerSupport {
    @DubboReference
    private IChangeLicenseProvider changeLicenseProvider;
    @DubboReference
    private IBCertProvider companyCertProvider;
    @DubboReference
    private ICompanyProvider companyProvider;
    @Autowired
    private IEdeviceService deviceService;
    @DubboReference
    private ISysFileProvider sysFileProvideService;
    private final OssClientBean ossClientBean;

    @GetMapping(value={"/changeLicenseList"})
    public ResponseData<LayuiGridData<ChangeLicenseListVo>> getChangeLicenseList(ChangeLicenseParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.changeLicenseProvider.getChangeLicenseList(param));
    }

    @GetMapping(value={"/info"})
    public ResponseData<ChangeLicenseListVo> getInfo(ChangeLicenseParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success((Object)this.changeLicenseProvider.getInfo(param));
    }

    @PostMapping(value={"/apply"})
    public ResponseData<String> applyChange(@RequestBody BChangeLicenseGenParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        this.changeLicenseProvider.applyChange(param);
        return ResponseData.success();
    }

    @GetMapping(value={"/cert"})
    public ResponseData<BCertVo> getBaseInfoForChangeLicense() {
        return ResponseData.success((Object)this.companyCertProvider.getBaseInfoForChangeLicense(ShiroUtil.getLoginUserCid()));
    }

    @GetMapping(value={"/company"})
    public ResponseData<BCompanyVo> getBaseInfoForLicense() {
        return ResponseData.success((Object)this.companyProvider.getBaseInfoForLicense(ShiroUtil.getLoginUserCid()));
    }

    @GetMapping(value={"/listDeviceForLicense"})
    public ResponseData<LayuiGridData<EDeviceForLicenseVo>> listDeviceForLicense(BChangeLicenseDeviceParam param) {
        param.setCid(ShiroUtil.getLoginUserCid());
        return ResponseData.success(this.deviceService.listDeviceForLicense(param));
    }

    @GetMapping(value={"/listRoomForLicenseDevice"})
    public ResponseData<List<ERelationDto>> listRoomForLicenseDevice(BChangeLicenseDeviceParam param) {
        return ResponseData.success(this.deviceService.listRoomForLicenseDevice(param));
    }

    @PostMapping(value={"/exportDeviceForLicense"}, produces={"application/octet-stream"})
    public void exportDeviceForLicense(HttpServletResponse response, @RequestBody BChangeLicenseDeviceParam param) {
        param.setLimit(Integer.MAX_VALUE);
        param.setCid(ShiroUtil.getLoginUserCid());
        LayuiGridData<EDeviceForLicenseVo> layuiGridData = this.deviceService.listDeviceForLicense(param);
        List list = layuiGridData.getData();
        try {
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("utf-8");
            String fileName = URLEncoder.encode(String.format("\u8bbe\u5907\u6e05\u5355%s.xlsx", LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE)), "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-disposition", "attachment;filename=" + fileName);
            ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), EDeviceForLicenseVo.class).registerConverter((Converter)new LongStringConverter())).sheet("Sheet1").doWrite((Collection)list);
        }
        catch (Exception e) {
            this.logger.error("Exception:{}", (Throwable)e);
        }
    }

    @GetMapping(value={"/feedbackDeviceIdForLicense"})
    public ResponseData<List<EDeviceForLicenseVo>> feedbackDeviceIdForLicense(BChangeLicenseDeviceParam param) {
        SysFileVo file = this.sysFileProvideService.getFileById(param.getFileId());
        if (Objects.isNull(file)) {
            throw new ServiceException("\u6587\u4ef6\u7f3a\u5931");
        }
        List<Object> rst = new ArrayList();
        try {
            InputStream inputStream = this.ossClientBean.getInputStreamByUrl(file.getFullOssUrl());
            ExcelReader excelReader = EasyExcel.read((InputStream)inputStream).build();
            inputStream.close();
            param.setLimit(Integer.MAX_VALUE);
            param.setCid(ShiroUtil.getLoginUserCid());
            LayuiGridData<EDeviceForLicenseVo> layuiGridData = this.deviceService.listDeviceForLicense(param);
            List list = layuiGridData.getData();
            Map<Long, EDeviceForLicenseVo> map = list.stream().collect(Collectors.toMap(EDeviceForLicenseVo::getId, v -> v));
            DeviceForLicenseImportListener readListener = new DeviceForLicenseImportListener(this.deviceService, param, map);
            excelReader.read(new ReadSheet[]{((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)((ExcelReaderSheetBuilder)EasyExcel.readSheet((String)"Sheet1").headRowNumber(Integer.valueOf(1))).head(EDeviceForLicenseVo.class)).registerReadListener((ReadListener)readListener)).build()});
            List<EDeviceForLicenseVo> failList = readListener.getFailList();
            if (!failList.isEmpty()) {
                throw new ServiceException("\u8bf7\u52ff\u5bfc\u5165\u4e0d\u7b26\u5408\u7684\u6570\u636e");
            }
            rst = readListener.getSuccessList();
        }
        catch (Exception e) {
            this.logger.error("\u8bbe\u5907\u8bb8\u53ef\u6279\u91cf\u5bfc\u5165\u5931\u8d25", (Throwable)e);
            throw new ServiceException("\u8bbe\u5907\u8bb8\u53ef\u6279\u91cf\u5bfc\u5165\u5931\u8d25");
        }
        return ResponseData.success(rst);
    }

    @Generated
    public ChangeLicenseController(OssClientBean ossClientBean) {
        this.ossClientBean = ossClientBean;
    }
}

